/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.templates;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.IUpdate;

public class TextViewerAction
extends Action
implements IUpdate {
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;

    public TextViewerAction(ITextViewer viewer, int operationCode) {
        this.fOperationCode = operationCode;
        this.fOperationTarget = viewer.getTextOperationTarget();
        this.update();
    }

    @Override
    public void update() {
        if (this.fOperationCode == 1 || this.fOperationCode == 2) {
            return;
        }
        boolean wasEnabled = this.isEnabled();
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(isEnabled);
        if (wasEnabled != isEnabled) {
            this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void run() {
        if (this.fOperationCode != -1 && this.fOperationTarget != null) {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }
}

