/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.core;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class Message
implements IMessage {
    private String id;
    private String[] params;
    private int severity = -1;
    private Object targetObject;
    private String bundleName;
    private String groupName;
    private int lineNumber = 0;
    private int length = -1;
    private int offset = -1;
    private HashMap<String, Object> messageAttributes;
    private String markerId;

    public Message() {
    }

    public Message(String aBundleName, int aSeverity, String anId) {
        this(aBundleName, aSeverity, anId, null, null);
    }

    public Message(String aBundleName, int aSeverity, String anId, String[] aParams) {
        this(aBundleName, aSeverity, anId, aParams, null);
    }

    public Message(String aBundleName, int aSeverity, String anId, String[] aParams, Object aTargetObject) {
        this.bundleName = aBundleName;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.targetObject = aTargetObject;
    }

    public Message(String aBundleName, int aSeverity, String anId, String[] aParams, Object aTargetObject, String aGroupName) {
        this.bundleName = aBundleName;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.targetObject = aTargetObject;
        this.groupName = aGroupName;
    }

    public ResourceBundle getBundle(Locale locale, ClassLoader classLoader) {
        ResourceBundle bundle = null;
        try {
            bundle = classLoader == null ? ResourceBundle.getBundle(this.getBundleName(), locale) : ResourceBundle.getBundle(this.getBundleName(), locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            bundle = this.getFrameworkBundle(locale);
        }
        return bundle;
    }

    private ResourceBundle getFrameworkBundle(Locale locale) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(this.getBundleName(), locale, this.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        return bundle;
    }

    @Override
    public String getBundleName() {
        return this.bundleName;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String[] getParams() {
        return this.params;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public Object getTargetObject() {
        return this.targetObject;
    }

    @Override
    public String getText() {
        return this.getText(Locale.getDefault(), null);
    }

    @Override
    public String getText(ClassLoader classLoader) {
        return this.getText(Locale.getDefault(), classLoader);
    }

    @Override
    public String getText(Locale locale) {
        return this.getText(locale, null);
    }

    @Override
    public String getText(Locale locale, ClassLoader classLoader) {
        String message = "";
        if (locale == null) {
            return message;
        }
        ResourceBundle bundle = this.getBundle(locale, classLoader);
        if (bundle == null) {
            return message;
        }
        try {
            message = bundle.getString(this.getId());
            if (this.getParams() != null) {
                message = MessageFormat.format(message, this.getParams());
            }
        }
        catch (MissingResourceException exc) {
            System.err.println(exc.getMessage());
            System.err.println(this.getId());
        }
        catch (NullPointerException exc) {
            System.err.println(exc.getMessage());
            System.err.println(this.getId());
        }
        return message;
    }

    @Override
    public void setBundleName(String aBundleName) {
        this.bundleName = aBundleName;
    }

    @Override
    public void setGroupName(String name) {
        this.groupName = name;
    }

    @Override
    public void setId(String newId) {
        this.id = newId;
    }

    @Override
    public void setLength(int length) {
        if (length < 0) {
            length = -1;
        }
        this.length = length;
    }

    @Override
    public void setLineNo(int lineNumber) {
        this.lineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    @Override
    public void setOffset(int offset) {
        if (offset < 0) {
            offset = -1;
        }
        this.offset = offset;
    }

    @Override
    public void setParams(String[] newParams) {
        this.params = newParams;
    }

    @Override
    public void setSeverity(int newSeverity) {
        this.severity = newSeverity;
    }

    @Override
    public void setTargetObject(Object obj) {
        this.targetObject = obj;
    }

    @Override
    public Object getAttribute(String attributeName) {
        if (this.messageAttributes != null) {
            return this.messageAttributes.get(attributeName);
        }
        return null;
    }

    @Override
    public void setAttribute(String attributeName, Object value) {
        if (this.messageAttributes == null) {
            this.messageAttributes = new HashMap();
        }
        this.messageAttributes.put(attributeName, value);
    }

    @Override
    public HashMap<String, Object> getAttributes() {
        return this.messageAttributes;
    }

    @Override
    public String getMarkerId() {
        return this.markerId;
    }

    @Override
    public void setMarkerId(String markerId) {
        this.markerId = markerId;
    }
}

