/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.internal.core.services.local.LocalProcessBuilder;

public class LocalProcessService
implements IRemoteProcessService {
    private final IRemoteConnection remoteConnection;
    private String workingDirectory;

    public LocalProcessService(IRemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
    }

    @Override
    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    @Override
    public Map<String, String> getEnv() {
        return System.getenv();
    }

    @Override
    public String getEnv(String name) {
        return System.getenv(name);
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(List<String> command) {
        return new LocalProcessBuilder(this.remoteConnection, command);
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(String ... command) {
        return new LocalProcessBuilder(this.remoteConnection, command);
    }

    @Override
    public String getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = System.getProperty("user.home");
            if (this.workingDirectory == null) {
                this.workingDirectory = System.getProperty("user.dir");
                if (this.workingDirectory == null) {
                    this.workingDirectory = Path.ROOT.toOSString();
                }
            }
        }
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(String path) {
        this.workingDirectory = path;
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        @Override
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (IRemoteProcessService.class.equals(service)) {
                return (T)new LocalProcessService(remoteConnection);
            }
            return null;
        }
    }
}

