/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.util.ProductPreferences;

public class CssUtil {
    private static final String cssLink1 = "<link rel=\"stylesheet\" href=\"";
    private static final String cssLink2 = "\" type=\"text/css\"></link>\n";

    private static String replaceParameters(String input) {
        String OS = "${os}";
        int index = input.indexOf("${os}");
        if (index < 0) {
            return input;
        }
        String result = input.substring(0, index) + Platform.getOS() + input.substring(index + "${os}".length());
        return CssUtil.replaceParameters(result);
    }

    public static String[] getCssFilenames(String filenames) {
        if (filenames == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(filenames, ",");
        String[] result = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            result[i] = CssUtil.replaceParameters(tok.nextToken().trim());
            ++i;
        }
        return result;
    }

    public static void addCssFiles(String preference, List<String> list) {
        String topicCssPath = Platform.getPreferencesService().getString("org.eclipse.help.base", preference, "", null);
        String[] cssFiles = CssUtil.getCssFilenames(topicCssPath);
        Collections.addAll(list, cssFiles);
    }

    public static String createCssIncludes(List<String> cssFiles, String backPath) {
        StringBuilder script = new StringBuilder();
        for (String cssPath : cssFiles) {
            script.append(cssLink1);
            script.append(CssUtil.fixCssPath(cssPath, backPath));
            script.append(cssLink2);
        }
        return script.toString();
    }

    private static String fixCssPath(String path, String prefix) {
        String newPath = ProductPreferences.resolveSpecialIdentifiers((String)path);
        return prefix + "content" + newPath;
    }
}

