/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.text.MessageFormat;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class SourceNotFoundEditorInput
extends PlatformObject
implements IEditorInput {
    private final IStackFrame fFrame;
    private final String fFrameText;

    public SourceNotFoundEditorInput(IStackFrame frame) {
        this.fFrame = frame;
        IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation(frame.getModelIdentifier());
        this.fFrameText = pres.getText(frame);
        pres.dispose();
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugUITools.getDefaultImageDescriptor(this.fFrame);
    }

    public String getName() {
        try {
            return this.fFrame.getName();
        }
        catch (DebugException e) {
            return DebugUIViewsMessages.SourceNotFoundEditorInput_Source_Not_Found_1;
        }
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return MessageFormat.format(DebugUIViewsMessages.SourceNotFoundEditorInput_Source_not_found_for__0__2, this.fFrameText);
    }
}

