/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.xml;

import java.util.Vector;
import org.eclipse.equinox.internal.util.string.CharBuffer;
import org.eclipse.equinox.internal.util.xml.TagClass;
import org.eclipse.equinox.internal.util.xml.XMLReader;

public class XMLUtil {
    public static String[] coded = new String[]{"&amp;", "&nbsp;", "&crlf;", "&tab;", "&lt;", "&gt;", "&quot;", "&apos;"};
    public static String[] decoded = new String[]{"&", " ", "\n", "\t", "<", ">", "\"", "'"};
    protected static final String[] f_entities = new String[]{"amp", "nbsp", "crlf", "tab", "lt", "gt", "quot", "apos"};
    protected static final char[] f_ent_chars = new char[]{'&', ' ', '\n', '\t', '<', '>', '\"', '\''};

    public static String replaceChars(String str, String[] toBeReplaced, String[] replaceWith, int length) {
        int i = 0;
        while (i < length) {
            CharBuffer strBuf = new CharBuffer();
            XMLUtil.replace(str, toBeReplaced[i], replaceWith[i], strBuf);
            str = strBuf.toString();
            ++i;
        }
        return str;
    }

    public static void replace(String src, String toBeReplaced, String toReplaceWith, CharBuffer strBuf) {
        int j;
        int pos = 0;
        int length = toBeReplaced.length();
        while ((j = src.indexOf(toBeReplaced, pos)) > -1) {
            strBuf.append(src.substring(pos, j));
            strBuf.append(toReplaceWith);
            pos = j + length;
        }
        strBuf.append(src.substring(pos));
    }

    public static String getDecoded(String src) {
        int begin = src.indexOf(38);
        if (begin == -1) {
            return src;
        }
        int end = src.indexOf(59, begin);
        if (end == -1) {
            return src;
        }
        int lastBegin = 0;
        CharBuffer strBuf = new CharBuffer();
        while (begin != -1) {
            end = src.indexOf(59, begin);
            if (end == -1) {
                strBuf.append(src.substring(begin));
                return strBuf.toString();
            }
            strBuf.append(src.substring(lastBegin, begin));
            String part = src.substring(begin, end + 1);
            boolean found = false;
            int i = 0;
            while (i < decoded.length) {
                if (part.equals(coded[i])) {
                    strBuf.append(decoded[i]);
                    lastBegin = begin += part.length();
                    begin = src.indexOf(38, lastBegin);
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) continue;
            strBuf.append(part);
            lastBegin = begin += part.length();
            begin = src.indexOf(38, begin);
        }
        strBuf.append(src.substring(lastBegin));
        return strBuf.toString().intern();
    }

    public static String getTagName(String tagAndAttributes) {
        int nameIndex = tagAndAttributes.indexOf(32);
        if (nameIndex != -1) {
            int tabIndex = tagAndAttributes.indexOf(9);
            if (tabIndex > -1 && tabIndex < nameIndex) {
                return tagAndAttributes.substring(0, tabIndex);
            }
            return tagAndAttributes.substring(0, nameIndex);
        }
        nameIndex = tagAndAttributes.indexOf(47);
        if (nameIndex != -1) {
            return tagAndAttributes.substring(0, nameIndex);
        }
        return tagAndAttributes;
    }

    public static boolean isEmptyTag(String tagName) {
        return '/' == tagName.charAt(tagName.length() - 1);
    }

    private static boolean substituteEntity(String ent, CharBuffer cb) {
        int j = 0;
        while (j < f_entities.length) {
            if (f_entities[j].equals(ent)) {
                cb.append(f_ent_chars[j]);
                return true;
            }
            ++j;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static String getAttributeValue(String tag, String att, int begin) {
        if (att.length() == 0) {
            return null;
        }
        start = 0;
        while (start >= 0) {
            if ((start = tag.indexOf(att, start)) < 0) continue;
            b1 = start > 0 ? XMLReader.isNameChar(tag.charAt(start - 1)) : true;
            b2 = start + att.length() + 1 < tag.length() ? XMLReader.isNameChar(tag.charAt(start + att.length())) : true;
            start += att.length();
            if (b1 || b2) continue;
            if ((start = tag.indexOf(61, start) + 1) > 0) ** GOTO lbl13
            return null;
lbl-1000:
            // 1 sources

            {
                ++start;
lbl13:
                // 2 sources

                ** while (start < tag.length() && Character.isWhitespace((char)tag.charAt((int)start)))
            }
lbl14:
            // 1 sources

            quot = tag.charAt(start);
            end = tag.indexOf(quot, start + 1);
            if (start != -1 && end > start) {
                pos = tag.indexOf(38, start + 1);
                if (pos < 0 || pos > end) {
                    return tag.substring(start + 1, end).intern();
                }
                cb = new CharBuffer();
                i = start + 1;
                while (i < end) {
                    ch = tag.charAt(i);
                    if (ch == '&') {
                        pos = tag.indexOf(59, i);
                        ent = tag.substring(i + 1, pos);
                        if (XMLUtil.substituteEntity(ent, cb)) {
                            i = pos;
                        } else {
                            cb.append('&');
                            cb.append(ent);
                            cb.append(';');
                            i = pos;
                        }
                    } else {
                        cb.append(ch);
                    }
                    ++i;
                }
                return cb.toString().intern();
            }
            start = end;
        }
        return null;
    }

    public static Vector getAttributeNames(String tag) {
        Vector<String> names = new Vector<String>();
        int start = tag.indexOf(32);
        while (start != -1) {
            int end = tag.indexOf(61, start + 1);
            if (end == -1) break;
            names.addElement(tag.substring(start + 1, end));
            start = tag.indexOf(34, end + 1);
            if (start == -1 || (start = tag.indexOf(34, start + 1)) == -1) break;
            start = tag.indexOf(32, start + 1);
        }
        return names;
    }

    public static Vector getAttributeValues(String tag) {
        Vector<String> values = new Vector<String>();
        int start = tag.indexOf(61);
        while (start != -1) {
            start = tag.indexOf(34, start + 1);
            int end = tag.indexOf(34, start + 1);
            if (start == -1 || end == -1) break;
            values.addElement(tag.substring(start + 1, end).intern());
            start = tag.indexOf(61, end + 1);
        }
        return values;
    }

    public static String getContent(TagClass tag, int pos, String name) throws IllegalArgumentException {
        TagClass subTag = tag.getTagAt(pos);
        if (subTag.getName().equals(name)) {
            return subTag.getContent();
        }
        throw new IllegalArgumentException("Missing subtag " + name + " in " + tag.getName());
    }
}

