/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.mock.MockContentDescription;
import org.eclipse.jst.jsf.test.util.mock.MockContentTypeManager;
import org.eclipse.jst.jsf.test.util.mock.MockResource;

public class MockFile
extends MockResource
implements IFile {
    private byte[] _contents;
    private File _concreteFile;
    private MockContentTypeManager _contentTypeManager;

    public MockFile(IPath path) {
        super(1, path);
    }

    public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
        this.setContents(source, 0, monitor);
    }

    public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String getCharset() throws CoreException {
        return "UTF-8";
    }

    public String getCharset(boolean checkImplicit) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IContentDescription getContentDescription() throws CoreException {
        IContentType[] contentType = this._contentTypeManager.findContentTypesFor(this.getName());
        if (contentType != null && contentType.length > 0) {
            return new MockContentDescription(contentType[0]);
        }
        return new MockContentDescription();
    }

    public void setContentTypeManager(MockContentTypeManager contentTypeManager) {
        this._contentTypeManager = contentTypeManager;
    }

    public InputStream getContents() throws CoreException {
        return this.getContents(false);
    }

    public InputStream getContents(boolean force) throws CoreException {
        return new ByteArrayInputStream(this._contents);
    }

    public int getEncoding() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setCharset(String newCharset) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        ByteArrayOutputStream captureBytes;
        try {
            captureBytes = JSFTestUtil.loadFromInputStream(source);
            if (this._concreteFile != null && this._concreteFile.exists()) {
                JSFTestUtil.saveToFileSystem(captureBytes.toByteArray(), this._concreteFile.toURI());
            }
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.test.util", "Failed loading mock contents from stream"));
        }
        this._contents = captureBytes.toByteArray();
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.setContents(source.getContents(), force, keepHistory, monitor);
    }

    public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.setContents(source, (updateFlags | 1) != 0, (updateFlags | 2) != 0, monitor);
    }

    public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.setContents(source, (updateFlags | 1) != 0, (updateFlags | 2) != 0, monitor);
    }

    @Override
    public IPath getLocation() {
        File concreteFile = this.ensureConcreteFile();
        return Path.fromOSString((String)concreteFile.getAbsolutePath());
    }

    private File ensureConcreteFile() {
        if (this._concreteFile == null) {
            String tempFileName = this.getFullPath().toString().replace('/', '_');
            try {
                this._concreteFile = File.createTempFile(tempFileName, "." + this.getFullPath().getFileExtension());
                this._concreteFile.deleteOnExit();
                Assert.assertTrue((boolean)this._concreteFile.exists());
                if (this._contents != null) {
                    JSFTestUtil.saveToFileSystem(this._contents, this._concreteFile.toURI());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this._concreteFile;
    }
}

