/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection.internal.dispatcher;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dali.ui.selection.ISelectionListener;
import org.eclipse.dali.ui.selection.dispatcher.ISelectionDispatcher;
import org.eclipse.dali.ui.selection.notification.ISelectionNotification;
import org.eclipse.dali.ui.selection.notification.SelectionNotification;
import org.eclipse.dali.ui.selection.notification.SelectionNotificationEvent;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;

public class SelectionDispatcher
implements ISelectionDispatcher {
    private final EClass ALL = EcoreFactory.eINSTANCE.createEObject().eClass();
    private Map listeners = Collections.synchronizedMap(new HashMap());
    private Map eventHistory = Collections.synchronizedMap(new HashMap());

    public void register(ISelectionListener aListener, List aList) {
        Iterator itr = aList.iterator();
        while (itr.hasNext()) {
            EClass anEClass = (EClass)itr.next();
            this.put(anEClass, aListener);
            if (!this.eventHistory.containsKey(anEClass)) continue;
            ISelectionNotification notification = (ISelectionNotification)this.eventHistory.get(anEClass);
            ((SelectionNotification)notification).setEvent(SelectionNotificationEvent.INITIALIZED);
            this.sendEvent(aListener, notification);
        }
    }

    private void put(EClass anEClass, ISelectionListener aListener) {
        LinkedHashSet<ISelectionListener> aSet = (LinkedHashSet<ISelectionListener>)this.listeners.get(anEClass);
        if (aSet == null) {
            aSet = new LinkedHashSet<ISelectionListener>();
            this.listeners.put(anEClass, aSet);
        }
        aSet.add(aListener);
    }

    public void deregister(ISelectionListener aListener) {
        Iterator itr = this.listeners.values().iterator();
        while (itr.hasNext()) {
            Set aSet = (Set)itr.next();
            aSet.remove(aListener);
        }
    }

    public void notifyChanged(ISelectionNotification aNotification) {
        this.maintainEventHistory(aNotification);
        if (aNotification.isDeselection()) {
            HashSet set = new HashSet();
            Iterator itr = this.listeners.values().iterator();
            while (itr.hasNext()) {
                set.addAll((Collection)itr.next());
            }
            this.sendEvent(set, aNotification);
        } else {
            EClass eClass = aNotification.getSelection().eClass();
            this.sendEvent((Set)this.listeners.get(eClass), aNotification);
            this.sendEvent((Set)this.listeners.get(this.ALL), aNotification);
            Iterator itr = aNotification.getIndirectSelections().iterator();
            while (itr.hasNext()) {
                eClass = ((EObject)itr.next()).eClass();
                this.sendEvent((Set)this.listeners.get(eClass), aNotification);
            }
        }
    }

    public EObject getCurrentSelection(EClass anEClass) {
        if (this.eventHistory.containsKey(anEClass)) {
            ISelectionNotification notification = (ISelectionNotification)this.eventHistory.get(anEClass);
            return notification.getSelectionForType(anEClass);
        }
        return null;
    }

    private void maintainEventHistory(ISelectionNotification aNotification) {
        if (aNotification.isDeselection()) {
            this.eventHistory.clear();
        } else if (aNotification.getEvent() == SelectionNotificationEvent.CLOSED) {
            this.eventHistory.remove(aNotification.getSelection().eClass());
            Iterator itr = aNotification.getIndirectSelections().iterator();
            while (itr.hasNext()) {
                EClass eClass = ((EObject)itr.next()).eClass();
                this.eventHistory.remove(eClass);
            }
        } else {
            this.eventHistory.put(aNotification.getSelection().eClass(), aNotification);
            Iterator itr = aNotification.getIndirectSelections().iterator();
            while (itr.hasNext()) {
                EClass eClass = ((EObject)itr.next()).eClass();
                this.eventHistory.put(eClass, aNotification);
            }
        }
    }

    private void sendEvent(ISelectionListener aListener, ISelectionNotification aNotification) {
        if (aNotification != null && aNotification.getEventView() == null || aNotification != null && !aNotification.getEventView().equals(aListener.getView())) {
            aListener.selectionChanged(aNotification);
        }
    }

    private void sendEvent(Set aSet, ISelectionNotification aNotification) {
        if (aSet != null && aNotification != null) {
            Iterator itr = aSet.iterator();
            while (itr.hasNext()) {
                ISelectionListener listener = (ISelectionListener)itr.next();
                this.sendEvent(listener, aNotification);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator itr = this.listeners.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            EClass eClass = (EClass)entry.getKey();
            buf.append(eClass.getName());
            buf.append("\n");
            Iterator itr2 = ((Set)entry.getValue()).iterator();
            while (itr2.hasNext()) {
                ISelectionListener listener = (ISelectionListener)itr2.next();
                buf.append(listener.getClass());
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

