/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.util.jdt;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JDTTools {
    public static IImportDeclaration addImport(ICompilationUnit compilationUnit, String importElement) {
        try {
            return compilationUnit.createImport(importElement, null, null);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static IImportDeclaration addStaticImport(ICompilationUnit compilationUnit, String importElement) {
        try {
            return compilationUnit.createImport(importElement, null, 8, null);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static CompilationUnit createASTRoot(IMember member) {
        ASTParser parser = ASTParser.newParser((int)3);
        if (member.isBinary()) {
            parser.setSource(member.getClassFile());
        } else {
            parser.setSource(member.getCompilationUnit());
        }
        return (CompilationUnit)parser.createAST(null);
    }

    public static boolean checkFlags(int flags, int flagToCheck) {
        return (flags & flagToCheck) != 0;
    }

    public static boolean checkFlagsForAll(int flags, int[] flagsToCheck) {
        if (flagsToCheck.length == 0) {
            return true;
        }
        int i = flagsToCheck.length - 1;
        while (i >= 0) {
            if (!JDTTools.checkFlags(flags, flagsToCheck[i])) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean checkFlagsForAny(int flags, int[] flagsToCheck) {
        if (flagsToCheck.length == 0) {
            return true;
        }
        int i = flagsToCheck.length - 1;
        while (i >= 0) {
            if (JDTTools.checkFlags(flags, flagsToCheck[i])) {
                return true;
            }
            --i;
        }
        return false;
    }
}

