/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.core.util.jdt.JDTTools;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public abstract class AbstractAnnotationElementAdapter {
    private AnnotationElementInfo info;
    public static final String VALUE_ANNOTATION_ELEMENT = "value";

    public AbstractAnnotationElementAdapter(AnnotationElementInfo info) {
        this.info = info;
    }

    protected AnnotationElementInfo getInfo() {
        return this.info;
    }

    public boolean updatePersElement(CompilationUnit astRoot) {
        String javaValue = this.javaValue(astRoot);
        String persValue = this.info.persValue();
        if (javaValue == null && persValue != null || javaValue != null && !javaValue.equals(persValue)) {
            this.info.setPersValue(javaValue);
            return true;
        }
        return false;
    }

    public boolean updateJavaElement() {
        CompilationUnit astRoot = this.info.member().createASTRoot();
        String javaValue = this.javaValue(astRoot);
        String persValue = this.info.persValue();
        if (persValue == null && javaValue == null) {
            return false;
        }
        if (persValue == null || !persValue.equals(javaValue)) {
            if (persValue == null || persValue.equals(this.info.defaultValue())) {
                this.removeAnnotationElement(astRoot);
            } else {
                this.setJavaValue(persValue);
            }
            return true;
        }
        return false;
    }

    protected Annotation getAnnotation(BodyDeclaration bodyDeclaration) {
        return ASTTools.annotation(bodyDeclaration, this.info.annotationName());
    }

    protected void removeAnnotationElement(CompilationUnit astRoot) {
        this.info.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation annotation = AbstractAnnotationElementAdapter.this.getAnnotation(bodyDeclaration);
                if (annotation == null) {
                    return;
                }
                if (annotation.isSingleMemberAnnotation()) {
                    if (AbstractAnnotationElementAdapter.this.info.annotationElementName() == AbstractAnnotationElementAdapter.VALUE_ANNOTATION_ELEMENT) {
                        if (AbstractAnnotationElementAdapter.this.info.removeAnnotationIfEmpty()) {
                            AbstractAnnotationElementAdapter.this.removeAnnotation(bodyDeclaration, annotation);
                        } else {
                            MarkerAnnotation markerAnnotation = ASTTools.newMarkerAnnotation(bodyDeclaration.getAST(), AbstractAnnotationElementAdapter.this.info.annotationName());
                            ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)markerAnnotation);
                        }
                    }
                } else if (AbstractAnnotationElementAdapter.this.info.removeAnnotationIfEmpty() && ((NormalAnnotation)annotation).values().size() == 1) {
                    AbstractAnnotationElementAdapter.this.removeAnnotation(bodyDeclaration, annotation);
                } else {
                    ASTTools.removeAnnotationElement(bodyDeclaration, annotation, AbstractAnnotationElementAdapter.this.info.annotationElementName());
                }
            }
        });
    }

    protected void removeAnnotation(BodyDeclaration bodyDeclaration, Annotation annotation) {
        ASTTools.removeAnnotation(bodyDeclaration, annotation);
    }

    protected void replaceAnnotation(BodyDeclaration bodyDeclaration, SingleMemberAnnotation annotation, MarkerAnnotation newAnnotation) {
        ASTTools.replaceAnnotation(bodyDeclaration, (Annotation)annotation, (Annotation)newAnnotation);
    }

    protected void addImport() {
        JDTTools.addImport(this.info.member().getJDTMember().getCompilationUnit(), "javax.persistence." + this.info.annotationName());
    }

    protected void setJavaValue(final String javaValue) {
        this.addImport();
        this.info.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation annotation = ASTTools.annotation(bodyDeclaration, AbstractAnnotationElementAdapter.this.info.annotationName());
                AST ast = bodyDeclaration.getAST();
                if (annotation == null) {
                    if (AbstractAnnotationElementAdapter.this.info.annotationElementName() == AbstractAnnotationElementAdapter.VALUE_ANNOTATION_ELEMENT) {
                        if (javaValue == null || javaValue.length() == 0) {
                            MarkerAnnotation markerAnnotation = ASTTools.newMarkerAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                            ASTTools.addAnnotation(bodyDeclaration, (Annotation)markerAnnotation);
                        } else {
                            SingleMemberAnnotation singleMemberAnnotation = ASTTools.newSingleMemberAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                            singleMemberAnnotation.setValue(AbstractAnnotationElementAdapter.this.value(ast, javaValue));
                            ASTTools.addAnnotation(bodyDeclaration, (Annotation)singleMemberAnnotation);
                        }
                    } else {
                        NormalAnnotation normalAnnotation = ASTTools.newNormalAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                        AbstractAnnotationElementAdapter.this.addMemberValuePair(normalAnnotation, AbstractAnnotationElementAdapter.this.info.annotationElementName(), javaValue);
                        ASTTools.addAnnotation(bodyDeclaration, (Annotation)normalAnnotation);
                    }
                } else if (AbstractAnnotationElementAdapter.this.info.annotationElementName() == AbstractAnnotationElementAdapter.VALUE_ANNOTATION_ELEMENT) {
                    if (annotation.isSingleMemberAnnotation()) {
                        if (javaValue == null || javaValue.length() == 0) {
                            MarkerAnnotation markerAnnotation = ASTTools.newMarkerAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                            ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)markerAnnotation);
                        } else {
                            ((SingleMemberAnnotation)annotation).setValue(AbstractAnnotationElementAdapter.this.value(ast, javaValue));
                        }
                    } else if (annotation.isMarkerAnnotation()) {
                        if (javaValue != null && javaValue.length() != 0) {
                            SingleMemberAnnotation singleMemberAnnotation = ASTTools.newSingleMemberAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                            singleMemberAnnotation.setValue(AbstractAnnotationElementAdapter.this.value(ast, javaValue));
                            ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)singleMemberAnnotation);
                        }
                    } else if (annotation.isNormalAnnotation()) {
                        if (javaValue == null || javaValue.length() == 0) {
                            MarkerAnnotation markerAnnotation = ASTTools.newMarkerAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                            ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)markerAnnotation);
                        } else {
                            SingleMemberAnnotation singleMemberAnnotation = ASTTools.newSingleMemberAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                            singleMemberAnnotation.setValue(AbstractAnnotationElementAdapter.this.value(ast, javaValue));
                            ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)singleMemberAnnotation);
                        }
                    }
                } else if (annotation.isNormalAnnotation()) {
                    AbstractAnnotationElementAdapter.this.setJavaValueOn((NormalAnnotation)annotation, ast, javaValue);
                } else {
                    NormalAnnotation normalAnnotation = ASTTools.newNormalAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                    AbstractAnnotationElementAdapter.this.addMemberValuePair(normalAnnotation, AbstractAnnotationElementAdapter.this.info.annotationElementName(), javaValue);
                    ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)normalAnnotation);
                }
            }
        });
    }

    protected void setJavaValueOn(NormalAnnotation annotation, AST ast, String javaValue) {
        MemberValuePair valuePair = ASTTools.memberValuePair(annotation, this.getInfo().annotationElementName());
        if (valuePair != null) {
            valuePair.setValue(this.value(ast, javaValue));
        } else {
            this.addMemberValuePair(annotation, this.info.annotationElementName(), javaValue);
        }
    }

    protected MemberValuePair valuePair(CompilationUnit astRoot) {
        return this.info.member().getMemberValuePair(this.info.annotationName(), this.info.annotationElementName(), astRoot);
    }

    protected String javaValue(CompilationUnit astRoot) {
        Annotation annotation;
        MemberValuePair valuePair = this.valuePair(astRoot);
        if (valuePair != null) {
            return this.valueFromExpression(valuePair.getValue());
        }
        if (this.info.annotationElementName() == VALUE_ANNOTATION_ELEMENT && (annotation = this.info.member().getAnnotation(this.info.annotationName(), astRoot)) != null && annotation.isSingleMemberAnnotation()) {
            Expression singleMemberValue = ((SingleMemberAnnotation)annotation).getValue();
            return this.valueFromExpression(singleMemberValue);
        }
        return this.info.defaultValue();
    }

    protected void addMemberValuePair(NormalAnnotation normalAnnotation, String name, String javaValue) {
        AST ast = normalAnnotation.getAST();
        MemberValuePair valuePair = ast.newMemberValuePair();
        valuePair.setName(ast.newSimpleName(name));
        valuePair.setValue(this.value(ast, javaValue));
        ASTTools.addValuePair(normalAnnotation, valuePair);
    }

    protected abstract Expression value(AST var1, String var2);

    protected abstract String valueFromExpression(Expression var1);

    public ITextRange textRange() {
        CompilationUnit astRoot = this.info.member().createASTRoot();
        MemberValuePair valuePair = this.valuePair(astRoot);
        if (valuePair == null) {
            return null;
        }
        return ASTTools.textRange((ASTNode)valuePair);
    }

    public static interface AnnotationElementInfo {
        public Member member();

        public String annotationName();

        public String annotationElementName();

        public String defaultValue();

        public String persValue();

        public void setPersValue(String var1);

        public boolean removeAnnotationIfEmpty();
    }
}

