/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.Iterator;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.InheritanceType;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PrimaryKeyJoinColumn;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.adapters.IDiscriminatorColumnModelAdapter;
import org.eclipse.dali.orm.adapters.IDiscriminatorValueModelAdapter;
import org.eclipse.dali.orm.adapters.IEntityModelAdapter;
import org.eclipse.dali.orm.adapters.IInheritanceModelAdapter;
import org.eclipse.dali.orm.adapters.IPrimaryKeyJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.EnumAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaDiscriminatorColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaDiscriminatorValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPrimaryKeyJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.SingularPluralTopLevelAnnotationAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.dali.orm.impl.SingleTableInheritanceChildTableImpl;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public class JavaInheritanceModelAdapter
implements IInheritanceModelAdapter {
    private Inheritance inheritance;
    private Type type;
    private EnumAnnotationElementAdapter strategyAdapter;
    private SingularPluralTopLevelAnnotationAdapter primaryKeyJoinColumnsAdapter;
    public static final String INHERITANCE_ANNOTATION = "Inheritance";
    public static final String INHERITANCE_TYPE_JOINED = "JOINED";
    public static final String INHERITANCE_TYPE_SINGLE_TABLE = "SINGLE_TABLE";
    public static final String INHERITANCE_TYPE_TABLE_PER_CLASS = "TABLE_PER_CLASS";
    static final String PRIMARY_KEY_JOIN_COLUMN_ANNOTATION = "PrimaryKeyJoinColumn";
    static final String PRIMARY_KEY_JOIN_COLUMNS_ANNOTATION = "PrimaryKeyJoinColumns";

    JavaInheritanceModelAdapter(Type type) {
        this.type = type;
        this.strategyAdapter = new EnumAnnotationElementAdapter(this.buildStrategyInfo());
        this.primaryKeyJoinColumnsAdapter = new SingularPluralTopLevelAnnotationAdapter(this.buildPrimaryKeyJoinColumnsAnnotationInfo());
    }

    private SingularPluralTopLevelAnnotationAdapter.AnnotationInfo buildPrimaryKeyJoinColumnsAnnotationInfo() {
        return new SingularPluralTopLevelAnnotationAdapter.AnnotationInfo(){

            public boolean supportsDefault() {
                return true;
            }

            public String singularAnnotationName() {
                return JavaInheritanceModelAdapter.PRIMARY_KEY_JOIN_COLUMN_ANNOTATION;
            }

            public String pluralAnnotationName() {
                return JavaInheritanceModelAdapter.PRIMARY_KEY_JOIN_COLUMNS_ANNOTATION;
            }

            public Member member() {
                return JavaInheritanceModelAdapter.this.type();
            }

            public int listSize() {
                return JavaInheritanceModelAdapter.this.getInheritance().getPrimaryKeyJoinColumns().size();
            }

            public boolean isDefault() {
                return JavaInheritanceModelAdapter.this.getInheritance().isDefaultPrimaryKeyJoinColumns();
            }
        };
    }

    public void setInheritance(Inheritance inheritance) {
        this.inheritance = inheritance;
    }

    public IDiscriminatorColumnModelAdapter createDiscriminatorColumnModelAdapter() {
        return new JavaDiscriminatorColumnModelAdapter(this.type());
    }

    public IDiscriminatorValueModelAdapter createDiscriminatorValueModelAdapter() {
        return new JavaDiscriminatorValueModelAdapter(this.type());
    }

    public IPrimaryKeyJoinColumnModelAdapter createPrimaryKeyJoinColumnModelAdapter() {
        return new JavaPrimaryKeyJoinColumnModelAdapter(this.getInheritance(), this.type());
    }

    private EnumAnnotationElementAdapter.EnumAnnotationElementInfo buildStrategyInfo() {
        return new EnumAnnotationElementAdapter.EnumAnnotationElementInfo(){

            public void setPersValue(String inheritanceType) {
                if (inheritanceType == null) {
                    return;
                }
                if (inheritanceType.equals(JavaInheritanceModelAdapter.INHERITANCE_TYPE_JOINED)) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.JOINED_LITERAL);
                } else if (inheritanceType.equals(JavaInheritanceModelAdapter.INHERITANCE_TYPE_SINGLE_TABLE)) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.SINGLE_TABLE_LITERAL);
                } else if (inheritanceType.equals(JavaInheritanceModelAdapter.INHERITANCE_TYPE_TABLE_PER_CLASS)) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.TABLE_PER_CLASS_LITERAL);
                } else if (inheritanceType.equals(InheritanceType.DEFAULT_LITERAL.getName())) {
                    JavaInheritanceModelAdapter.this.getInheritance().setStrategy(InheritanceType.DEFAULT_LITERAL);
                }
            }

            public String persValue() {
                InheritanceType inheritanceType = JavaInheritanceModelAdapter.this.getInheritance().getStrategy();
                if (((Object)((Object)inheritanceType)).equals((Object)InheritanceType.JOINED_LITERAL)) {
                    return JavaInheritanceModelAdapter.INHERITANCE_TYPE_JOINED;
                }
                if (((Object)((Object)inheritanceType)).equals((Object)InheritanceType.SINGLE_TABLE_LITERAL)) {
                    return JavaInheritanceModelAdapter.INHERITANCE_TYPE_SINGLE_TABLE;
                }
                if (((Object)((Object)inheritanceType)).equals((Object)InheritanceType.TABLE_PER_CLASS_LITERAL)) {
                    return JavaInheritanceModelAdapter.INHERITANCE_TYPE_TABLE_PER_CLASS;
                }
                return InheritanceType.DEFAULT_LITERAL.getName();
            }

            public String enumClassName() {
                return "InheritanceType";
            }

            public String annotationElementName() {
                return "strategy";
            }

            public String annotationName() {
                return JavaInheritanceModelAdapter.INHERITANCE_ANNOTATION;
            }

            public Member member() {
                return JavaInheritanceModelAdapter.this.type();
            }

            public String defaultValue() {
                return InheritanceType.DEFAULT_LITERAL.getName();
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    protected Inheritance getInheritance() {
        return this.inheritance;
    }

    private JavaDiscriminatorColumnModelAdapter getDiscriminatorColumnModelAdapter() {
        return (JavaDiscriminatorColumnModelAdapter)this.inheritance.getDiscriminatorColumn().getModelAdapter();
    }

    private JavaDiscriminatorValueModelAdapter getDiscriminatorValueModelAdapter() {
        return (JavaDiscriminatorValueModelAdapter)this.inheritance.getDiscriminatorValue().getModelAdapter();
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.updatePersStrategy(astRoot);
        this.updatePersPrimaryKeyJoinColumns(astRoot);
        this.updatePersDefaultPrimaryKeyJoinColumns(astRoot);
        this.getDiscriminatorColumnModelAdapter().updatePersModel(astRoot);
        this.getDiscriminatorValueModelAdapter().updatePersModel(astRoot);
    }

    void postUpdatePersModel(CompilationUnit astRoot) {
        this.updateEntityTable(astRoot);
        this.postUpdatePersPrimaryKeyJoinColumns(astRoot);
    }

    private void postUpdatePersPrimaryKeyJoinColumns(CompilationUnit astRoot) {
        Iterator i = this.getInheritance().getPrimaryKeyJoinColumns().iterator();
        while (i.hasNext()) {
            ((JavaPrimaryKeyJoinColumnModelAdapter)((PrimaryKeyJoinColumn)i.next()).getModelAdapter()).postUpdatePersModel(astRoot);
        }
    }

    private void updateEntityTable(CompilationUnit astRoot) {
        Entity entity = (Entity)this.getInheritance().getParent();
        InheritanceType rootStrategy = this.getInheritance().rootEntity().getInheritance().getStrategy();
        if (rootStrategy == InheritanceType.SINGLE_TABLE_LITERAL || rootStrategy == InheritanceType.DEFAULT_LITERAL) {
            if (this.getInheritance().rootEntity() != entity) {
                if (!(entity.getTable() instanceof SingleTableInheritanceChildTableImpl)) {
                    JavaTableModelAdapter tableModelAdapter = this.buildNoUpdateJavaTableModelAdapter();
                    Table table = OrmFactory.eINSTANCE.createSingleTableInheritanceChildTable(tableModelAdapter);
                    entity.setTable(table);
                    tableModelAdapter.updatePersModel(astRoot);
                    tableModelAdapter.postUpdatePersModel(astRoot);
                }
            } else if (entity.getTable() instanceof SingleTableInheritanceChildTableImpl) {
                JavaTableModelAdapter tableModelAdapter = (JavaTableModelAdapter)((IEntityModelAdapter)entity.getModelAdapter()).createTableModelAdapter();
                Table table = OrmFactory.eINSTANCE.createTable(tableModelAdapter);
                tableModelAdapter.updatePersModel(astRoot);
                entity.setTable(table);
                tableModelAdapter.postUpdatePersModel(astRoot);
            }
        } else if (entity.getTable() instanceof SingleTableInheritanceChildTableImpl) {
            JavaTableModelAdapter tableModelAdapter = (JavaTableModelAdapter)((IEntityModelAdapter)entity.getModelAdapter()).createTableModelAdapter();
            Table table = OrmFactory.eINSTANCE.createTable(tableModelAdapter);
            tableModelAdapter.updatePersModel(astRoot);
            entity.setTable(table);
            tableModelAdapter.postUpdatePersModel(astRoot);
        }
    }

    private void updatePersPrimaryKeyJoinColumns(CompilationUnit astRoot) {
        Annotation pkJoinColumnAnnotation = this.type().getAnnotation(PRIMARY_KEY_JOIN_COLUMN_ANNOTATION, astRoot);
        int numPKJoinColumns = 0;
        if (pkJoinColumnAnnotation != null) {
            if (this.getInheritance().getPrimaryKeyJoinColumns().size() <= numPKJoinColumns) {
                PrimaryKeyJoinColumn pkJoinColumn = OrmFactory.eINSTANCE.createPrimaryKeyJoinColumn(this.createPrimaryKeyJoinColumnModelAdapter());
                ((JavaPrimaryKeyJoinColumnModelAdapter)pkJoinColumn.getModelAdapter()).updatePersModel(astRoot);
                this.getInheritance().getPrimaryKeyJoinColumns().add((Object)pkJoinColumn);
            } else {
                ((JavaPrimaryKeyJoinColumnModelAdapter)((PrimaryKeyJoinColumn)this.getInheritance().getPrimaryKeyJoinColumns().get(numPKJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
            }
            ++numPKJoinColumns;
        } else {
            Annotation pkJoinColumnsAnnotation = this.type().getAnnotation(PRIMARY_KEY_JOIN_COLUMNS_ANNOTATION, astRoot);
            if (pkJoinColumnsAnnotation != null) {
                MemberValuePair valueValuePair;
                Expression valueExpression = null;
                if (pkJoinColumnsAnnotation.getNodeType() == 79) {
                    valueExpression = ((SingleMemberAnnotation)pkJoinColumnsAnnotation).getValue();
                } else if (pkJoinColumnsAnnotation.getNodeType() == 77 && (valueValuePair = ASTTools.memberValuePair(pkJoinColumnsAnnotation, "value")) != null) {
                    valueExpression = valueValuePair.getValue();
                }
                if (valueExpression != null) {
                    if (valueExpression.getNodeType() == 77) {
                        if (((NormalAnnotation)valueExpression).getTypeName().getFullyQualifiedName().equals(PRIMARY_KEY_JOIN_COLUMN_ANNOTATION)) {
                            if (this.getInheritance().getPrimaryKeyJoinColumns().size() <= numPKJoinColumns) {
                                PrimaryKeyJoinColumn pkJoinColumn = OrmFactory.eINSTANCE.createPrimaryKeyJoinColumn(this.createPrimaryKeyJoinColumnModelAdapter());
                                ((JavaPrimaryKeyJoinColumnModelAdapter)pkJoinColumn.getModelAdapter()).updatePersModel(astRoot);
                                this.getInheritance().getPrimaryKeyJoinColumns().add((Object)pkJoinColumn);
                            } else {
                                ((JavaPrimaryKeyJoinColumnModelAdapter)((PrimaryKeyJoinColumn)this.getInheritance().getPrimaryKeyJoinColumns().get(numPKJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
                            }
                            ++numPKJoinColumns;
                        }
                    } else if (valueExpression.getNodeType() == 4) {
                        Iterator i = ((ArrayInitializer)valueExpression).expressions().iterator();
                        while (i.hasNext()) {
                            Expression expression = (Expression)i.next();
                            if (expression.getNodeType() != 77 || !((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals(PRIMARY_KEY_JOIN_COLUMN_ANNOTATION)) continue;
                            if (this.getInheritance().getPrimaryKeyJoinColumns().size() <= numPKJoinColumns) {
                                PrimaryKeyJoinColumn pkJoinColumn = OrmFactory.eINSTANCE.createPrimaryKeyJoinColumn(this.createPrimaryKeyJoinColumnModelAdapter());
                                ((JavaPrimaryKeyJoinColumnModelAdapter)pkJoinColumn.getModelAdapter()).updatePersModel(astRoot);
                                this.getInheritance().getPrimaryKeyJoinColumns().add((Object)pkJoinColumn);
                            } else {
                                ((JavaPrimaryKeyJoinColumnModelAdapter)((PrimaryKeyJoinColumn)this.getInheritance().getPrimaryKeyJoinColumns().get(numPKJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
                            }
                            ++numPKJoinColumns;
                        }
                    }
                }
            }
        }
        if (numPKJoinColumns != 0 || this.getInheritance().getPrimaryKeyJoinColumns().size() != 1) {
            int i = this.getInheritance().getPrimaryKeyJoinColumns().size();
            while (i > numPKJoinColumns) {
                this.getInheritance().getPrimaryKeyJoinColumns().remove(i - 1);
                --i;
            }
        }
    }

    private void updatePersDefaultPrimaryKeyJoinColumns(CompilationUnit astRoot) {
        int javaNumJoinColumns = this.primaryKeyJoinColumnsAdapter.javaElementsSize(astRoot);
        if (javaNumJoinColumns == 0) {
            this.getInheritance().setDefaultPrimaryKeyJoinColumns(true);
            if (this.getInheritance().getPrimaryKeyJoinColumns().size() == 0) {
                PrimaryKeyJoinColumn joinColumn = OrmFactory.eINSTANCE.createPrimaryKeyJoinColumn(this.createPrimaryKeyJoinColumnModelAdapter());
                ((JavaPrimaryKeyJoinColumnModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
                this.getInheritance().getPrimaryKeyJoinColumns().add((Object)joinColumn);
            } else {
                PrimaryKeyJoinColumn joinColumn = (PrimaryKeyJoinColumn)this.getInheritance().getPrimaryKeyJoinColumns().get(0);
                ((JavaPrimaryKeyJoinColumnModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
            }
        } else {
            this.getInheritance().setDefaultPrimaryKeyJoinColumns(false);
        }
    }

    private JavaTableModelAdapter buildNoUpdateJavaTableModelAdapter() {
        return new JavaTableModelAdapter(this.type()){

            public void specifiedNameChanged() {
            }

            protected String defaultName() {
                return JavaInheritanceModelAdapter.this.getInheritance().rootEntity().getName();
            }

            void updatePersModel(CompilationUnit astRoot) {
            }

            void postUpdatePersModel(CompilationUnit astRoot) {
                this.updatePersSpecifiedName(astRoot);
                this.updatePersDefaultName();
            }
        };
    }

    private void updatePersStrategy(CompilationUnit astRoot) {
        this.strategyAdapter.updatePersElement(astRoot);
    }

    public void strategyChanged() {
        boolean changed = this.strategyAdapter.updateJavaElement();
        if (changed) {
            this.updateEntityTable(this.type().createASTRoot());
        }
    }

    public void defaultPrimaryKeyJoinColumnsChanged() {
        CompilationUnit astRoot = this.type().createASTRoot();
        if (this.primaryKeyJoinColumnsAdapter.javaElementsSize(astRoot) == 0) {
            if (!this.getInheritance().isDefaultPrimaryKeyJoinColumns()) {
                PrimaryKeyJoinColumn defaultJoinColumn = (PrimaryKeyJoinColumn)this.getInheritance().getPrimaryKeyJoinColumns().get(0);
                defaultJoinColumn.setSpecifiedName(defaultJoinColumn.getDefaultName());
                defaultJoinColumn.setSpecifiedReferencedColumnName(defaultJoinColumn.getDefaultReferencedColumnName());
            }
        } else if (this.getInheritance().isDefaultPrimaryKeyJoinColumns()) {
            this.getInheritance().getPrimaryKeyJoinColumns().clear();
        }
    }

    public void primaryKeyJoinColumnAdded() {
        this.primaryKeyJoinColumnsAdapter.modelElementAdded();
    }

    public void primaryKeyJoinColumnRemoved(int position) {
        this.primaryKeyJoinColumnsAdapter.modelElementRemoved(position);
    }

    public Annotation primaryKeyJoinColumnAnnotationAt(int index) {
        return this.primaryKeyJoinColumnsAdapter.annotationAt(index);
    }

    protected Type type() {
        return this.type;
    }

    public ITextRange getTextRange() {
        return this.type().getTextRange(this.annotationName());
    }

    protected String annotationName() {
        return INHERITANCE_ANNOTATION;
    }

    public boolean specifyDiscriminatorValue() {
        return !this.type().isAbstract();
    }
}

