/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.GeneratedValue;
import org.eclipse.dali.orm.GenerationType;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.adapters.IGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.IIdMappingModelAdapter;
import org.eclipse.dali.orm.provider.GeneratedValueItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class GeneratedValueComposite
extends Composite
implements IPersistenceComposite {
    private IdMapping idMapping;
    private GeneratedValue generatedValue;
    private INotifyChangedListener generatedValueListener;
    protected EditingDomain editingDomain;
    protected OrmItemProviderAdapterFactory adapterFactory;
    private GeneratedValueItemProvider generatedValueItemProvider;
    private ComboViewer strategyComboViewer;
    private ITextViewer generatorNameViewer;
    protected boolean populating;
    static /* synthetic */ Class class$0;

    public GeneratedValueComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.generatedValueItemProvider = (GeneratedValueItemProvider)this.adapterFactory.createGeneratedValueAdapter();
    }

    private void initializeLayout() {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        Label strategyTypeLabel = new Label((Composite)this, 16384);
        strategyTypeLabel.setText(DaliUiMessages.GeneratedValueComposite_strategy);
        this.strategyComboViewer = this.buildStrategyComboViewer(this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.strategyComboViewer.getCombo().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.strategyComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_generatedValueStrategy");
        Label generatorNameLabel = new Label((Composite)this, 16384);
        generatorNameLabel.setText(DaliUiMessages.GeneratedValueComposite_generatorName);
        this.generatorNameViewer = this.buildGeneratorNameViewer(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.generatorNameViewer.getTextWidget().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.generatorNameViewer.getTextWidget(), "org.eclipse.dali.ui.mapping_generatedValueGeneratorName");
    }

    private ComboViewer buildStrategyComboViewer(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(GenerationType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (GeneratedValueComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    GenerationType selectedType = (GenerationType)selection.getFirstElement();
                    if (GeneratedValueComposite.this.generatedValue == null) {
                        GeneratedValueComposite.this.createGeneratedValue();
                    }
                    if (!GeneratedValueComposite.this.generatedValue.getStrategy().equals(selectedType)) {
                        GeneratedValueComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)GeneratedValueComposite.this.editingDomain, (Object)GeneratedValueComposite.this.generatedValue, (Object)OrmPackage.eINSTANCE.getGeneratedValue_Strategy(), (Object)selectedType));
                    }
                }
            }
        });
        return viewer;
    }

    private void createGeneratedValue() {
        IGeneratedValueModelAdapter modelAdapter = ((IIdMappingModelAdapter)this.idMapping.getModelAdapter()).createGeneratedValueModelAdapter();
        GeneratedValue generatedValue = OrmFactory.eINSTANCE.createGeneratedValue(modelAdapter);
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.idMapping, (Object)OrmPackage.eINSTANCE.getIdMapping_GeneratedValue(), (Object)generatedValue));
    }

    private ITextViewer buildGeneratorNameViewer(Composite parent) {
        final TextViewer textViewer = new TextViewer(parent, 2052);
        textViewer.setDocument((IDocument)new Document());
        textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (GeneratedValueComposite.this.populating) {
                    return;
                }
                String generatorName = textViewer.getDocument().get();
                if (generatorName.equals("")) {
                    if (GeneratedValueComposite.this.generatedValue.getSpecifiedGeneratorName() == null || GeneratedValueComposite.this.generatedValue.getSpecifiedGeneratorName().equals("")) {
                        return;
                    }
                    generatorName = null;
                }
                if (GeneratedValueComposite.this.generatedValue == null) {
                    GeneratedValueComposite.this.createGeneratedValue();
                }
                GeneratedValueComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)GeneratedValueComposite.this.editingDomain, (Object)GeneratedValueComposite.this.generatedValue, (Object)OrmPackage.eINSTANCE.getGeneratedValue_SpecifiedGeneratorName(), (Object)generatorName));
            }
        });
        return textViewer;
    }

    private INotifyChangedListener getGeneratedValueListener() {
        if (this.generatedValueListener == null) {
            this.generatedValueListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    GeneratedValueComposite.this.generatedValueChanged(notification);
                }
            };
        }
        return this.generatedValueListener;
    }

    protected void generatedValueChanged(Notification notification) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.orm.GeneratedValue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) == 0) {
            final GenerationType strategy = (GenerationType)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (GeneratedValueComposite.this.selectedStrategy() != strategy) {
                        GeneratedValueComposite.this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)strategy));
                    }
                }
            });
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.GeneratedValue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (notification.getFeatureID((Class)clazz2) == 1) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        GeneratedValueComposite.this.populateGeneratorNameViewer();
                    }
                });
            }
        }
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.generatedValue != null) {
            this.generatedValueItemProvider.removeListener(this.getGeneratedValueListener());
            this.generatedValue.eAdapters().remove((Object)this.generatedValueItemProvider);
        }
        if (model == null) {
            this.populating = false;
            return;
        }
        this.idMapping = (IdMapping)model;
        this.generatedValue = this.idMapping.getGeneratedValue();
        if (this.generatedValue == null) {
            this.strategyComboViewer.getCombo().deselectAll();
            this.generatorNameViewer.getTextWidget().setText("");
            this.populating = false;
            return;
        }
        this.generatedValueItemProvider.addListener(this.getGeneratedValueListener());
        this.generatedValue.eAdapters().add((Object)this.generatedValueItemProvider);
        this.populateStrategyCombo();
        this.populateGeneratorNameViewer();
        this.populating = false;
    }

    private void populateGeneratorNameViewer() {
        String generatorName = this.generatedValue.getSpecifiedGeneratorName();
        if (generatorName == null || generatorName.equals("")) {
            if (!this.generatorNameViewer.getDocument().get().equals("")) {
                this.generatorNameViewer.getDocument().set("");
            }
        } else if (!this.generatorNameViewer.getDocument().get().equals(generatorName)) {
            this.generatorNameViewer.getDocument().set(generatorName);
        }
    }

    private void populateStrategyCombo() {
        GenerationType selectedType = this.selectedStrategy();
        GenerationType strategy = this.generatedValue.getStrategy();
        if (strategy == GenerationType.AUTO_LITERAL) {
            if (selectedType != GenerationType.AUTO_LITERAL) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.AUTO_LITERAL));
            }
        } else if (strategy == GenerationType.SEQUENCE_LITERAL) {
            if (selectedType != GenerationType.SEQUENCE_LITERAL) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.SEQUENCE_LITERAL));
            }
        } else if (strategy == GenerationType.IDENTITY_LITERAL) {
            if (selectedType != GenerationType.IDENTITY_LITERAL) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.IDENTITY_LITERAL));
            }
        } else if (strategy == GenerationType.TABLE_LITERAL) {
            if (selectedType != GenerationType.TABLE_LITERAL) {
                this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.TABLE_LITERAL));
            }
        } else if (selectedType != GenerationType.DEFAULT_LITERAL) {
            this.strategyComboViewer.setSelection((ISelection)new StructuredSelection((Object)GenerationType.DEFAULT_LITERAL));
        }
    }

    public boolean setFocus() {
        super.setFocus();
        return this.strategyComboViewer.getCombo().setFocus();
    }

    private GenerationType selectedStrategy() {
        return (GenerationType)((StructuredSelection)this.strategyComboViewer.getSelection()).getFirstElement();
    }

    public void dispose() {
        super.dispose();
        if (this.generatedValue != null) {
            this.generatedValue.eAdapters().remove((Object)this.generatedValueItemProvider);
        }
    }
}

