/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.EnumPropertyEditor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class EnumPropertyEditorTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_externalEnum() throws Exception {
        this.prepare_Foo_MyPanel();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setFoo(Foo.B);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("foo");
        EnumPropertyEditor editor = (EnumPropertyEditor)property.getEditor();
        EnumPropertyEditorTest.assertEquals((Object)"B", (Object)editor.getText((Property)property));
        Class<?> classFoo = this.m_lastLoader.loadClass("test.Foo");
        EnumPropertyEditorTest.assertEquals((Object)"test.Foo.B", (Object)editor.getValueSource(classFoo.getEnumConstants()[1]));
        EnumPropertyEditorTest.assertNull((Object)editor.getValueSource((Object)this));
        EnumPropertyEditorTest.assertEquals((Object)"test.Foo.B", (Object)editor.getClipboardSource(property));
        Enum[] enums = (Enum[])ReflectionUtils.invokeMethod((Object)editor, (String)"getElements(org.eclipse.wb.internal.core.model.property.Property)", (Object[])new Object[]{property});
        Object[] enumStrings = GenericsUtils.getEnumStrings((Enum[])enums);
        EnumPropertyEditorTest.assertArrayEquals((Object[])enumStrings, (Object[])new String[]{"A", "B", "C"});
    }

    @Test
    public void test_getText_noValue() throws Exception {
        this.prepare_Foo_MyPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("foo");
        EnumPropertyEditor editor = (EnumPropertyEditor)property.getEditor();
        EnumPropertyEditorTest.assertNull((Object)editor.getText((Property)property));
        EnumPropertyEditorTest.assertNull((Object)editor.getClipboardSource(property));
    }

    @Test
    public void test_setText() throws Exception {
        this.prepare_Foo_MyPanel();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setFoo(Foo.B);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("foo");
        EnumPropertyEditorTest.setPropertyText((Property)property, "C");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setFoo(Foo.C);", "  }", "}");
    }

    @Test
    public void test_innerEnum() throws Exception {
        this.prepare_Foo();
        EnumPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public enum Foo {A, B, C}", "  public void setFoo(Foo foo) {", "  }", "}"));
        EnumPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setFoo(Foo.B);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("foo");
        EnumPropertyEditor editor = (EnumPropertyEditor)property.getEditor();
        EnumPropertyEditorTest.assertEquals((Object)"B", (Object)editor.getText((Property)property));
        Class<?> classFoo = this.m_lastLoader.loadClass("test.MyPanel$Foo");
        EnumPropertyEditorTest.assertEquals((Object)"test.MyPanel.Foo.B", (Object)editor.getValueSource(classFoo.getEnumConstants()[1]));
        EnumPropertyEditorTest.assertEquals((Object)"test.MyPanel.Foo.B", (Object)editor.getClipboardSource(property));
    }

    @Test
    public void test_constructorParameter_enum() throws Exception {
        this.prepare_Foo();
        EnumPropertyEditorTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Foo foo) {", "  }", "}"));
        EnumPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton(Foo.B);", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/foo");
        EnumPropertyEditor editor = (EnumPropertyEditor)property.getEditor();
        EnumPropertyEditorTest.assertEquals((Object)"B", (Object)editor.getText((Property)property));
        Enum[] enums = (Enum[])ReflectionUtils.invokeMethod((Object)editor, (String)"getElements(org.eclipse.wb.internal.core.model.property.Property)", (Object[])new Object[]{property});
        Object[] enumStrings = GenericsUtils.getEnumStrings((Enum[])enums);
        EnumPropertyEditorTest.assertArrayEquals((Object[])enumStrings, (Object[])new String[]{"A", "B", "C"});
    }

    private void prepare_Foo_MyPanel() throws Exception {
        this.prepare_Foo();
        EnumPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(Foo foo) {", "  }", "}"));
        EnumPropertyEditorTest.waitForAutoBuild();
    }

    private void prepare_Foo() throws Exception {
        EnumPropertyEditorTest.setFileContentSrc("test/Foo.java", EnumPropertyEditorTest.getSourceDQ("package test;", "// filler filler filler", "// filler filler filler", "public enum Foo {", "  A, B, C", "}"));
    }
}

