/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.wb.internal.core.nls.bundle.BundleInfo;
import org.eclipse.wb.internal.core.nls.bundle.IPropertiesAccessor;
import org.eclipse.wb.internal.core.nls.bundle.StandardPropertiesAccessor;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Before;
import org.junit.Test;

public class BundleInfoTest
extends SwingModelTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        BundleInfoTest.setFileContentSrc("test/messages.properties", BundleInfoTest.getSourceDQ("frame.title=My JFrame"));
        BundleInfoTest.setFileContentSrc("test/messages_it.properties", BundleInfoTest.getSourceDQ("frame.title=My JFrame IT"));
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_createBundle() throws Exception {
        LocaleInfo localeInfo = new LocaleInfo(new Locale("it"));
        IFile[] files = new IFile[]{BundleInfoTest.getFileSrc("test", "messages.properties"), BundleInfoTest.getFileSrc("test", "messages_it.properties")};
        BundleInfo bundle = BundleInfo.createBundle((IPropertiesAccessor)StandardPropertiesAccessor.INSTANCE, (String)"test.messages", (LocaleInfo)localeInfo, (IFile[])files);
        BundleInfoTest.assertNotNull((Object)bundle);
        BundleInfoTest.assertEquals((Object)"test.messages", (Object)bundle.getBundleName());
        BundleInfoTest.assertSame((Object)files[1], (Object)bundle.getFile());
        BundleInfoTest.assertSame((Object)localeInfo, (Object)bundle.getLocale());
        BundleInfoTest.assertFalse((boolean)bundle.isExternallyChanged());
    }

    @Test
    public void test_createBundle_no() throws Exception {
        LocaleInfo localeInfo = new LocaleInfo(new Locale("fr"));
        IFile[] files = new IFile[]{BundleInfoTest.getFileSrc("test", "messages.properties"), BundleInfoTest.getFileSrc("test", "messages_it.properties")};
        BundleInfo bundle = BundleInfo.createBundle((IPropertiesAccessor)StandardPropertiesAccessor.INSTANCE, (String)"test.messages", (LocaleInfo)localeInfo, (IFile[])files);
        BundleInfoTest.assertNull((Object)bundle);
    }

    @Test
    public void test_getLocale_bad() throws Exception {
        IFile badFile = BundleInfoTest.setFileContentSrc("test/messagesbad.properties", "");
        try {
            BundleInfo.getLocale((String)"test.messages", (IFile)badFile);
            BundleInfoTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getLocale_new() throws Exception {
        IFile badFile = BundleInfoTest.setFileContentSrc("test/messages_new.properties", "");
        LocaleInfo locale = BundleInfo.getLocale((String)"test.messages", (IFile)badFile);
        BundleInfoTest.assertEquals((Object)"new", (Object)locale.toString());
    }

    @Test
    public void test_getLocale_languageCountry() throws Exception {
        IFile badFile = BundleInfoTest.setFileContentSrc("test/messages_bo_AM.properties", "");
        LocaleInfo locale = BundleInfo.getLocale((String)"test.messages", (IFile)badFile);
        BundleInfoTest.assertEquals((Object)"bo_AM", (Object)locale.toString());
    }

    @Test
    public void test_getMap_setMap_save() throws Exception {
        IFile[] files = new IFile[]{BundleInfoTest.getFileSrc("test", "messages.properties")};
        BundleInfo bundle = BundleInfo.createBundle((IPropertiesAccessor)StandardPropertiesAccessor.INSTANCE, (String)"test.messages", (LocaleInfo)LocaleInfo.DEFAULT, (IFile[])files);
        BundleInfoTest.assertEquals((Object)"My JFrame", (Object)bundle.getValue("frame.title"));
        Map map = bundle.getMap();
        BundleInfoTest.assertNotSame((Object)map, (Object)bundle.getMap());
        BundleInfoTest.assertEquals((long)1L, (long)map.size());
        BundleInfoTest.assertEquals((Object)"My JFrame", map.get("frame.title"));
        map.put("frame.title", "New title");
        BundleInfoTest.assertEquals((Object)"My JFrame", (Object)bundle.getValue("frame.title"));
        bundle.setMap(map);
        BundleInfoTest.assertEquals((Object)"New title", (Object)bundle.getValue("frame.title"));
        BundleInfoTest.assertEquals((Object)BundleInfoTest.getSourceDQ("frame.title=My JFrame"), (Object)BundleInfoTest.getFileContentSrc("test/messages.properties"));
        bundle.save("Some comment");
        String newContent = BundleInfoTest.getFileContentSrc("test/messages.properties");
        BundleInfoTest.assertTrue((boolean)newContent.contains("Some comment"));
        BundleInfoTest.assertTrue((boolean)newContent.contains("frame.title=New title"));
    }

    @Test
    public void test_values_keys() throws Exception {
        IFile[] files = new IFile[]{BundleInfoTest.getFileSrc("test", "messages.properties")};
        BundleInfo bundle = BundleInfo.createBundle((IPropertiesAccessor)StandardPropertiesAccessor.INSTANCE, (String)"test.messages", (LocaleInfo)LocaleInfo.DEFAULT, (IFile[])files);
        BundleInfoTest.assertEquals((Object)"My JFrame", (Object)bundle.getValue("frame.title"));
        Set keys = bundle.getKeys();
        BundleInfoTest.assertEquals((long)1L, (long)keys.size());
        BundleInfoTest.assertTrue((boolean)keys.contains("frame.title"));
        BundleInfoTest.assertTrue((boolean)bundle.containsKey("frame.title"));
        BundleInfoTest.assertFalse((boolean)bundle.containsKey("no-such-key"));
        bundle.setValue("1", "aaa");
        BundleInfoTest.assertTrue((boolean)bundle.containsKey("1"));
        BundleInfoTest.assertEquals((Object)"aaa", (Object)bundle.getValue("1"));
        bundle.removeKey("1");
        BundleInfoTest.assertFalse((boolean)bundle.containsKey("1"));
        BundleInfoTest.assertNull((Object)bundle.getValue("1"));
        bundle.setValue("1", "aaa");
        BundleInfoTest.assertTrue((boolean)bundle.containsKey("1"));
        bundle.setValue("1", "");
        BundleInfoTest.assertFalse((boolean)bundle.containsKey("1"));
        bundle.setValue("1", "aaa");
        bundle.setValue("2", "bbb");
        bundle.replaceKey("1", "1_", false);
        BundleInfoTest.assertEquals((Object)"aaa", (Object)bundle.getValue("1_"));
        BundleInfoTest.assertNull((Object)bundle.getValue("1"));
        bundle.setValue("1", "aaa");
        bundle.setValue("2", "bbb");
        bundle.replaceKey("1", "2", false);
        BundleInfoTest.assertEquals((Object)"aaa", (Object)bundle.getValue("2"));
        BundleInfoTest.assertNull((Object)bundle.getValue("1"));
        bundle.setValue("1", "aaa");
        bundle.setValue("2", "bbb");
        bundle.replaceKey("1", "2", true);
        BundleInfoTest.assertEquals((Object)"bbb", (Object)bundle.getValue("2"));
        BundleInfoTest.assertNull((Object)bundle.getValue("1"));
    }

    @Test
    public void test_UTF8() throws Exception {
        IFile file = BundleInfoTest.getFileSrc("test/messages.properties");
        String key = "key";
        String value = "\u0410\u0411\u0412";
        String newValue = "\u0430\u0431\u0432";
        String content = key + "=" + value;
        BundleInfoTest.setFileContent(file, content.getBytes("UTF-8"));
        file.setCharset("UTF-8", null);
        BundleInfo bundle = BundleInfo.createBundle((IPropertiesAccessor)StandardPropertiesAccessor.INSTANCE, (String)"test.messages", (LocaleInfo)LocaleInfo.DEFAULT, (IFile[])new IFile[]{file});
        BundleInfoTest.assertNotNull((Object)bundle);
        BundleInfoTest.assertEquals((Object)value, (Object)bundle.getValue(key));
        bundle.setValue(key, newValue);
        bundle.save("");
        BundleInfoTest.assertEquals((Object)"UTF-8", (Object)file.getCharset());
        bundle = BundleInfo.createBundle((IPropertiesAccessor)StandardPropertiesAccessor.INSTANCE, (String)"test.messages", (LocaleInfo)LocaleInfo.DEFAULT, (IFile[])new IFile[]{file});
        BundleInfoTest.assertNotNull((Object)bundle);
        BundleInfoTest.assertEquals((Object)newValue, (Object)bundle.getValue(key));
    }
}

