/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JFrame;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.old.EclipseSource;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.old.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.EditableSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSourceListener;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupportListener;
import org.eclipse.wb.internal.core.nls.edit.StringPropertyInfo;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.nls.AbstractNlsTest;
import org.eclipse.wb.tests.designer.core.nls.NlsTestUtils;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class EditableSupportTest
extends AbstractNlsTest {
    @Test
    public void test_possibleSource() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("# some comment"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        EditableSupport editableSupport = (EditableSupport)support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        EditableSupportTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        EditableSupportTest.assertEquals((Object)"test.messages", (Object)editableSource.getShortTitle());
        EditableSupportTest.assertNull((Object)editableSupport.getSource(editableSource));
        EditableSupportTest.assertInstanceOf(EclipseSource.class, (Object)editableSupport.getPossibleSource(editableSource));
    }

    @Test
    public void test_RenameKeyCommand() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "    setName(Messages.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        EditableSupport editableSupport = (EditableSupport)support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        EditableSupportTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        this.assertStringSet(editableSource.getKeys(), new String[]{"frame.title", "frame.name"});
        editableSource.renameKey("frame.name", "frame.name2");
        editableSource.renameKey("frame.title", "frame.title2");
        editableSource.renameKey("frame.title2", "frame.title3");
        support.applyEditable((IEditableSupport)editableSupport);
        this.assertStringSet(editableSource.getKeys(), new String[]{"frame.title3", "frame.name2"});
        String newProperties = EditableSupportTest.getFileContentSrc("test/messages.properties");
        EditableSupportTest.assertFalse((boolean)newProperties.contains("frame.name=My name"));
        EditableSupportTest.assertTrue((boolean)newProperties.contains("frame.name2=My name"));
        EditableSupportTest.assertFalse((boolean)newProperties.contains("frame.title=My JFrame"));
        EditableSupportTest.assertFalse((boolean)newProperties.contains("frame.title2=My JFrame"));
        EditableSupportTest.assertTrue((boolean)newProperties.contains("frame.title3=My JFrame"));
        this.assertEditor("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title3')); //$NON-NLS-1$", "    setName(Messages.getString('frame.name2')); //$NON-NLS-1$", "  }", "}");
    }

    @Test
    public void test_InternalizeKeyCommand() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "    setName(Messages.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        EditableSupport editableSupport = (EditableSupport)support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        EditableSupportTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        this.assertStringSet(editableSource.getKeys(), new String[]{"frame.title", "frame.name"});
        editableSource.internalizeKey("frame.title");
        editableSource.internalizeKey("frame.name");
        support.applyEditable((IEditableSupport)editableSupport);
        this.assertStringSet(editableSource.getKeys(), new String[0]);
        String newProperties = EditableSupportTest.getFileContentSrc("test/messages.properties");
        EditableSupportTest.assertFalse((boolean)newProperties.contains("frame.name=My name"));
        EditableSupportTest.assertFalse((boolean)newProperties.contains("frame.title=My JFrame"));
        this.assertEditor("class Test extends JFrame {", "  Test() {", "    setTitle('My JFrame');", "    setName('My name');", "  }", "}");
    }

    @Test
    public void test_RemoveLocaleCommand() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("frame.title=My JFrame"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        EditableSupport editableSupport = (EditableSupport)support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        EditableSupportTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        LocaleInfo newLocale = new LocaleInfo(new Locale("it"));
        EditableSupportTest.assertEquals((long)1L, (long)editableSource.getLocales().length);
        editableSource.addLocale(newLocale, LocaleInfo.DEFAULT);
        EditableSupportTest.assertEquals((long)2L, (long)editableSource.getLocales().length);
        EditableSupportTest.assertFalse((boolean)EditableSupportTest.getFileSrc("/test/messages_it.properties").exists());
        editableSource.setValue(newLocale, "frame.title", "My JFrame IT");
        editableSource.removeLocale(editableSource.getLocales()[1]);
        EditableSupportTest.assertEquals((long)1L, (long)editableSource.getLocales().length);
        support.applyEditable((IEditableSupport)editableSupport);
        EditableSupportTest.assertTrue((boolean)EditableSupportTest.getFileSrc("/test/messages.properties").exists());
        EditableSupportTest.assertFalse((boolean)EditableSupportTest.getFileSrc("/test/messages_it.properties").exists());
    }

    @Test
    public void test_addKey() throws Exception {
        m_testProject.addPlugin("org.eclipse.osgi");
        NlsTestUtils.create_EclipseModern_AccessorAndProperties();
        String[] lines = new String[]{"class Test extends JFrame {", "  Test() {", "    setTitle(Messages.frame_title);", "  }", "}"};
        ContainerInfo frame = this.parseContainer(lines);
        String frameSource = this.m_lastEditor.getSource();
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        EditableSupport editableSupport = (EditableSupport)support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        EditableSupportTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        editableSource.addKey("newKey", "newValue");
        Assertions.assertThat((Collection)editableSource.getKeys()).contains((Object[])new String[]{"newKey"});
        Object[] locales = editableSource.getLocales();
        Assertions.assertThat((Object[])locales).hasSize(2);
        EditableSupportTest.assertEquals((Object)"newValue", (Object)editableSource.getValue((LocaleInfo)locales[0], "newKey"));
        EditableSupportTest.assertEquals((Object)"newValue", (Object)editableSource.getValue((LocaleInfo)locales[1], "newKey"));
        support.applyEditable((IEditableSupport)editableSupport);
        EditableSupportTest.assertEditor(frameSource, this.m_lastEditor);
        String accessor = EditableSupportTest.getFileContentSrc("test/Messages.java");
        Assertions.assertThat((String)accessor).contains(new CharSequence[]{"public static String newKey;"});
        String newProperties = EditableSupportTest.getFileContentSrc("test/messages.properties");
        Assertions.assertThat((String)newProperties).contains(new CharSequence[]{"newKey=newValue"});
        newProperties = EditableSupportTest.getFileContentSrc("test/messages_it.properties");
        Assertions.assertThat((String)newProperties).contains(new CharSequence[]{"newKey=newValue"});
    }

    @Test
    public void test_existingSource() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("frame.title=My JFrame"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "    setName('Some name');", "    //", "    JButton button = new JButton('abc');", "    getContentPane().add(button);", "    //", "    JButton button2 = new JButton();", "    getContentPane().add(button2);", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        ComponentInfo button2 = (ComponentInfo)contentPane.getChildrenComponents().get(1);
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        EditableSupport editableSupport = (EditableSupport)support.getEditable();
        EditableSupportTest.assertSame((Object)frame, (Object)editableSupport.getRoot());
        EditableSupportTest.assertTrue((boolean)editableSupport.hasExistingSources());
        List components = editableSupport.getComponents();
        EditableSupportTest.assertEquals((long)4L, (long)components.size());
        EditableSupportTest.assertTrue((boolean)components.contains(frame));
        EditableSupportTest.assertTrue((boolean)components.contains(contentPane));
        EditableSupportTest.assertTrue((boolean)components.contains(button));
        EditableSupportTest.assertTrue((boolean)components.contains(button2));
        List properties = editableSupport.getProperties((JavaInfo)frame);
        EditableSupportTest.assertEquals((long)1L, (long)properties.size());
        StringPropertyInfo stringPropertyInfo = (StringPropertyInfo)properties.get(0);
        EditableSupportTest.assertEquals((Object)"name", (Object)stringPropertyInfo.getProperty().getTitle());
        EditableSupportTest.assertTrue((boolean)editableSupport.hasPropertiesInTree((JavaInfo)frame));
        EditableSupportTest.assertTrue((boolean)editableSupport.hasPropertiesInTree((JavaInfo)contentPane));
        EditableSupportTest.assertTrue((boolean)editableSupport.hasPropertiesInTree((JavaInfo)button));
        EditableSupportTest.assertFalse((boolean)editableSupport.hasPropertiesInTree((JavaInfo)button2));
        List editableSources = editableSupport.getEditableSources();
        EditableSupportTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        EditableSupportTest.assertEquals((Object)"test.messages", (Object)editableSource.getShortTitle());
        EditableSupportTest.assertInstanceOf(EclipseSource.class, (Object)editableSupport.getSource(editableSource));
    }

    @Test
    public void test_addSource() throws Exception {
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "    //", "    JButton button = new JButton('abc');", "    getContentPane().add(button);", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        EditableSupport editableSupport = (EditableSupport)support.getEditable();
        StringBuffer buffer = new StringBuffer();
        IEditableSupportListener editableSupportListener = EditableSupportTest.createEditableSupportListener(buffer);
        editableSupport.addListener(editableSupportListener);
        IEditableSource editableSource = NlsTestUtils.createEmptyEditable("messages");
        SourceDescription sourceDescription = EditableSupportTest.getSourceDescription((JavaInfo)frame);
        SourceParameters parameters = new SourceParameters();
        IJavaProject javaProject = this.m_lastEditor.getJavaProject();
        parameters.m_accessorSourceFolder = javaProject.findPackageFragmentRoot((IPath)new Path("/TestProject/src"));
        parameters.m_accessorPackage = javaProject.findPackageFragment((IPath)new Path("/TestProject/src/test"));
        parameters.m_accessorPackageName = parameters.m_accessorPackage.getElementName();
        parameters.m_accessorClassName = "Messages";
        parameters.m_accessorFullClassName = "test.Messages";
        parameters.m_accessorExists = false;
        parameters.m_propertySourceFolder = parameters.m_accessorSourceFolder;
        parameters.m_propertyPackage = parameters.m_accessorPackage;
        parameters.m_propertyFileName = "messages.properties";
        parameters.m_propertyBundleName = "test.messages";
        parameters.m_propertyFileExists = false;
        parameters.m_withDefaultValue = true;
        editableSupport.addSource(editableSource, sourceDescription, (Object)parameters);
        this.assertContains(buffer, "sourceAdded");
        EditableSupportTest.assertTrue((boolean)editableSource.getKeys().isEmpty());
        EditableSupportTest.assertTrue((boolean)editableSource.getFormKeys().isEmpty());
        ArrayList properties = new ArrayList();
        properties.addAll(editableSupport.getProperties((JavaInfo)frame));
        properties.addAll(editableSupport.getProperties((JavaInfo)button));
        for (StringPropertyInfo propertyInfo : properties) {
            editableSupport.externalizeProperty(propertyInfo, editableSource, true);
            this.assertContains(buffer, "externalizedPropertiesChanged");
        }
        this.assertStringSet(editableSource.getKeys(), new String[]{"Test.this.title", "Test.button.text"});
        this.assertStringSet(editableSource.getFormKeys(), new String[]{"Test.this.title", "Test.button.text"});
        this.checkComponentsMap(editableSource, new String[]{"Test.this.title", "Test.button.text"}, new JavaInfo[][]{{frame}, {button}});
        EditableSupportTest.assertEquals((Object)"My JFrame", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "Test.this.title"));
        EditableSupportTest.assertEquals((Object)"abc", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "Test.button.text"));
        String value = editableSource.getValue(new LocaleInfo(Locale.GERMAN), "Test.this.title");
        EditableSupportTest.assertNull((Object)value);
        IEditableSourceListener listener = EditableSupportTest.createEditableSourceListener(buffer);
        editableSource.addListener(listener);
        editableSource.renameKey("Test.button.text", "Test.button.text");
        EditableSupportTest.assertTrue((buffer.length() == 0 ? 1 : 0) != 0);
        editableSource.renameKey("no-such-key", "some-other-key");
        EditableSupportTest.assertTrue((buffer.length() == 0 ? 1 : 0) != 0);
        editableSource.renameKey("Test.button.text", "Test.button.text3");
        this.assertContains(buffer, "keyRenamed: Test.button.text -> Test.button.text3");
        editableSource.removeListener(listener);
        editableSource.renameKey("Test.button.text3", "Test.button.text2");
        EditableSupportTest.assertTrue((buffer.length() == 0 ? 1 : 0) != 0);
        this.assertStringSet(editableSource.getKeys(), new String[]{"Test.this.title", "Test.button.text2"});
        this.assertStringSet(editableSource.getFormKeys(), new String[]{"Test.this.title", "Test.button.text2"});
        this.checkComponentsMap(editableSource, new String[]{"Test.this.title", "Test.button.text2"}, new JavaInfo[][]{{frame}, {button}});
        EditableSupportTest.assertEquals((Object)"My JFrame", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "Test.this.title"));
        EditableSupportTest.assertEquals((Object)"abc", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "Test.button.text2"));
        support.applyEditable((IEditableSupport)editableSupport);
        editableSupport.removeListener(editableSupportListener);
        String newProperties = EditableSupportTest.getFileContentSrc("test/messages.properties");
        EditableSupportTest.assertTrue((boolean)newProperties.contains("#Eclipse messages class"));
        EditableSupportTest.assertTrue((boolean)newProperties.contains("Test.this.title=My JFrame"));
        EditableSupportTest.assertTrue((boolean)newProperties.contains("Test.button.text2=abc"));
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.getString(\"Test.this.title\", \"My JFrame\")); //$NON-NLS-1$ //$NON-NLS-2$", "    //", "    JButton button = new JButton(Messages.getString(\"Test.button.text2\", \"abc\")); //$NON-NLS-1$ //$NON-NLS-2$", "    getContentPane().add(button);", "  }", "}");
        StringBuffer buffer2 = new StringBuffer();
        EditableSupport editableSupport2 = (EditableSupport)support.getEditable();
        editableSupport2.addListener(EditableSupportTest.createEditableSupportListener(buffer2));
        IEditableSource editableSource2 = EditableSupportTest.getSingleExistingEditableSource(editableSupport2, buffer2);
        this.assertStringSet(editableSource2.getKeys(), new String[]{"Test.this.title", "Test.button.text2"});
        editableSource2.internalizeKey("Test.button.text2");
        this.assertContains(buffer2, "externalizedPropertiesChanged", false);
        this.assertContains(buffer2, "keyRemoved: Test.button.text2");
        this.assertStringSet(editableSource2.getKeys(), new String[]{"Test.this.title"});
        this.checkComponentsMap(editableSource2, new String[]{"Test.this.title"}, new JavaInfo[][]{{frame}});
        support.applyEditable((IEditableSupport)editableSupport2);
        String newProperties2 = EditableSupportTest.getFileContentSrc("test/messages.properties");
        EditableSupportTest.assertTrue((boolean)newProperties2.contains("Test.this.title=My JFrame"));
        EditableSupportTest.assertFalse((boolean)newProperties2.contains("Test.button.text2=abc"));
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.getString(\"Test.this.title\", \"My JFrame\")); //$NON-NLS-1$ //$NON-NLS-2$", "    //", "    JButton button = new JButton(\"abc\");", "    getContentPane().add(button);", "  }", "}");
        frame.refresh();
        buffer2 = new StringBuffer();
        editableSupport2 = (EditableSupport)support.getEditable();
        editableSupport2.addListener(EditableSupportTest.createEditableSupportListener(buffer2));
        editableSource2 = EditableSupportTest.getSingleExistingEditableSource(editableSupport2, buffer2);
        this.assertStringSet(editableSource2.getKeys(), new String[]{"Test.this.title"});
        StringPropertyInfo property = (StringPropertyInfo)editableSupport2.getProperties((JavaInfo)button).get(0);
        editableSource2.externalize(property, true);
        this.assertContains(buffer2, "externalizedPropertiesChanged", false);
        this.assertContains(buffer2, "keyAdded: Test.button.text");
        this.assertStringSet(editableSource2.getKeys(), new String[]{"Test.this.title", "Test.button.text"});
        this.checkComponentsMap(editableSource2, new String[]{"Test.this.title", "Test.button.text"}, new JavaInfo[][]{{frame}, {button}});
        String key = "no-such-key";
        editableSource2.setValue(LocaleInfo.DEFAULT, key, "");
        EditableSupportTest.assertNull((Object)editableSource2.getValue(LocaleInfo.DEFAULT, key));
        key = "Test.this.title";
        String oldValue = editableSource2.getValue(LocaleInfo.DEFAULT, key);
        editableSource2.setValue(LocaleInfo.DEFAULT, key, new String("My JFrame"));
        EditableSupportTest.assertSame((Object)oldValue, (Object)editableSource2.getValue(LocaleInfo.DEFAULT, key));
        LocaleInfo[] locales = editableSource2.getLocales();
        EditableSupportTest.assertEquals((long)1L, (long)locales.length);
        EditableSupportTest.assertEquals((Object)"(default)", (Object)locales[0].getTitle());
        editableSource2.addLocale(new LocaleInfo(new Locale("it")), LocaleInfo.DEFAULT);
        editableSource2.addLocale(new LocaleInfo(new Locale("fr")), null);
        locales = editableSource2.getLocales();
        EditableSupportTest.assertEquals((long)3L, (long)locales.length);
        EditableSupportTest.assertEquals((Object)"(default)", (Object)locales[0].getTitle());
        EditableSupportTest.assertEquals((Object)"fr", (Object)locales[1].getTitle());
        EditableSupportTest.assertEquals((Object)"it", (Object)locales[2].getTitle());
        support.applyEditable((IEditableSupport)editableSupport2);
        newProperties2 = EditableSupportTest.getFileContentSrc("test/messages.properties");
        EditableSupportTest.assertTrue((boolean)newProperties2.contains("Test.this.title=My JFrame"));
        EditableSupportTest.assertTrue((boolean)newProperties2.contains("Test.button.text=abc"));
        newProperties2 = EditableSupportTest.getFileContentSrc("test/messages_it.properties");
        EditableSupportTest.assertTrue((boolean)newProperties2.contains("Test.this.title=My JFrame"));
        EditableSupportTest.assertTrue((boolean)newProperties2.contains("Test.button.text=abc"));
        newProperties2 = EditableSupportTest.getFileContentSrc("test/messages_fr.properties");
        EditableSupportTest.assertFalse((boolean)newProperties2.contains("Test.this.title=My JFrame"));
        EditableSupportTest.assertFalse((boolean)newProperties2.contains("Test.button.text=abc"));
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.getString(\"Test.this.title\", \"My JFrame\")); //$NON-NLS-1$ //$NON-NLS-2$", "    //", "    JButton button = new JButton(Messages.getString(\"Test.button.text\", \"abc\")); //$NON-NLS-1$ //$NON-NLS-2$", "    getContentPane().add(button);", "  }", "}");
        frame.refresh();
        buffer2 = new StringBuffer();
        editableSupport2 = (EditableSupport)support.getEditable();
        editableSupport2.addListener(EditableSupportTest.createEditableSupportListener(buffer2));
        editableSource2 = EditableSupportTest.getSingleExistingEditableSource(editableSupport2, buffer2);
        editableSource2.renameKey("Test.button.text", "Test.button.text3");
        this.assertContains(buffer2, "keyRenamed: Test.button.text -> Test.button.text3");
        locales = editableSource2.getLocales();
        EditableSupportTest.assertEquals((long)3L, (long)locales.length);
        EditableSupportTest.assertEquals((Object)"fr", (Object)locales[1].toString());
        EditableSupportTest.assertEquals((Object)"it", (Object)locales[2].toString());
        editableSource2.removeLocale(editableSource2.getLocales()[1]);
        locales = editableSource2.getLocales();
        EditableSupportTest.assertEquals((long)2L, (long)locales.length);
        EditableSupportTest.assertEquals((Object)"(default)", (Object)locales[0].getTitle());
        EditableSupportTest.assertEquals((Object)"it", (Object)locales[1].getTitle());
        support.applyEditable((IEditableSupport)editableSupport2);
        EditableSupportTest.assertTrue((boolean)EditableSupportTest.getFileSrc("test", "messages.properties").exists());
        EditableSupportTest.assertTrue((boolean)EditableSupportTest.getFileSrc("test", "messages_it.properties").exists());
        EditableSupportTest.assertFalse((boolean)EditableSupportTest.getFileSrc("test", "messages_fr.properties").exists());
        frame.refresh();
        frame.refresh_dispose();
    }

    private static IEditableSource getSingleExistingEditableSource(EditableSupport editableSupport, StringBuffer buffer) {
        List editableSources = editableSupport.getEditableSources();
        EditableSupportTest.assertEquals((long)1L, (long)editableSources.size());
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        editableSource.addListener(EditableSupportTest.createEditableSourceListener(buffer));
        return editableSource;
    }

    @Test
    public void test_EclipseSource_defaultValue() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, true);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("frame.title=My JFrame"));
        EditableSupportTest.setFileContentSrc("test/messages_it.properties", EditableSupportTest.getSourceDQ("frame.title=My JFrame IT"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title', 'My JFrame')); //$NON-NLS-1$ //$NON-NLS-2$", "    setName('Some name');", "  }", "}");
        AbstractSource.setLocaleInfo((JavaInfo)frame, (LocaleInfo)LocaleInfo.DEFAULT);
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource source = support.getSources()[0];
        GenericProperty titleProperty = (GenericProperty)frame.getPropertyByTitle("title");
        frame.refresh();
        try {
            EditableSupportTest.assertEquals((Object)"My JFrame", (Object)((JFrame)frame.getObject()).getTitle());
            source.setValue(titleProperty.getExpression(), "qwerty");
            this.assertEditor("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString(\"frame.title\", \"qwerty\")); //$NON-NLS-1$ //$NON-NLS-2$", "    setName(\"Some name\");", "  }", "}");
            String newProperties = EditableSupportTest.getFileContentSrc("test/messages.properties");
            EditableSupportTest.assertTrue((boolean)newProperties.contains("frame.title=qwerty"));
        }
        finally {
            frame.refresh_dispose();
        }
    }

    @Test
    public void test_EclipseSource_defaultValue2() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, true);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("frame.title=My JFrame"));
        EditableSupportTest.setFileContentSrc("test/messages_it.properties", EditableSupportTest.getSourceDQ("frame.title=My JFrame IT"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title', 'My JFrame')); //$NON-NLS-1$ //$NON-NLS-2$", "    setName('Some name');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        frame.refresh();
        try {
            EditableSupportTest.assertEquals((Object)"My JFrame", (Object)((JFrame)frame.getObject()).getTitle());
            editableSource.setValue(LocaleInfo.DEFAULT, "frame.title", "qwerty");
            support.applyEditable(editableSupport);
            this.assertEditor("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString(\"frame.title\", \"My JFrame\")); //$NON-NLS-1$ //$NON-NLS-2$", "    setName(\"Some name\");", "  }", "}");
            String newProperties = EditableSupportTest.getFileContentSrc("test/messages.properties");
            EditableSupportTest.assertTrue((boolean)newProperties.contains("frame.title=qwerty"));
        }
        finally {
            frame.refresh_dispose();
        }
    }

    @Test
    public void test_externalize_uniqueKeys() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("#Some comment", "not-a-form-key=value"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle('My JFrame');", "    {", "      JButton button = new JButton('111');", "      getContentPane().add(button);", "    }", "    {", "      JButton button = new JButton('222');", "      getContentPane().add(button);", "    }", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ComponentInfo button1 = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        ComponentInfo button2 = (ComponentInfo)contentPane.getChildrenComponents().get(1);
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        this.assertStringSet(editableSource.getKeys(), new String[]{"not-a-form-key"});
        this.assertStringSet(editableSource.getFormKeys(), new String[0]);
        EditableSupportTest.assertSame((Object)Collections.EMPTY_SET, (Object)editableSource.getComponentsByKey("not-a-form-key"));
        StringPropertyInfo propertyInfo = (StringPropertyInfo)editableSupport.getProperties((JavaInfo)button1).get(0);
        editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        propertyInfo = (StringPropertyInfo)editableSupport.getProperties((JavaInfo)button2).get(0);
        editableSupport.externalizeProperty(propertyInfo, editableSource, true);
        support.applyEditable(editableSupport);
        this.assertEditor("class Test extends JFrame {", "  Test() {", "    setTitle(\"My JFrame\");", "    {", "      JButton button = new JButton(Messages.getString(\"Test.button.text\")); //$NON-NLS-1$", "      getContentPane().add(button);", "    }", "    {", "      JButton button = new JButton(Messages.getString(\"Test.button.text_1\")); //$NON-NLS-1$", "      getContentPane().add(button);", "    }", "  }", "}");
        String newProperties = EditableSupportTest.getFileContentSrc("test/messages.properties");
        EditableSupportTest.assertTrue((boolean)newProperties.contains("Test.button.text=111"));
        EditableSupportTest.assertTrue((boolean)newProperties.contains("Test.button.text_1=222"));
    }

    @Test
    public void test_StringPropertyInfo() throws Exception {
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle('My JFrame');", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        List properties = editableSupport.getProperties((JavaInfo)frame);
        EditableSupportTest.assertEquals((long)1L, (long)properties.size());
        StringPropertyInfo propertyInfo = (StringPropertyInfo)properties.get(0);
        EditableSupportTest.assertSame((Object)frame, (Object)propertyInfo.getComponent());
        EditableSupportTest.assertSame((Object)frame.getPropertyByTitle("title"), (Object)propertyInfo.getProperty());
        EditableSupportTest.assertEquals((Object)"My JFrame", (Object)propertyInfo.getValue());
        EditableSupportTest.assertEquals((Object)"title: My JFrame", (Object)propertyInfo.getTitle());
    }

    @Test
    public void test_renameConflict_cancel() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("frame.title=title", "frame.name=name"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "    setName(Messages.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        final IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        this.assertStringSet(editableSource.getKeys(), new String[]{"frame.title", "frame.name"});
        EditableSupportTest.assertEquals((Object)"title", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.title"));
        EditableSupportTest.assertEquals((Object)"name", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.name"));
        this.checkComponentsMap(editableSource, new String[]{"frame.title", "frame.name"}, new JavaInfo[][]{{frame}, {frame}});
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                editableSource.renameKey("frame.name", "frame.title");
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) throws Exception {
                bot.shell("Confirm").close();
            }
        });
        this.assertStringSet(editableSource.getKeys(), new String[]{"frame.title", "frame.name"});
        EditableSupportTest.assertEquals((Object)"title", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.title"));
        EditableSupportTest.assertEquals((Object)"name", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.name"));
        this.checkComponentsMap(editableSource, new String[]{"frame.title", "frame.name"}, new JavaInfo[][]{{frame}, {frame}});
    }

    @Test
    public void test_renameConflict_keep() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("frame.title=title", "frame.name=name"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "    setName(Messages.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        final IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                editableSource.renameKey("frame.name", "frame.title");
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) throws Exception {
                bot.shell("Confirm").bot().button("Yes, keep existing value").click();
            }
        });
        this.assertStringSet(editableSource.getKeys(), new String[]{"frame.title"});
        EditableSupportTest.assertEquals((Object)"title", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.title"));
        this.checkComponentsMap(editableSource, new String[]{"frame.title"}, new JavaInfo[][]{{frame}});
    }

    @Test
    public void test_renameConflict_useSourceValue() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
        EditableSupportTest.setFileContentSrc("test/messages.properties", EditableSupportTest.getSourceDQ("frame.title=title", "frame.name=name"));
        EditableSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "    setName(Messages.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        final IEditableSource editableSource = (IEditableSource)editableSupport.getEditableSources().get(0);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                editableSource.renameKey("frame.name", "frame.title");
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) throws Exception {
                bot.shell("Confirm").bot().button("No, use value of renaming key").click();
            }
        });
        this.assertStringSet(editableSource.getKeys(), new String[]{"frame.title"});
        EditableSupportTest.assertEquals((Object)"name", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.title"));
        this.checkComponentsMap(editableSource, new String[]{"frame.title"}, new JavaInfo[][]{{frame}});
    }

    private static IEditableSupportListener createEditableSupportListener(final StringBuffer buffer) {
        return new IEditableSupportListener(){

            public void sourceAdded(IEditableSource source) {
                buffer.append("sourceAdded: " + source.getLongTitle() + "\n");
            }

            public void externalizedPropertiesChanged() {
                buffer.append("externalizedPropertiesChanged\n");
            }
        };
    }

    private static IEditableSourceListener createEditableSourceListener(final StringBuffer buffer) {
        return new IEditableSourceListener(){

            public void keyAdded(String key, Object o) {
                buffer.append("keyAdded: " + key + "\n");
            }

            public void keyRemoved(String key) {
                buffer.append("keyRemoved: " + key + "\n");
            }

            public void keyRenamed(String oldKey, String newKey) {
                buffer.append("keyRenamed: " + oldKey + " -> " + newKey + "\n");
            }
        };
    }

    private void assertStringSet(Set<String> set, String[] expectedValues) {
        EditableSupportTest.assertEquals((long)expectedValues.length, (long)set.size());
        String[] stringArray = expectedValues;
        int n = expectedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedValue = stringArray[n2];
            EditableSupportTest.assertTrue((String)(expectedValue + " not found in " + String.valueOf(set)), (boolean)set.contains(expectedValue));
            ++n2;
        }
    }

    private void checkComponentsMap(IEditableSource editableSource, String[] keys, JavaInfo[][] components) {
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            JavaInfo[] expectedComponents = components[i];
            Set componentsByKey = editableSource.getComponentsByKey(key);
            EditableSupportTest.assertEquals((long)expectedComponents.length, (long)componentsByKey.size());
            int j = 0;
            while (j < expectedComponents.length) {
                JavaInfo expectedComponent = expectedComponents[j];
                EditableSupportTest.assertTrue((boolean)componentsByKey.contains(expectedComponent));
                ++j;
            }
            ++i;
        }
    }

    private void assertContains(StringBuffer buffer, String s) {
        this.assertContains(buffer, s, true);
    }

    private void assertContains(StringBuffer buffer, String s, boolean clear) {
        if (buffer.indexOf(s) == -1) {
            EditableSupportTest.fail((String)("|" + s + "| expected, but |" + buffer.toString() + "| found."));
        }
        if (clear) {
            buffer.setLength(0);
        }
    }
}

