/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoTest;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.junit.After;
import org.junit.Before;

public abstract class RcpModelTest
extends AbstractJavaInfoTest {
    private boolean m_convertSingleQuotesToDouble = true;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            RcpModelTest.do_projectCreate();
            this.configureNewProject();
        }
        this.configureForTestPreferences(RcpToolkitDescription.INSTANCE.getPreferences());
    }

    @Override
    protected void configureToolkits() {
        super.configureToolkits();
        RcpModelTest.configureDefaults(ToolkitProvider.DESCRIPTION);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.configureDefaultPreferences(RcpToolkitDescription.INSTANCE.getPreferences());
        super.tearDown();
    }

    protected void configureForTestPreferences(IPreferenceStore preferences) {
        preferences.setValue("templateLayoutName", "${defaultName}");
        preferences.setValue("templateLayoutDataName", "${defaultName}");
    }

    protected void configureDefaultPreferences(IPreferenceStore preferences) {
        preferences.setToDefault("templateLayoutDataName");
        preferences.setToDefault("templateLayoutName");
    }

    protected void configureNewProject() throws Exception {
        BTestUtils.configure(m_testProject);
    }

    public void dontConvertSingleQuotesToDouble() {
        this.m_convertSingleQuotesToDouble = false;
    }

    protected final CompositeInfo parseComposite(String ... lines) throws Exception {
        return (CompositeInfo)this.parseJavaInfo(lines);
    }

    protected final <T extends JavaInfo> T parseJavaInfo(String ... lines) throws Exception {
        return (T)this.parseSource("test", "Test.java", this.getTestSource(lines));
    }

    public final void assertEditor(String ... lines) {
        RcpModelTest.assertEditor(this.getTestSource(lines), this.m_lastEditor);
    }

    protected final String getTestSource(String ... lines) {
        if (this.m_convertSingleQuotesToDouble) {
            lines = RcpModelTest.getDoubleQuotes(lines);
        }
        lines = this.getTestSource_decorate(lines);
        return RcpModelTest.getSource(lines);
    }

    protected String[] getTestSource_decorate(String ... lines) {
        lines = CodeUtils.join((String[])new String[]{"package test;", "import org.eclipse.swt.SWT;", "import org.eclipse.swt.events.*;", "import org.eclipse.swt.graphics.*;", "import org.eclipse.swt.widgets.*;", "import org.eclipse.swt.layout.*;", "import org.eclipse.swt.custom.*;", "import org.eclipse.jface.layout.*;", "import org.eclipse.jface.viewers.*;", "import org.eclipse.jface.preference.*;", "import org.eclipse.jface.resource.*;", "import org.eclipse.ui.forms.*;", "import org.eclipse.ui.forms.widgets.*;", "import org.eclipse.ui.forms.editor.*;"}, (String[])lines);
        return lines;
    }
}

