/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import java.awt.Color;
import java.util.List;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.CoordinateUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JTabbedPaneInfo;
import org.eclipse.wb.internal.swing.model.component.JTabbedPaneTabInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class JTabbedPaneTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_association() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    //", "    JButton button = new JButton();", "    tabbed.addTab('New tab', button);", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        JTabbedPaneTest.assertEquals((long)1L, (long)tabbed.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        JTabbedPaneTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
        JTabbedPaneTest.assertSame((Object)button, (Object)tabbed.getActiveComponent());
        List tabs = tabbed.getTabs();
        Assertions.assertThat((List)tabs).hasSize(1);
        JTabbedPaneTabInfo tab = (JTabbedPaneTabInfo)tabs.get(0);
        JTabbedPaneTest.assertSame((Object)tabbed, (Object)tab.getPane());
        JTabbedPaneTest.assertSame((Object)button, (Object)tab.getComponent());
        Rectangle tabBounds = CoordinateUtils.get((java.awt.Rectangle)((JTabbedPane)tabbed.getObject()).getBoundsAt(0));
        JTabbedPaneTest.assertEquals((Object)tabBounds, (Object)tab.getBounds());
        JTabbedPaneTabInfo tab2 = new JTabbedPaneTabInfo(tabbed, button, null);
        JTabbedPaneTest.assertNotSame((Object)tab, (Object)tab2);
        JTabbedPaneTest.assertEquals((Object)tab, (Object)tab2);
        JTabbedPaneTest.assertFalse((boolean)tab.equals((Object)tabbed));
        JTabbedPaneTest.assertEquals((long)tab.hashCode(), (long)tab2.hashCode());
    }

    @Test
    public void test_association_insert() throws Exception {
        this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.insertTab('title', null, button, 'tip', 0);", "    }", "  }", "}");
        JTabbedPaneTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(tabbed)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JTabbedPane} {local-unique: tabbed} {/new JTabbedPane()/ /add(tabbed)/ /tabbed.insertTab('title', null, button, 'tip', 0)/}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /tabbed.insertTab('title', null, button, 'tip', 0)/}");
    }

    @Test
    public void test_isHorizontal() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    {", "      JTabbedPane tabbed_1 = new JTabbedPane(SwingConstants.TOP);", "      add(tabbed_1);", "    }", "    {", "      JTabbedPane tabbed_2 = new JTabbedPane(SwingConstants.LEFT);", "      add(tabbed_2);", "    }", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed_1 = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        JTabbedPaneInfo tabbed_2 = (JTabbedPaneInfo)panel.getChildrenComponents().get(1);
        JTabbedPaneTest.assertTrue((boolean)tabbed_1.isHorizontal());
        JTabbedPaneTest.assertFalse((boolean)tabbed_2.isHorizontal());
    }

    @Test
    public void test_badTab() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    tabbed.addTab('title', null);", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        JTabbedPaneTest.assertNoErrors((JavaInfo)panel);
        Assertions.assertThat((List)tabbed.getTabs()).isEmpty();
    }

    @Test
    public void test_getTabs_noComponentModels() throws Exception {
        JTabbedPaneTest.setFileContentSrc("test/MyTabbedPane.java", this.getTestSource("public class MyTabbedPane extends JTabbedPane {", "  public MyTabbedPane() {", "    addTab('tab_1', new JButton());", "  }", "}"));
        JTabbedPaneTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    MyTabbedPane tabbed = new MyTabbedPane();", "    add(tabbed);", "  }", "}");
        this.refresh();
        JTabbedPaneTest.assertNoErrors((JavaInfo)panel);
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)JTabbedPaneTest.getJavaInfoByName("tabbed");
        Assertions.assertThat((List)tabbed.getTabs()).isEmpty();
    }

    @Test
    public void test_parse_indexOfComponent() throws Exception {
        this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('111', button);", "      tabbed.setForegroundAt(tabbed.indexOfComponent(button), Color.RED);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)JTabbedPaneTest.getJavaInfoByName("button");
        GenericProperty property = (GenericProperty)this.getTabPropertyByTitle(button, "foreground");
        JTabbedPaneTest.assertEquals((Object)"RED", (Object)JTabbedPaneTest.getPropertyText((Property)property));
    }

    @Test
    public void test_disable_setModel() throws Exception {
        this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    tabbed.setModel(null);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('tab', button);", "    }", "  }", "}");
        this.refresh();
        JTabbedPaneTest.assertNoErrors(this.m_lastParseInfo);
    }

    @Test
    public void test_getActiveComponent_null() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        IObjectPresentation presentation = tabbed.getPresentation();
        Assertions.assertThat((List)tabbed.getTabs()).isEmpty();
        JTabbedPaneTest.assertNull((Object)tabbed.getActiveComponent());
        Assertions.assertThat((List)presentation.getChildrenGraphical()).isEmpty();
    }

    @Test
    public void test_getActiveComponent_set() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    tabbed.addTab('111', new JButton('111'));", "    tabbed.addTab('222', new JButton('222'));", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        IObjectPresentation presentation = tabbed.getPresentation();
        ComponentInfo button_1 = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)tabbed.getChildrenComponents().get(1);
        Assertions.assertThat((List)tabbed.getTabs()).hasSize(2);
        JTabbedPaneTest.assertSame((Object)button_1, (Object)tabbed.getActiveComponent());
        ((ListAssert)Assertions.assertThat((List)presentation.getChildrenGraphical()).contains((Object[])new ObjectInfo[]{button_1})).doesNotContain((Object[])new ObjectInfo[]{button_2});
        tabbed.setActiveComponent(button_2);
        JTabbedPaneTest.assertSame((Object)button_2, (Object)tabbed.getActiveComponent());
        ((ListAssert)Assertions.assertThat((List)presentation.getChildrenGraphical()).contains((Object[])new ObjectInfo[]{button_2})).doesNotContain((Object[])new ObjectInfo[]{button_1});
    }

    @Test
    public void test_property_list() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    tabbed.addTab('111', new JButton());", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        ComplexProperty tabProperty = (ComplexProperty)button.getPropertyByTitle("Tab");
        JTabbedPaneTest.assertNotNull((Object)tabProperty);
        JTabbedPaneTest.assertSame((Object)tabProperty, (Object)button.getPropertyByTitle("Tab"));
        Property[] properties = tabProperty.getProperties();
        String[] extectedTitles = new String[]{"background", "disabledIcon", "enabled", "foreground", "icon", "mnemonic", "mnemonicIndex", "title", "tooltip"};
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            JTabbedPaneTest.assertEquals((Object)extectedTitles[i], (Object)property.getTitle());
            ++i;
        }
    }

    @Test
    public void test_property_subAssociation() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    tabbed.addTab('111', new JButton());", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        Property property = this.getTabPropertyByTitle(button, "title");
        JTabbedPaneTest.assertTrue((boolean)property.isModified());
        JTabbedPaneTest.assertEquals((Object)"111", (Object)property.getValue());
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"111", (String)"222");
        property.setValue((Object)"222");
        JTabbedPaneTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = StringUtils.replace((String)expectedSource, (String)"\"222\"", (String)"(String) null");
        property.setValue(Property.UNKNOWN_VALUE);
        JTabbedPaneTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_subAt() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    tabbed.addTab('111', new JButton());", "    tabbed.setForegroundAt(0, Color.RED);", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)this.getTabPropertyByTitle(button, "foreground");
        JTabbedPaneTest.assertTrue((boolean)property.isModified());
        JTabbedPaneTest.assertInstanceOf(Color.class, property.getValue());
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"RED", (String)"BLUE");
        property.setExpression("java.awt.Color.BLUE", null);
        JTabbedPaneTest.assertEditor(expectedSource, this.m_lastEditor);
        property.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    tabbed.addTab('111', new JButton());", "  }", "}");
    }

    @Test
    public void test_property_subAtSet() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    //", "    JButton button = new JButton();", "    tabbed.addTab('111', button);", "    tabbed.setEnabledAt(0, false);", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)this.getTabPropertyByTitle(button, "foreground");
        JTabbedPaneTest.assertFalse((boolean)property.isModified());
        JTabbedPaneTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
        property.setExpression("java.awt.Color.RED", null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    //", "    JButton button = new JButton();", "    tabbed.addTab('111', button);", "    tabbed.setForegroundAt(0, Color.RED);", "    tabbed.setEnabledAt(0, false);", "  }", "}");
    }

    @Test
    public void test_property_subAtSetConflict() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    tabbed.addTab('111', new JButton());", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)this.getTabPropertyByTitle(button, "tooltip");
        JTabbedPaneTest.assertFalse((boolean)property.isModified());
        JTabbedPaneTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
        property.setValue((Object)"ToolTip");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    tabbed.addTab('111', new JButton());", "    tabbed.setToolTipTextAt(0, 'ToolTip');", "  }", "}");
    }

    @Test
    public void test_property_subAtRemove() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    //", "    tabbed.addTab('111', new JButton());", "    tabbed.setEnabledAt(0, false);", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)this.getTabPropertyByTitle(button, "enabled");
        JTabbedPaneTest.assertTrue((boolean)property.isModified());
        JTabbedPaneTest.assertEquals((Object)Boolean.FALSE, (Object)property.getValue());
        property.setValue((Object)Boolean.TRUE);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane(SwingConstants.TOP);", "    add(tabbed);", "    //", "    tabbed.addTab('111', new JButton());", "  }", "}");
    }

    private Property getTabPropertyByTitle(ComponentInfo component, String title) throws Exception {
        ComplexProperty tabProperty = (ComplexProperty)component.getPropertyByTitle("Tab");
        Property[] properties = tabProperty.getProperties();
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            if (property.getTitle().equals(title)) {
                return property;
            }
            ++i;
        }
        return null;
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "  }", "}");
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        try {
            JTabbedPaneTest.assertNull((Object)tabbed.getActiveComponent());
            ComponentInfo button = JTabbedPaneTest.createJButton();
            try {
                tabbed.startEdit();
                tabbed.command_CREATE(button, null);
            }
            finally {
                tabbed.endEdit();
            }
            JTabbedPaneTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
            this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('New tab', null, button, null);", "    }", "  }", "}");
            JTabbedPaneTest.assertSame((Object)button, (Object)tabbed.getActiveComponent());
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_CREATE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      tabbed.addTab('111', new JButton());", "      tabbed.setEnabledAt(0, false);", "    }", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        ComponentInfo newButton = JTabbedPaneTest.createJButton();
        try {
            tabbed.startEdit();
            tabbed.command_CREATE(newButton, button);
        }
        finally {
            tabbed.endEdit();
        }
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('New tab', null, button, null);", "    }", "    {", "      tabbed.addTab('111', new JButton());", "      tabbed.setEnabledAt(1, false);", "    }", "  }", "}");
        JTabbedPaneTest.assertSame((Object)newButton, (Object)tabbed.getActiveComponent());
    }

    @Test
    public void test_CREATE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      tabbed.addTab('tab1', new JLabel());", "      tabbed.setEnabledAt(0, false);", "    }", "  }", "}");
        this.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo label = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        ComponentInfo newButton = JTabbedPaneTest.createJButton();
        FlowContainer flowContainer = (FlowContainer)new FlowContainerFactory((JavaInfo)tabbed, false).get().get(0);
        JTabbedPaneTest.assertTrue((boolean)flowContainer.validateComponent((Object)newButton));
        flowContainer.command_CREATE((Object)newButton, (Object)label);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('New tab', null, button, null);", "    }", "    {", "      tabbed.addTab('tab1', new JLabel());", "      tabbed.setEnabledAt(1, false);", "    }", "  }", "}");
        JTabbedPaneTest.assertSame((Object)newButton, (Object)tabbed.getActiveComponent());
    }

    @Test
    public void test_DELETE() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('000', button);", "      tabbed.setEnabledAt(0, false);", "    }", "    {", "      JButton button = new JButton();", "      tabbed.addTab('111', button);", "      tabbed.setEnabledAt(1, false);", "    }", "  }", "}");
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        button.delete();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('111', button);", "      tabbed.setEnabledAt(0, false);", "    }", "  }", "}");
    }

    @Test
    public void test_OUT() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('000', button);", "      tabbed.setEnabledAt(0, false);", "    }", "    {", "      JButton button = new JButton();", "      tabbed.addTab('111', button);", "      tabbed.setEnabledAt(1, false);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo innerLayout = (FlowLayoutInfo)innerPanel.getLayout();
        innerLayout.move(button, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('111', button);", "      tabbed.setEnabledAt(0, false);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button_1 = new JButton();", "      tabbed.addTab('111', button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      tabbed.addTab('222', button_2);", "    }", "  }", "}");
        panel.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)tabbed.getChildrenComponents().get(1);
        JTabbedPaneTest.assertSame((Object)button_1, (Object)tabbed.getActiveComponent());
        try {
            tabbed.startEdit();
            tabbed.command_MOVE(button_2, button_1);
        }
        finally {
            tabbed.endEdit();
        }
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button_2 = new JButton();", "      tabbed.addTab('222', button_2);", "    }", "    {", "      JButton button_1 = new JButton();", "      tabbed.addTab('111', button_1);", "    }", "  }", "}");
        JTabbedPaneTest.assertSame((Object)button_1, (Object)tabbed.getActiveComponent());
    }

    @Test
    public void test_MOVE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button_1 = new JButton();", "      tabbed.addTab('111', button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      tabbed.addTab('222', button_2);", "    }", "  }", "}");
        panel.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)tabbed.getChildrenComponents().get(1);
        JTabbedPaneTest.assertSame((Object)button_1, (Object)tabbed.getActiveComponent());
        FlowContainer flowContainer = (FlowContainer)new FlowContainerFactory((JavaInfo)tabbed, false).get().get(0);
        flowContainer.command_MOVE((Object)button_2, (Object)button_1);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button_2 = new JButton();", "      tabbed.addTab('222', button_2);", "    }", "    {", "      JButton button_1 = new JButton();", "      tabbed.addTab('111', button_1);", "    }", "  }", "}");
        JTabbedPaneTest.assertSame((Object)button_1, (Object)tabbed.getActiveComponent());
    }

    @Test
    public void test_MOVE_atForward() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    //", "    JButton button_0 = new JButton();", "    tabbed.addTab('000', button_0);", "    tabbed.setToolTipTextAt(0, '000');", "    //", "    JButton button_1 = new JButton();", "    tabbed.addTab('111', button_1);", "    tabbed.setToolTipTextAt(1, '111');", "    //", "    JButton button_2 = new JButton();", "    tabbed.addTab('222', button_2);", "    tabbed.setToolTipTextAt(2, '222');", "    //", "    JButton button_3 = new JButton();", "    tabbed.addTab('333', button_3);", "    tabbed.setToolTipTextAt(3, '333');", "  }", "}");
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)tabbed.getChildrenComponents().get(1);
        ComponentInfo button_3 = (ComponentInfo)tabbed.getChildrenComponents().get(3);
        try {
            tabbed.startEdit();
            tabbed.command_MOVE(button_1, button_3);
        }
        finally {
            tabbed.endEdit();
        }
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    //", "    JButton button_0 = new JButton();", "    tabbed.addTab('000', button_0);", "    tabbed.setToolTipTextAt(0, '000');", "    //", "    JButton button_2 = new JButton();", "    tabbed.addTab('222', button_2);", "    tabbed.setToolTipTextAt(1, '222');", "    //", "    JButton button_1 = new JButton();", "    tabbed.addTab('111', button_1);", "    tabbed.setToolTipTextAt(2, '111');", "    //", "    JButton button_3 = new JButton();", "    tabbed.addTab('333', button_3);", "    tabbed.setToolTipTextAt(3, '333');", "  }", "}");
    }

    @Test
    public void test_MOVE_atBackward() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    //", "    JButton button_0 = new JButton();", "    tabbed.addTab('000', button_0);", "    tabbed.setToolTipTextAt(0, '000');", "    //", "    JButton button_1 = new JButton();", "    tabbed.addTab('111', button_1);", "    tabbed.setToolTipTextAt(1, '111');", "    //", "    JButton button_2 = new JButton();", "    tabbed.addTab('222', button_2);", "    tabbed.setToolTipTextAt(2, '222');", "    //", "    JButton button_3 = new JButton();", "    tabbed.addTab('333', button_3);", "    tabbed.setToolTipTextAt(3, '333');", "  }", "}");
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)tabbed.getChildrenComponents().get(1);
        ComponentInfo button_2 = (ComponentInfo)tabbed.getChildrenComponents().get(2);
        try {
            tabbed.startEdit();
            tabbed.command_MOVE(button_2, button_1);
        }
        finally {
            tabbed.endEdit();
        }
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    //", "    JButton button_0 = new JButton();", "    tabbed.addTab('000', button_0);", "    tabbed.setToolTipTextAt(0, '000');", "    //", "    JButton button_2 = new JButton();", "    tabbed.addTab('222', button_2);", "    tabbed.setToolTipTextAt(1, '222');", "    //", "    JButton button_1 = new JButton();", "    tabbed.addTab('111', button_1);", "    tabbed.setToolTipTextAt(2, '111');", "    //", "    JButton button_3 = new JButton();", "    tabbed.addTab('333', button_3);", "    tabbed.setToolTipTextAt(3, '333');", "  }", "}");
    }

    @Test
    public void test_MOVE_atSeveral() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    //", "    JButton button_0 = new JButton();", "    tabbed.addTab('000', button_0);", "    tabbed.setToolTipTextAt(0, '000');", "    //", "    JButton button_1 = new JButton();", "    tabbed.addTab('111', button_1);", "    tabbed.setToolTipTextAt(1, '111');", "    tabbed.setEnabledAt(1, false);", "  }", "}");
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_0 = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        ComponentInfo button_1 = (ComponentInfo)tabbed.getChildrenComponents().get(1);
        try {
            tabbed.startEdit();
            tabbed.command_MOVE(button_1, button_0);
        }
        finally {
            tabbed.endEdit();
        }
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    //", "    JButton button_1 = new JButton();", "    tabbed.addTab('111', button_1);", "    tabbed.setToolTipTextAt(0, '111');", "    tabbed.setEnabledAt(0, false);", "    //", "    JButton button_0 = new JButton();", "    tabbed.addTab('000', button_0);", "    tabbed.setToolTipTextAt(1, '000');", "  }", "}");
    }

    @Test
    public void test_MOVE_beforeAlreadyNext() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('tab', button);", "    }", "  }", "}");
        panel.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        tabbed.command_MOVE(button, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('tab', button);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_beforeItself() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('tab', button);", "    }", "  }", "}");
        panel.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        tabbed.command_MOVE(button, button);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('tab', button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_beforeExisting() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button_0 = new JButton();", "      tabbed.addTab('000', button_0);", "      tabbed.setToolTipTextAt(0, '000');", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        panel.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)JTabbedPaneTest.getJavaInfoByName("tabbed");
        ComponentInfo button_0 = (ComponentInfo)JTabbedPaneTest.getJavaInfoByName("button_0");
        JTabbedPaneTest.assertSame((Object)button_0, (Object)tabbed.getActiveComponent());
        ComponentInfo button = (ComponentInfo)JTabbedPaneTest.getJavaInfoByName("button");
        tabbed.command_ADD(button, button_0);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('New tab', null, button, null);", "    }", "    {", "      JButton button_0 = new JButton();", "      tabbed.addTab('000', button_0);", "      tabbed.setToolTipTextAt(1, '000');", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        JTabbedPaneTest.assertSame((Object)button, (Object)tabbed.getActiveComponent());
    }

    @Test
    public void test_ADD_first() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    {", "      JTabbedPane tabbed = new JTabbedPane();", "      add(tabbed);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)JTabbedPaneTest.getJavaInfoByName("tabbed");
        ComponentInfo button = (ComponentInfo)JTabbedPaneTest.getJavaInfoByName("button");
        tabbed.command_ADD(button, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    {", "      JTabbedPane tabbed = new JTabbedPane();", "      add(tabbed);", "      {", "        JButton button = new JButton();", "        tabbed.addTab('New tab', null, button, null);", "      }", "    }", "  }", "}");
        JTabbedPaneTest.assertSame((Object)button, (Object)tabbed.getActiveComponent());
    }

    @Test
    public void test_ADD_tree() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button_0 = new JButton();", "      tabbed.addTab('000', button_0);", "      tabbed.setToolTipTextAt(0, '000');", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        panel.refresh();
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)JTabbedPaneTest.getJavaInfoByName("tabbed");
        ComponentInfo button_0 = (ComponentInfo)JTabbedPaneTest.getJavaInfoByName("button_0");
        JTabbedPaneTest.assertSame((Object)button_0, (Object)tabbed.getActiveComponent());
        ComponentInfo button = (ComponentInfo)JTabbedPaneTest.getJavaInfoByName("button");
        FlowContainer flowContainer = (FlowContainer)new FlowContainerFactory((JavaInfo)tabbed, false).get().get(0);
        flowContainer.command_MOVE((Object)button, (Object)button_0);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('New tab', null, button, null);", "    }", "    {", "      JButton button_0 = new JButton();", "      tabbed.addTab('000', button_0);", "      tabbed.setToolTipTextAt(1, '000');", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        JTabbedPaneTest.assertSame((Object)button, (Object)tabbed.getActiveComponent());
    }

    @Test
    public void test_selecting() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button_0 = new JButton();", "      tabbed.addTab('000', button_0);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      tabbed.add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        JTabbedPaneInfo tabbed = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_0 = (ComponentInfo)tabbed.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)tabbed.getChildrenComponents().get(1);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        panel.refresh();
        try {
            JTabbedPaneTest.assertSame((Object)button_0, (Object)tabbed.getActiveComponent());
            boolean[] refreshFlag = new boolean[1];
            panel.getBroadcastObject().selecting((ObjectInfo)button_0, refreshFlag);
            JTabbedPaneTest.assertFalse((boolean)refreshFlag[0]);
            JTabbedPaneTest.assertSame((Object)button_0, (Object)tabbed.getActiveComponent());
            refreshFlag = new boolean[1];
            panel.getBroadcastObject().selecting((ObjectInfo)button, refreshFlag);
            JTabbedPaneTest.assertTrue((boolean)refreshFlag[0]);
            JTabbedPaneTest.assertSame((Object)innerPanel, (Object)tabbed.getActiveComponent());
        }
        finally {
            panel.refresh_dispose();
        }
    }
}

