/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.menu;

import java.util.List;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.event.EventsProperty;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuItemInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MenuItemTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item_1 = new MenuItem(menu, SWT.NONE);", "    }", "    {", "      MenuItem item_2 = new MenuItem(menu, SWT.CASCADE);", "      {", "        Menu subMenu = new Menu(item_2);", "        item_2.setMenu(subMenu);", "      }", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemTest.assertEquals((long)2L, (long)menuBar.getChildrenItems().size());
        MenuItemInfo menuItem_1 = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        MenuItemInfo menuItem_2 = (MenuItemInfo)menuBar.getChildrenItems().get(1);
        MenuItemTest.assertNull((Object)menuItem_1.getSubMenu());
        MenuItemTest.assertNotNull((Object)menuItem_2.getSubMenu());
    }

    @Test
    public void test_MenuItemStylePresentation() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "    }", "    {", "      MenuItem item = new MenuItem(menu, SWT.PUSH);", "    }", "    {", "      MenuItem item = new MenuItem(menu, SWT.CHECK);", "    }", "    {", "      MenuItem item = new MenuItem(menu, SWT.RADIO);", "    }", "    {", "      MenuItem item = new MenuItem(menu, SWT.SEPARATOR);", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        List menuItems = menuBar.getChildrenItems();
        MenuItemInfo menuItemDefault = (MenuItemInfo)menuItems.get(0);
        MenuItemInfo menuItemPush = (MenuItemInfo)menuItems.get(1);
        MenuItemInfo menuItemCheck = (MenuItemInfo)menuItems.get(2);
        MenuItemInfo menuItemRadio = (MenuItemInfo)menuItems.get(3);
        MenuItemInfo menuItemSeparator = (MenuItemInfo)menuItems.get(4);
        MenuItemTest.assertSame((Object)menuItemDefault.getPresentation().getIcon(), (Object)menuItemPush.getPresentation().getIcon());
        MenuItemTest.assertNotSame((Object)menuItemDefault.getPresentation().getIcon(), (Object)menuItemCheck.getPresentation().getIcon());
        MenuItemTest.assertNotSame((Object)menuItemDefault.getPresentation().getIcon(), (Object)menuItemRadio.getPresentation().getIcon());
        MenuItemTest.assertNotSame((Object)menuItemDefault.getPresentation().getIcon(), (Object)menuItemSeparator.getPresentation().getIcon());
        MenuItemTest.assertEquals((Object)"item", (Object)menuItemDefault.getPresentation().getText());
        MenuItemTest.assertEquals((Object)"<separator>", (Object)menuItemSeparator.getPresentation().getText());
    }

    @Test
    public void test_impl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.CASCADE);", "      {", "        Menu menu = new Menu(item);", "        item.setMenu(menu);", "      }", "    }", "  }", "}");
        shell.refresh();
        MenuInfo barInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuInfo menuInfo = itemInfo.getSubMenu();
        MenuItemTest.assertNull((Object)itemInfo.getAdapter(List.class));
        IMenuItemInfo itemObject = (IMenuItemInfo)itemInfo.getAdapter(IMenuItemInfo.class);
        MenuItemTest.assertSame((Object)itemInfo, (Object)itemObject.getModel());
        MenuItemTest.assertSame((Object)MenuObjectInfoUtils.getMenuInfo((Object)menuInfo), (Object)itemObject.getMenu());
        MenuItemTest.assertSame((Object)itemInfo.getImage(), (Object)itemObject.getImageDescriptor());
        MenuItemTest.assertSame((Object)itemInfo.getBounds(), (Object)itemObject.getBounds());
    }

    @Test
    public void test_setStyle_toNONE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.CHECK);", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo menuItem = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        GenericProperty styleProperty = (GenericProperty)menuItem.getPropertyByTitle("Style");
        styleProperty.setExpression(null, Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_setStyle_toCascade() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.CHECK);", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo menuItem = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        GenericProperty styleProperty = (GenericProperty)menuItem.getPropertyByTitle("Style");
        styleProperty.setExpression("org.eclipse.swt.SWT.CASCADE", Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.CASCADE);", "      {", "        Menu menu_1 = new Menu(item);", "        item.setMenu(menu_1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_setStyle_noCascade() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.RADIO);", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo menuItem = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        GenericProperty styleProperty = (GenericProperty)menuItem.getPropertyByTitle("Style");
        styleProperty.setExpression("org.eclipse.swt.SWT.CHECK", Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.CHECK);", "    }", "  }", "}");
    }

    @Test
    public void test_setStyle_fromCascade() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.CASCADE);", "      {", "        Menu menu_1 = new Menu(item);", "        item.setMenu(menu_1);", "      }", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo menuItem = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        GenericProperty styleProperty = (GenericProperty)menuItem.getPropertyByTitle("Style");
        styleProperty.setExpression("org.eclipse.swt.SWT.RADIO", Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.RADIO);", "    }", "  }", "}");
    }

    @Test
    public void test_setStyle_fromCascade_noSubMenu() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.CASCADE);", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo menuItem = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        GenericProperty styleProperty = (GenericProperty)menuItem.getPropertyByTitle("Style");
        styleProperty.setExpression("org.eclipse.swt.SWT.RADIO", Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.RADIO);", "    }", "  }", "}");
    }

    @Test
    public void test_setStyle_toSeparator() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "      item.setText('text');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo menuItem = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        GenericProperty styleProperty = (GenericProperty)menuItem.getPropertyByTitle("Style");
        styleProperty.setExpression("org.eclipse.swt.SWT.SEPARATOR", Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.SEPARATOR);", "    }", "  }", "}");
    }

    @Test
    public void test_setStyle_fromCascade_toSeparator() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.CASCADE);", "      item.setText('Sub Menu Item');", "      {", "        Menu menu_1 = new Menu(item);", "        item.setMenu(menu_1);", "      }", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo menuItem = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        GenericProperty styleProperty = (GenericProperty)menuItem.getPropertyByTitle("Style");
        styleProperty.setExpression("org.eclipse.swt.SWT.SEPARATOR", Property.UNKNOWN_VALUE);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.SEPARATOR);", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_addSelectionListener() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this, SWT.BAR);", "      setMenuBar(menu);", "      {", "        MenuItem item = new MenuItem(menu, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo menuItem = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        IDesignPageSite pageSite = (IDesignPageSite)Mockito.mock(IDesignPageSite.class);
        DesignPageSite.Helper.setSite((ObjectInfo)shell, (IDesignPageSite)pageSite);
        EventsProperty eventsProperty = (EventsProperty)menuItem.getPropertyByTitle("Events");
        eventsProperty.openStubMethod("selection/widgetSelected");
        MenuItemTest.waitEventLoop(0);
        ((IDesignPageSite)Mockito.verify((Object)pageSite)).openSourcePosition(ArgumentMatchers.anyInt());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pageSite});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this, SWT.BAR);", "      setMenuBar(menu);", "      {", "        MenuItem item = new MenuItem(menu, SWT.NONE);", "        item.addSelectionListener(new SelectionAdapter() {", "          @Override", "          public void widgetSelected(SelectionEvent e) {", "          }", "        });", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuItemInfo_noCreateOrPaste() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        String source = this.m_lastEditor.getSource();
        MenuInfo barInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo = (MenuItemInfo)barInfo.getChildren(MenuItemInfo.class).get(0);
        IMenuItemInfo itemObject = MenuObjectInfoUtils.getMenuItemInfo((Object)itemInfo);
        IMenuPolicy itemPolicy = itemObject.getPolicy();
        MenuInfo newMenuInfo = (MenuInfo)MenuItemTest.createJavaInfo("org.eclipse.swt.widgets.Menu");
        MenuItemTest.assertFalse((boolean)itemPolicy.validateCreate((Object)newMenuInfo));
        itemPolicy.commandCreate((Object)newMenuInfo, null);
        MenuItemTest.assertEditor(source, this.m_lastEditor);
        Object anyObject = new Object();
        MenuItemTest.assertFalse((boolean)itemPolicy.validatePaste(anyObject));
        itemPolicy.commandPaste(anyObject, null);
        MenuItemTest.assertEditor(source, this.m_lastEditor);
    }

    @Test
    public void test_IMenuItemInfo_move() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item_1 = new MenuItem(menu, SWT.CASCADE);", "      {", "        Menu subMenu = new Menu(item_1);", "        item_1.setMenu(subMenu);", "        {", "          MenuItem subItem = new MenuItem(subMenu, SWT.NONE);", "        }", "      }", "    }", "    {", "      MenuItem item_2 = new MenuItem(menu, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        MenuInfo barInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo_1 = (MenuItemInfo)barInfo.getChildrenItems().get(0);
        MenuInfo subMenuInfo = itemInfo_1.getSubMenu();
        MenuItemInfo subItemInfo = (MenuItemInfo)subMenuInfo.getChildrenItems().get(0);
        MenuItemInfo itemInfo_2 = (MenuItemInfo)barInfo.getChildrenItems().get(1);
        IMenuItemInfo subItemObject = MenuObjectInfoUtils.getMenuItemInfo((Object)subItemInfo);
        IMenuItemInfo itemObject_2 = MenuObjectInfoUtils.getMenuItemInfo((Object)itemInfo_2);
        IMenuPolicy subItemPolicy = subItemObject.getPolicy();
        IMenuPolicy itemPolicy_2 = itemObject_2.getPolicy();
        MenuItemTest.assertFalse((boolean)subItemPolicy.validateMove(new Object()));
        MenuItemTest.assertFalse((boolean)subItemPolicy.validateMove((Object)subMenuInfo));
        MenuItemTest.assertTrue((boolean)itemPolicy_2.validateMove((Object)subMenuInfo));
        itemPolicy_2.commandMove((Object)subMenuInfo, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item_1 = new MenuItem(menu, SWT.NONE);", "    }", "    {", "      MenuItem item_2 = new MenuItem(menu, SWT.CASCADE);", "      {", "        Menu subMenu = new Menu(item_2);", "        item_2.setMenu(subMenu);", "        {", "          MenuItem subItem = new MenuItem(subMenu, SWT.NONE);", "        }", "      }", "    }", "  }", "}");
    }
}

