/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.IGenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.rcp.Activator;
import org.eclipse.wb.internal.swt.model.property.editor.image.ImageEvaluator;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.swt.model.property.ImageDescriptorPropertyEditorTest;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class ImageDescriptorPropertyEditorTestPlugin
extends ImageDescriptorPropertyEditorTest {
    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        IFile file = ImageDescriptorPropertyEditorTestPlugin.getFile("icons", "1.png");
        ImageDescriptorPropertyEditorTestPlugin.setFileContent(file, org.eclipse.wb.tests.designer.tests.Activator.getFile("icons/test.png"));
        ImageDescriptorPropertyEditorTestPlugin.setFileContentSrc("testplugin/Activator.java", ImageDescriptorPropertyEditorTestPlugin.getSourceDQ("package testplugin;", "import org.eclipse.ui.plugin.AbstractUIPlugin;", "public class Activator extends AbstractUIPlugin {", "  public Activator() {", "  }", "  public static Activator getDefault() {", "    return null;", "  }", "}"));
        ImageDescriptorPropertyEditorTestPlugin.forgetCreatedResources();
        ImageDescriptorPropertyEditorTestPlugin.waitForAutoBuild();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_ThisPluginImage_Eclipse_workspace() throws Exception {
        this.assert_getText_getClipboardSource_forSource("org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin(\"TestProject\", \"icons/1.png\")", "Plugin: TestProject icons/1.png", "org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin(\"TestProject\", \"icons/1.png\")");
    }

    @Test
    public void test_PluginImage_Eclipse() throws Exception {
        this.assert_getText_getClipboardSource_forSource("org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")", "Plugin: org.eclipse.jdt.ui /icons/full/elcl16/ch_cancel.png", "org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")");
    }

    @Test
    public void test_ThisPluginImage_OLD() throws Exception {
        this.ensureManagers();
        this.assert_getText_getClipboardSource_forSource("org.eclipse.wb.swt.ResourceManager.getPluginImageDescriptor(testplugin.Activator.getDefault(), \"icons/1.png\")", "Plugin: TestProject icons/1.png", "org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin(\"TestProject\", \"icons/1.png\")");
    }

    @Test
    public void test_ThisPluginImage_NEW_workspace() throws Exception {
        this.ensureManagers();
        this.assert_getText_getClipboardSource_forSource("org.eclipse.wb.swt.ResourceManager.getPluginImageDescriptor(\"TestProject\", \"icons/1.png\")", "Plugin: TestProject icons/1.png", "org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin(\"TestProject\", \"icons/1.png\")");
    }

    @Test
    public void test_PluginImage_NEW() throws Exception {
        this.ensureManagers();
        this.assert_getText_getClipboardSource_forSource("org.eclipse.wb.swt.ResourceManager.getPluginImageDescriptor(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")", "Plugin: org.eclipse.jdt.ui /icons/full/elcl16/ch_cancel.png", "org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")");
    }

    @Test
    public void test_ThisPlugin_Value() throws Exception {
        this.ensureManagers();
        GenericProperty property = this.createImageDescriptorPropertyForSource("org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin(\"TestProject\", \"icons/1.png\")");
        ImageDescriptorPropertyEditorTestPlugin.assertNotNull((Object)property);
        ImageDescriptorPropertyEditorTestPlugin.assertNotNull((Object)property.getValue());
        String[] values = ImageEvaluator.getPluginImageValue((IGenericProperty)property);
        ImageDescriptorPropertyEditorTestPlugin.assertNotNull((Object)values);
        ImageDescriptorPropertyEditorTestPlugin.assertEquals((long)2L, (long)values.length);
        ImageDescriptorPropertyEditorTestPlugin.assertEquals((Object)"TestProject", (Object)values[0]);
        ImageDescriptorPropertyEditorTestPlugin.assertEquals((Object)"icons/1.png", (Object)values[1]);
    }

    @Test
    public void test_Plugin_Value() throws Exception {
        this.ensureManagers();
        GenericProperty property = this.createImageDescriptorPropertyForSource("org.eclipse.ui.plugin.AbstractUIPlugin.imageDescriptorFromPlugin(\"org.eclipse.jdt.ui\", \"/icons/full/elcl16/ch_cancel.png\")");
        ImageDescriptorPropertyEditorTestPlugin.assertNotNull((Object)property);
        ImageDescriptorPropertyEditorTestPlugin.assertNotNull((Object)property.getValue());
        String[] values = ImageEvaluator.getPluginImageValue((IGenericProperty)property);
        ImageDescriptorPropertyEditorTestPlugin.assertNotNull((Object)values);
        ImageDescriptorPropertyEditorTestPlugin.assertEquals((long)2L, (long)values.length);
        ImageDescriptorPropertyEditorTestPlugin.assertEquals((Object)"org.eclipse.jdt.ui", (Object)values[0]);
        ImageDescriptorPropertyEditorTestPlugin.assertEquals((Object)"/icons/full/elcl16/ch_cancel.png", (Object)values[1]);
    }

    private void ensureManagers() throws Exception {
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.SWTResourceManager");
        ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swt.ResourceManager");
    }
}

