/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.draw2d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.util.Lists;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.border.MarginBorder;
import org.eclipse.wb.internal.draw2d.FigureVisitor;
import org.eclipse.wb.tests.draw2d.Draw2dFigureTestCase;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.Test;

public class FigureTest
extends Draw2dFigureTestCase {
    private static final String ERROR_MESSAGE_CYCLE = "Figure being added introduces cycle";
    private static final String ERROR_MESSAGE_EMPTY_PARENT = "Figure is not a child";
    private static final String ERROR_MESSAGE_INVALID_INDEX = "Index does not exist";

    @Test
    public void test_add_Figure() throws Exception {
        Figure parentFigure = new Figure();
        Figure childFigure0 = new Figure();
        parentFigure.add((IFigure)childFigure0);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure0.getParent());
        FigureTest.assertEquals((long)1L, (long)parentFigure.getChildren().size());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure0));
        Figure childFigure1 = new Figure();
        parentFigure.add((IFigure)childFigure1);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure1.getParent());
        FigureTest.assertEquals((long)2L, (long)parentFigure.getChildren().size());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure1));
        FigureTest.assertSame((Object)childFigure0, parentFigure.getChildren().get(0));
        FigureTest.assertSame((Object)childFigure1, parentFigure.getChildren().get(1));
        parentFigure.add((IFigure)childFigure1);
        FigureTest.assertEquals((Object)parentFigure, (Object)childFigure1.getParent());
        Figure wrongChildFigure = new Figure();
        new Figure().add((IFigure)wrongChildFigure);
        parentFigure.add((IFigure)wrongChildFigure);
        FigureTest.assertEquals((Object)parentFigure, (Object)wrongChildFigure.getParent());
        try {
            parentFigure.add((IFigure)parentFigure);
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_CYCLE, (Object)e.getMessage());
        }
    }

    @Test
    public void test_add_Figure_int() throws Exception {
        Figure parentFigure = new Figure();
        Figure childFigure0 = new Figure();
        parentFigure.add((IFigure)childFigure0, 0);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure0.getParent());
        FigureTest.assertEquals((long)1L, (long)parentFigure.getChildren().size());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure0));
        Figure childFigure2 = new Figure();
        parentFigure.add((IFigure)childFigure2, -1);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure2.getParent());
        FigureTest.assertEquals((long)2L, (long)parentFigure.getChildren().size());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure2));
        Figure childFigure1 = new Figure();
        parentFigure.add((IFigure)childFigure1, 1);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure1.getParent());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure1));
        FigureTest.assertEquals((long)3L, (long)parentFigure.getChildren().size());
        FigureTest.assertSame((Object)childFigure0, parentFigure.getChildren().get(0));
        FigureTest.assertSame((Object)childFigure1, parentFigure.getChildren().get(1));
        FigureTest.assertSame((Object)childFigure2, parentFigure.getChildren().get(2));
        parentFigure.add((IFigure)childFigure2, 1);
        FigureTest.assertEquals((Object)parentFigure, (Object)childFigure2.getParent());
        Figure wrongChildFigure = new Figure();
        new Figure().add((IFigure)wrongChildFigure, 0);
        parentFigure.add((IFigure)wrongChildFigure, 2);
        FigureTest.assertEquals((Object)parentFigure, (Object)wrongChildFigure.getParent());
        try {
            parentFigure.add((IFigure)parentFigure, 2);
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_CYCLE, (Object)e.getMessage());
        }
        try {
            parentFigure.add((IFigure)new Figure(), -2);
            FigureTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_INVALID_INDEX, (Object)e.getMessage());
        }
        try {
            parentFigure.add((IFigure)new Figure(), parentFigure.getChildren().size() + 1);
            FigureTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_INVALID_INDEX, (Object)e.getMessage());
        }
    }

    @Test
    public void test_add_Figure_Rectangle() throws Exception {
        Figure parentFigure = new Figure();
        parentFigure.setLayoutManager((LayoutManager)new XYLayout());
        Figure childFigure0 = new Figure();
        parentFigure.add((IFigure)childFigure0, null);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure0.getParent());
        FigureTest.assertEquals((long)1L, (long)parentFigure.getChildren().size());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure0));
        Figure childFigure1 = new Figure();
        parentFigure.add((IFigure)childFigure1, null);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure1.getParent());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure1));
        FigureTest.assertEquals((long)2L, (long)parentFigure.getChildren().size());
        FigureTest.assertSame((Object)childFigure0, parentFigure.getChildren().get(0));
        FigureTest.assertSame((Object)childFigure1, parentFigure.getChildren().get(1));
        parentFigure.add((IFigure)childFigure1, null);
        FigureTest.assertEquals((Object)parentFigure, (Object)childFigure1.getParent());
        Figure wrongChildFigure = new Figure();
        new Figure().add((IFigure)wrongChildFigure, null);
        parentFigure.add((IFigure)wrongChildFigure, null);
        FigureTest.assertEquals((Object)parentFigure, (Object)wrongChildFigure.getParent());
        try {
            parentFigure.add((IFigure)parentFigure, null);
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_CYCLE, (Object)e.getMessage());
        }
        Rectangle bounds = new Rectangle(10, 11, 120, 200);
        Figure childFigure2 = new Figure();
        childFigure2.setBounds(bounds);
        parentFigure.add((IFigure)childFigure2, null);
        FigureTest.assertEquals((Object)bounds, (Object)childFigure2.getBounds());
        Figure childFigure3 = new Figure();
        parentFigure.add((IFigure)childFigure3, (Object)bounds);
        FigureTest.assertEquals((Object)bounds, (Object)parentFigure.getLayoutManager().getConstraint((IFigure)childFigure3));
    }

    @Test
    public void test_add_Figure_Rectangle_int() throws Exception {
        Figure parentFigure = new Figure();
        parentFigure.setLayoutManager((LayoutManager)new XYLayout());
        Figure childFigure0 = new Figure();
        parentFigure.add((IFigure)childFigure0, null, 0);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure0.getParent());
        FigureTest.assertEquals((long)1L, (long)parentFigure.getChildren().size());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure0));
        Figure childFigure2 = new Figure();
        parentFigure.add((IFigure)childFigure2, null, -1);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure2.getParent());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure2));
        FigureTest.assertEquals((long)2L, (long)parentFigure.getChildren().size());
        Figure childFigure1 = new Figure();
        parentFigure.add((IFigure)childFigure1, null, 1);
        FigureTest.assertSame((Object)parentFigure, (Object)childFigure1.getParent());
        FigureTest.assertTrue((boolean)parentFigure.getChildren().contains(childFigure1));
        FigureTest.assertEquals((long)3L, (long)parentFigure.getChildren().size());
        FigureTest.assertSame((Object)childFigure0, parentFigure.getChildren().get(0));
        FigureTest.assertSame((Object)childFigure1, parentFigure.getChildren().get(1));
        FigureTest.assertSame((Object)childFigure2, parentFigure.getChildren().get(2));
        parentFigure.add((IFigure)childFigure2, null, 1);
        FigureTest.assertEquals((Object)parentFigure, (Object)childFigure2.getParent());
        Figure wrongChildFigure = new Figure();
        new Figure().add((IFigure)wrongChildFigure, null, 0);
        parentFigure.add((IFigure)wrongChildFigure, null, 2);
        FigureTest.assertEquals((Object)parentFigure, (Object)wrongChildFigure.getParent());
        try {
            parentFigure.add((IFigure)parentFigure, null, 2);
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_CYCLE, (Object)e.getMessage());
        }
        try {
            parentFigure.add((IFigure)new Figure(), null, -2);
            FigureTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_INVALID_INDEX, (Object)e.getMessage());
        }
        try {
            parentFigure.add((IFigure)new Figure(), null, parentFigure.getChildren().size() + 1);
            FigureTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_INVALID_INDEX, (Object)e.getMessage());
        }
        Rectangle bounds = new Rectangle(10, 11, 120, 200);
        Figure childFigure3 = new Figure();
        childFigure3.setBounds(bounds);
        parentFigure.add((IFigure)childFigure3, null, parentFigure.getChildren().size());
        FigureTest.assertEquals((Object)bounds, (Object)childFigure3.getBounds());
        Figure childFigure4 = new Figure();
        parentFigure.add((IFigure)childFigure4, (Object)bounds, 0);
        FigureTest.assertEquals((Object)bounds, (Object)parentFigure.getLayoutManager().getConstraint((IFigure)childFigure4));
    }

    @Test
    public void test_remove_Figure() throws Exception {
        Figure parentFigure = new Figure();
        try {
            parentFigure.remove(null);
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_EMPTY_PARENT, (Object)e.getMessage());
        }
        try {
            parentFigure.remove((IFigure)new Figure());
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_EMPTY_PARENT, (Object)e.getMessage());
        }
        try {
            parentFigure.remove((IFigure)parentFigure);
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_EMPTY_PARENT, (Object)e.getMessage());
        }
        Figure childFigure = new Figure();
        parentFigure.add((IFigure)childFigure);
        parentFigure.add((IFigure)new Figure());
        parentFigure.remove((IFigure)childFigure);
        FigureTest.assertNull((Object)childFigure.getParent());
        FigureTest.assertFalse((boolean)parentFigure.getChildren().contains(childFigure));
        try {
            parentFigure.remove((IFigure)childFigure);
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_EMPTY_PARENT, (Object)e.getMessage());
        }
        Figure wrongChildFigure = new Figure();
        new Figure().add((IFigure)wrongChildFigure);
        try {
            parentFigure.remove((IFigure)wrongChildFigure);
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_EMPTY_PARENT, (Object)e.getMessage());
        }
        try {
            parentFigure.remove((IFigure)parentFigure);
            FigureTest.fail();
        }
        catch (IllegalArgumentException e) {
            FigureTest.assertEquals((Object)ERROR_MESSAGE_EMPTY_PARENT, (Object)e.getMessage());
        }
    }

    @Test
    public void test_removeAll() throws Exception {
        Figure parentFigure = new Figure();
        parentFigure.removeAll();
        Figure childFigure1 = new Figure();
        parentFigure.add((IFigure)childFigure1);
        Figure childFigure2 = new Figure();
        parentFigure.add((IFigure)childFigure2);
        Figure childFigure3 = new Figure();
        parentFigure.add((IFigure)childFigure3);
        parentFigure.removeAll();
        FigureTest.assertNull((Object)childFigure1.getParent());
        FigureTest.assertNull((Object)childFigure2.getParent());
        FigureTest.assertNull((Object)childFigure3.getParent());
        FigureTest.assertEquals((long)0L, (long)parentFigure.getChildren().size());
    }

    @Test
    public void test_get_set_Bounds() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertEquals((Object)new Rectangle(), (Object)testFigure.getBounds());
        testFigure.setBounds(new Rectangle(10, -11, 120, 57));
        FigureTest.assertEquals((Object)new Rectangle(10, -11, 120, 57), (Object)testFigure.getBounds());
        testFigure.setBounds(new Rectangle(0, 5, 60, 30));
        FigureTest.assertEquals((Object)new Rectangle(0, 5, 60, 30), (Object)testFigure.getBounds());
        Rectangle bounds = new Rectangle(1, 2, 3, 4);
        testFigure.setBounds(bounds);
        bounds.setSize(5, 6);
        FigureTest.assertEquals((Object)new Rectangle(1, 2, 3, 4), (Object)testFigure.getBounds());
    }

    @Test
    public void test_getLocation() throws Exception {
        Figure testFigure = new Figure();
        testFigure.setBounds(new Rectangle(10, -11, 120, 57));
        FigureTest.assertEquals((Object)new Point(10, -11), (Object)testFigure.getLocation());
        testFigure.getLocation().scale(120.0);
        FigureTest.assertEquals((Object)new Rectangle(10, -11, 120, 57), (Object)testFigure.getBounds());
    }

    @Test
    public void test_getSize() throws Exception {
        Figure testFigure = new Figure();
        testFigure.setBounds(new Rectangle(10, -11, 120, 57));
        FigureTest.assertEquals((Object)new Dimension(120, 57), (Object)testFigure.getSize());
        testFigure.getSize().scale(-120.0);
        FigureTest.assertEquals((Object)new Rectangle(10, -11, 120, 57), (Object)testFigure.getBounds());
    }

    @Test
    public void test_setLocation() throws Exception {
        Figure testFigure = new Figure();
        testFigure.setBounds(new Rectangle(10, -11, 120, 57));
        Point location = new Point(20, 40);
        testFigure.setLocation(location);
        FigureTest.assertEquals((Object)new Rectangle(20, 40, 120, 57), (Object)testFigure.getBounds());
        location.scale(10.0);
        FigureTest.assertEquals((Object)new Rectangle(20, 40, 120, 57), (Object)testFigure.getBounds());
        testFigure.setLocation(new Point(90, 40));
        FigureTest.assertEquals((Object)new Rectangle(90, 40, 120, 57), (Object)testFigure.getBounds());
    }

    @Test
    public void test_setSize() throws Exception {
        Figure testFigure = new Figure();
        testFigure.setBounds(new Rectangle(10, -11, 120, 57));
        Dimension size = new Dimension(60, 30);
        testFigure.setSize(size);
        FigureTest.assertEquals((Object)new Rectangle(10, -11, 60, 30), (Object)testFigure.getBounds());
        size.scale(-10.0);
        FigureTest.assertEquals((Object)new Rectangle(10, -11, 60, 30), (Object)testFigure.getBounds());
        testFigure.setSize(60, 120);
        FigureTest.assertEquals((Object)new Rectangle(10, -11, 60, 120), (Object)testFigure.getBounds());
    }

    @Test
    public void test_getInsets() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertEquals((Object)new Insets(), (Object)testFigure.getInsets());
        testFigure.setBorder((Border)new MarginBorder(new Insets(1, 2, 3, 4)));
        FigureTest.assertEquals((Object)new Insets(1, 2, 3, 4), (Object)testFigure.getInsets());
    }

    @Test
    public void test_getClientArea() throws Exception {
        Figure testFigure = new Figure();
        testFigure.setBounds(new Rectangle(10, -11, 120, 57));
        testFigure.setBorder((Border)new MarginBorder(new Insets(1, 2, 3, 4)));
        Rectangle clientArea1 = testFigure.getClientArea();
        Rectangle clientArea2 = testFigure.getClientArea();
        FigureTest.assertSame((Object)clientArea2, (Object)testFigure.getClientArea(clientArea2));
        FigureTest.assertEquals((Object)clientArea1, (Object)clientArea2);
        testFigure.getClientArea().setLocation(50, 50);
        FigureTest.assertEquals((Object)new Rectangle(10, -11, 120, 57), (Object)testFigure.getBounds());
    }

    @Test
    public void test_intersects() throws Exception {
        Figure testFigure = new Figure();
        testFigure.setBounds(new Rectangle(10, -11, 120, 57));
        FigureTest.assertTrue((boolean)testFigure.intersects(new Rectangle(30, -20, 50, 100)));
        FigureTest.assertFalse((boolean)testFigure.intersects(new Rectangle(0, 0, 5, 100)));
    }

    @Test
    public void test_containsPoint() {
        Figure testFigure = new Figure();
        testFigure.setBounds(new Rectangle(10, 11, 120, 130));
        FigureTest.assertFalse((boolean)testFigure.containsPoint(0, 0));
        FigureTest.assertTrue((boolean)testFigure.containsPoint(10, 11));
        FigureTest.assertTrue((boolean)testFigure.containsPoint(40, 51));
        FigureTest.assertFalse((boolean)testFigure.containsPoint(130, 141));
    }

    @Test
    public void test_init_properties() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertNull((Object)testFigure.getParent());
        FigureTest.assertEquals((long)0L, (long)testFigure.getChildren().size());
        FigureTest.assertEquals((Object)new Rectangle(), (Object)testFigure.getBounds());
        FigureTest.assertEquals((Object)new Rectangle(), (Object)testFigure.getClientArea());
        FigureTest.assertEquals((Object)new Rectangle(), (Object)testFigure.getClientArea(new Rectangle()));
        FigureTest.assertEquals((Object)new Insets(), (Object)testFigure.getInsets());
        FigureTest.assertNull((Object)testFigure.getBorder());
        FigureTest.assertNull((Object)testFigure.getBackgroundColor());
        FigureTest.assertNull((Object)testFigure.getForegroundColor());
        FigureTest.assertNull((Object)testFigure.getFont());
        FigureTest.assertNull((Object)testFigure.getCursor());
        FigureTest.assertFalse((boolean)testFigure.isOpaque());
        FigureTest.assertTrue((boolean)testFigure.isVisible());
        FigureTest.assertNull((Object)testFigure.getToolTipText());
    }

    @Test
    public void test_border() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertNull((Object)testFigure.getBorder());
        LineBorder border = new LineBorder();
        testFigure.setBorder((Border)border);
        FigureTest.assertSame((Object)border, (Object)testFigure.getBorder());
        border = new MarginBorder(4);
        testFigure.setBorder((Border)border);
        FigureTest.assertSame((Object)border, (Object)testFigure.getBorder());
        testFigure.setBorder(null);
        FigureTest.assertNull((Object)testFigure.getBorder());
    }

    @Test
    public void test_background() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertNull((Object)testFigure.getBackgroundColor());
        testFigure.setBackgroundColor(black);
        FigureTest.assertSame((Object)black, (Object)testFigure.getBackgroundColor());
        testFigure.setBackgroundColor(red);
        FigureTest.assertSame((Object)red, (Object)testFigure.getBackgroundColor());
        testFigure.setBackgroundColor(null);
        FigureTest.assertNull((Object)testFigure.getBackgroundColor());
    }

    @Test
    public void test_foreground() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertNull((Object)testFigure.getForegroundColor());
        testFigure.setForegroundColor(black);
        FigureTest.assertSame((Object)black, (Object)testFigure.getForegroundColor());
        testFigure.setForegroundColor(red);
        FigureTest.assertSame((Object)red, (Object)testFigure.getForegroundColor());
        testFigure.setForegroundColor(null);
        FigureTest.assertNull((Object)testFigure.getForegroundColor());
    }

    @Test
    public void test_font() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertNull((Object)testFigure.getFont());
        Font font = new Font(null, "Courier New", 12, 1);
        testFigure.setFont(font);
        FigureTest.assertSame((Object)font, (Object)testFigure.getFont());
        testFigure.setFont(null);
        FigureTest.assertNull((Object)testFigure.getFont());
    }

    @Test
    public void test_cursor() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertNull((Object)testFigure.getCursor());
        testFigure.setCursor(Cursors.HELP);
        FigureTest.assertSame((Object)Cursors.HELP, (Object)testFigure.getCursor());
        testFigure.setCursor(Cursors.CROSS);
        FigureTest.assertSame((Object)Cursors.CROSS, (Object)testFigure.getCursor());
        testFigure.setCursor(null);
        FigureTest.assertNull((Object)testFigure.getCursor());
    }

    @Test
    public void test_opaque() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertFalse((boolean)testFigure.isOpaque());
        testFigure.setOpaque(true);
        FigureTest.assertTrue((boolean)testFigure.isOpaque());
        testFigure.setOpaque(false);
        FigureTest.assertFalse((boolean)testFigure.isOpaque());
    }

    @Test
    public void test_visible() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertTrue((boolean)testFigure.isVisible());
        testFigure.setVisible(false);
        FigureTest.assertFalse((boolean)testFigure.isVisible());
        testFigure.setVisible(true);
        FigureTest.assertTrue((boolean)testFigure.isVisible());
    }

    @Test
    public void test_tooltip() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertNull((Object)testFigure.getToolTipText());
        testFigure.setToolTipText("JLabel(\"123\")");
        FigureTest.assertEquals((Object)"JLabel(\"123\")", (Object)testFigure.getToolTipText());
        testFigure.setToolTipText("new Button()");
        FigureTest.assertEquals((Object)"new Button()", (Object)testFigure.getToolTipText());
        testFigure.setToolTipText(null);
        FigureTest.assertNull((Object)testFigure.getToolTipText());
    }

    @Test
    public void test_visit() throws Exception {
        Figure testFigure1 = new Figure();
        Figure testFigure2 = new Figure();
        Figure testFigure3 = new Figure();
        testFigure1.add((IFigure)testFigure2);
        testFigure1.add((IFigure)testFigure3);
        final ArrayList track = new ArrayList();
        FigureVisitor visitor = new FigureVisitor(){

            public boolean visit(Figure figure) {
                track.add(figure);
                return super.visit(figure);
            }

            public void endVisit(Figure figure) {
                track.add(figure);
            }
        };
        testFigure1.accept(visitor, true);
        FigureTest.assertEquals((long)6L, (long)track.size());
        FigureTest.assertSame((Object)testFigure1, track.get(0));
        FigureTest.assertSame((Object)testFigure2, track.get(1));
        FigureTest.assertSame((Object)testFigure2, track.get(2));
        FigureTest.assertSame((Object)testFigure3, track.get(3));
        FigureTest.assertSame((Object)testFigure3, track.get(4));
        FigureTest.assertSame((Object)testFigure1, track.get(5));
        track.clear();
        testFigure1.accept(visitor, false);
        FigureTest.assertEquals((long)6L, (long)track.size());
        FigureTest.assertSame((Object)testFigure1, track.get(0));
        FigureTest.assertSame((Object)testFigure3, track.get(1));
        FigureTest.assertSame((Object)testFigure3, track.get(2));
        FigureTest.assertSame((Object)testFigure2, track.get(3));
        FigureTest.assertSame((Object)testFigure2, track.get(4));
        FigureTest.assertSame((Object)testFigure1, track.get(5));
        visitor = new FigureVisitor(){

            public boolean visit(Figure figure) {
                track.add(figure);
                return false;
            }

            public void endVisit(Figure figure) {
                track.add(figure);
            }
        };
        track.clear();
        testFigure1.accept(visitor, true);
        FigureTest.assertEquals((long)1L, (long)track.size());
        FigureTest.assertSame((Object)testFigure1, track.get(0));
        track.clear();
        testFigure1.accept(visitor, false);
        FigureTest.assertEquals((long)1L, (long)track.size());
        FigureTest.assertSame((Object)testFigure1, track.get(0));
    }

    @Test
    public void test_add_remove_MouseListener() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertFalse((boolean)testFigure.getListeners(MouseListener.class).hasNext());
        MouseListener.Stub listener1 = new MouseListener.Stub();
        testFigure.addMouseListener((MouseListener)listener1);
        ArrayList list = Lists.newArrayList((Iterator)testFigure.getListeners(MouseListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)1L, (long)list.size());
        FigureTest.assertSame((Object)listener1, list.get(0));
        MouseListener.Stub listener2 = new MouseListener.Stub();
        testFigure.addMouseListener((MouseListener)listener2);
        list = Lists.newArrayList((Iterator)testFigure.getListeners(MouseListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)2L, (long)list.size());
        FigureTest.assertSame((Object)listener1, list.get(0));
        FigureTest.assertSame((Object)listener2, list.get(1));
        testFigure.removeMouseListener((MouseListener)listener1);
        list = Lists.newArrayList((Iterator)testFigure.getListeners(MouseListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)1L, (long)list.size());
        FigureTest.assertSame((Object)listener2, list.get(0));
        testFigure.removeMouseListener((MouseListener)listener2);
        list = Lists.newArrayList((Iterator)testFigure.getListeners(MouseListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void test_add_remove_MouseMoveListener() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertFalse((boolean)testFigure.getListeners(MouseMotionListener.class).hasNext());
        MouseMotionListener.Stub listener1 = new MouseMotionListener.Stub();
        testFigure.addMouseMotionListener((MouseMotionListener)listener1);
        ArrayList list = Lists.newArrayList((Iterator)testFigure.getListeners(MouseMotionListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)1L, (long)list.size());
        FigureTest.assertSame((Object)listener1, list.get(0));
        MouseMotionListener.Stub listener2 = new MouseMotionListener.Stub();
        testFigure.addMouseMotionListener((MouseMotionListener)listener2);
        list = Lists.newArrayList((Iterator)testFigure.getListeners(MouseMotionListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)2L, (long)list.size());
        FigureTest.assertSame((Object)listener1, list.get(0));
        FigureTest.assertSame((Object)listener2, list.get(1));
        testFigure.removeMouseMotionListener((MouseMotionListener)listener1);
        list = Lists.newArrayList((Iterator)testFigure.getListeners(MouseMotionListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)1L, (long)list.size());
        FigureTest.assertSame((Object)listener2, list.get(0));
        testFigure.removeMouseMotionListener((MouseMotionListener)listener2);
        list = Lists.newArrayList((Iterator)testFigure.getListeners(MouseMotionListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void test_add_remove_FigureListener() throws Exception {
        Figure testFigure = new Figure();
        FigureTest.assertFalse((boolean)testFigure.getListeners(FigureListener.class).hasNext());
        FigureListener listener1 = new FigureListener(){

            public void figureMoved(IFigure source) {
            }
        };
        testFigure.addFigureListener(listener1);
        ArrayList list = Lists.newArrayList((Iterator)testFigure.getListeners(FigureListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)1L, (long)list.size());
        FigureTest.assertSame((Object)listener1, list.get(0));
        FigureListener listener2 = new FigureListener(){

            public void figureMoved(IFigure source) {
            }
        };
        testFigure.addFigureListener(listener2);
        list = Lists.newArrayList((Iterator)testFigure.getListeners(FigureListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)2L, (long)list.size());
        FigureTest.assertSame((Object)listener1, list.get(0));
        FigureTest.assertSame((Object)listener2, list.get(1));
        testFigure.removeFigureListener(listener1);
        list = Lists.newArrayList((Iterator)testFigure.getListeners(FigureListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)1L, (long)list.size());
        FigureTest.assertSame((Object)listener2, list.get(0));
        testFigure.removeFigureListener(listener2);
        list = Lists.newArrayList((Iterator)testFigure.getListeners(FigureListener.class));
        FigureTest.assertNotNull((Object)list);
        FigureTest.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void test_invoke_FigureListener() throws Exception {
        final TestLogger actualLogger = new TestLogger();
        FigureListener listener = new FigureListener(){

            public void figureMoved(IFigure source) {
                actualLogger.log("figureMoved(" + String.valueOf(source) + ")");
            }
        };
        TestLogger expectedLogger = new TestLogger();
        Figure testFigure = new Figure(){

            public String toString() {
                return "__testFigure_";
            }
        };
        PropertyChangeListener listener1 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                actualLogger.log("figureReparent(" + String.valueOf(event.getOldValue()) + ", " + String.valueOf(event.getNewValue()) + ")");
            }
        };
        testFigure.addFigureListener(listener);
        testFigure.addPropertyChangeListener("parent", listener1);
        actualLogger.assertEmpty();
        testFigure.setSize(10, 20);
        expectedLogger.log("figureMoved(__testFigure_)");
        actualLogger.assertEquals(expectedLogger);
        testFigure.setLocation(new Point(10, 20));
        expectedLogger.log("figureMoved(__testFigure_)");
        actualLogger.assertEquals(expectedLogger);
        testFigure.setBounds(new Rectangle(10, 20, 10, 20));
        actualLogger.assertEmpty();
        testFigure.setBounds(new Rectangle(-11, -11, 17, 120));
        expectedLogger.log("figureMoved(__testFigure_)");
        actualLogger.assertEquals(expectedLogger);
        Figure parent = new Figure(){

            public String toString() {
                return "__parent_";
            }
        };
        parent.add((IFigure)testFigure);
        expectedLogger.log("figureReparent(null, __parent_)");
        actualLogger.assertEquals(expectedLogger);
        parent.setBounds(new Rectangle(0, 0, 50, 40));
        actualLogger.assertEmpty();
        parent.remove((IFigure)testFigure);
        expectedLogger.log("figureReparent(__parent_, null)");
        actualLogger.assertEquals(expectedLogger);
    }

    @Test
    public void test_invoke_AncestorListener() throws Exception {
        final TestLogger actualLogger = new TestLogger();
        AncestorListener.Stub listener = new AncestorListener.Stub(){

            public void ancestorMoved(IFigure ancestor) {
                actualLogger.log("ancestorMoved(" + String.valueOf(ancestor) + ")");
            }
        };
        TestLogger expectedLogger = new TestLogger();
        Figure parent = new Figure(){

            public String toString() {
                return "__parent_";
            }
        };
        Figure testFigure = new Figure(){

            public String toString() {
                return "__testFigure_";
            }
        };
        parent.add((IFigure)testFigure);
        testFigure.addAncestorListener((AncestorListener)listener);
        actualLogger.assertEmpty();
        testFigure.setBounds(new Rectangle(1, 2, 3, 4));
        expectedLogger.log("ancestorMoved(__testFigure_)");
        actualLogger.assertEquals(expectedLogger);
        testFigure.setSize(3, 4);
        actualLogger.assertEmpty();
        parent.setSize(3, 4);
        expectedLogger.log("ancestorMoved(__parent_)");
        actualLogger.assertEquals(expectedLogger);
    }
}

