/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.description.Description;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.Polyline;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.handles.ResizeHandle;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;
import org.eclipse.wb.tests.gef.EventSender;
import org.junit.Assert;

public final class GraphicalRobot {
    private final GraphicalViewer m_viewer;
    private final EventSender m_sender;
    private boolean sourceSideMode = false;
    private int sourceWidth;
    private int sourceHeight;
    private int mouseInSourceX;
    private int mouseInSourceY;
    private boolean leftSide = true;
    private boolean topSide = true;
    private GraphicalEditPart target;
    private Rectangle targetBounds;
    private int mouseX;
    private int mouseY;
    private int mouseOldX;
    private int mouseOldY;

    public GraphicalRobot(GraphicalViewer viewer) {
        this.m_viewer = viewer;
        this.m_sender = new EventSender((Control)viewer.getControl());
    }

    public GraphicalRobot ctrlDown() {
        this.m_sender.ctrlDown();
        return this;
    }

    public GraphicalRobot ctrlUp() {
        this.m_sender.ctrlUp();
        return this;
    }

    public void keyDown(int key) {
        this.m_sender.keyDown(key);
    }

    public void keyDown(int key, char c) {
        this.m_sender.keyDown(key, c);
    }

    public void deselectAll() {
        this.m_viewer.deselectAll();
    }

    public void select(Object ... models) {
        Object[] editParts = this.getEditParts(models);
        this.m_viewer.setSelection((ISelection)new StructuredSelection(editParts));
    }

    public GraphicalRobot create() {
        this.create(0, 0);
        return this;
    }

    public GraphicalRobot create(int width, int height) {
        this.create(width, height, width / 2, height / 2);
        return this;
    }

    private void create(int width, int height, int mouseInSourceX_, int mouseInSourceY_) {
        this.sourceWidth = width;
        this.sourceHeight = height;
        this.mouseInSourceX = mouseInSourceX_;
        this.mouseInSourceY = mouseInSourceY_;
    }

    public GraphicalRobot beginMove(Object object) {
        GraphicalEditPart editPart = this.getEditPart(object);
        Rectangle bounds = GraphicalRobot.getAbsoluteBounds(editPart);
        this.sourceWidth = bounds.width;
        this.sourceHeight = bounds.height;
        this.m_viewer.select((EditPart)editPart);
        this.mouseX = bounds.x;
        this.mouseY = bounds.y;
        while (!(this.m_viewer.findTargetHandle(this.mouseX, this.mouseY) instanceof MoveHandle)) {
            ++this.mouseX;
        }
        this.mouseInSourceX = this.mouseX - bounds.x;
        this.mouseInSourceY = this.mouseY - bounds.y;
        return this.beginDrag();
    }

    public GraphicalRobot toResizeHandle(Object object, int direction) {
        Predicate<Handle> predicate = handle -> {
            if (handle instanceof ResizeHandle) {
                ResizeHandle resizeHandle = (ResizeHandle)handle;
                return resizeHandle.getDirection() == direction;
            }
            return false;
        };
        this.toHandle(object, predicate);
        return this;
    }

    public GraphicalRobot toResizeHandle(Object object, Object type, int direction) {
        Predicate<Handle> predicate = handle -> {
            if (handle.getDragTrackerTool() instanceof ResizeTracker) {
                ResizeTracker resizeTracker = (ResizeTracker)handle.getDragTrackerTool();
                return resizeTracker.getDirection() == direction && Objects.equals(resizeTracker.getRequestType(), type);
            }
            return false;
        };
        this.toHandle(object, predicate);
        return this;
    }

    public GraphicalRobot beginResize(Object object, int direction) {
        this.toResizeHandle(object, direction);
        this.beginDrag();
        return this;
    }

    private GraphicalRobot toHandle(Object object, Predicate<Handle> predicate) {
        GraphicalEditPart editPart = this.getEditPart(object);
        Rectangle bounds = GraphicalRobot.getAbsoluteBounds(editPart);
        this.sourceWidth = bounds.width;
        this.sourceHeight = bounds.height;
        this.m_viewer.select((EditPart)editPart);
        Point location = this.findSideHandle(bounds, predicate);
        Assert.assertNotNull((String)("Side Handle for " + String.valueOf(predicate)), (Object)location);
        this.mouseX = location.x;
        this.mouseY = location.y;
        this.mouseInSourceX = this.mouseX - bounds.x;
        this.mouseInSourceY = this.mouseY - bounds.y;
        return this;
    }

    private Point findSideHandle(Rectangle bounds, Predicate<Handle> predicate) {
        Point location = null;
        location = this.findSideHandle(predicate, bounds, 0, 0, 1, 0);
        if (location == null) {
            location = this.findSideHandle(predicate, bounds, 0, 0, 0, 1);
        }
        if (location == null && (location = this.findSideHandle(predicate, bounds, bounds.width - 1, 0, 0, 1)) != null) {
            location.performTranslate(1, 0);
            location.performTranslate(0, 1);
        }
        if (location == null && (location = this.findSideHandle(predicate, bounds, 0, bounds.height - 1, 1, 0)) != null) {
            location.performTranslate(1, 0);
            location.performTranslate(0, 1);
        }
        return location;
    }

    private Point findSideHandle(Predicate<Handle> predicate, Rectangle bounds, int x, int y, int deltaX, int deltaY) {
        x += bounds.x;
        y += bounds.y;
        while (x < bounds.right() && y < bounds.bottom()) {
            Handle handle = this.m_viewer.findTargetHandle(x, y);
            if (predicate.test(handle)) {
                return handle.getBounds().getCenter();
            }
            x += deltaX;
            y += deltaY;
        }
        return null;
    }

    public GraphicalRobot leftSide() {
        this.leftSide = true;
        return this;
    }

    public GraphicalRobot rightSide() {
        this.leftSide = false;
        return this;
    }

    public GraphicalRobot topSide() {
        this.topSide = true;
        return this;
    }

    public GraphicalRobot bottomSide() {
        this.topSide = false;
        return this;
    }

    public GraphicalRobot mouseMode() {
        this.sourceSideMode = false;
        return this;
    }

    public GraphicalRobot sideMode() {
        this.sourceSideMode = true;
        return this;
    }

    public GraphicalRobot target(Object object) {
        this.target = this.getEditPart(object);
        this.targetBounds = GraphicalRobot.getAbsoluteBounds(this.target);
        return this;
    }

    public GraphicalRobot in(int x, int y) {
        this.inX(x);
        this.inY(y);
        return this;
    }

    public GraphicalRobot inX(int location) {
        int sideInTarget = GraphicalRobot.normalizeIn(location, this.targetBounds.width);
        int mouseInTarget = this.sideToMouseX(sideInTarget);
        this.mouseX = this.targetToAbsoluteX(mouseInTarget);
        return this;
    }

    public GraphicalRobot inY(int location) {
        int sideInTarget = GraphicalRobot.normalizeIn(location, this.targetBounds.height);
        int mouseInTarget = this.sideToMouseY(sideInTarget);
        this.mouseY = this.targetToAbsoluteY(mouseInTarget);
        return this;
    }

    public GraphicalRobot out(int x, int y) {
        this.outX(x);
        this.outY(y);
        return this;
    }

    public GraphicalRobot outX(int location) {
        int sideRelTarget = GraphicalRobot.normalizeOut(location, this.targetBounds.width);
        int mouseRelTarget = this.sideToMouseX(sideRelTarget);
        this.mouseX = this.targetToAbsoluteX(mouseRelTarget);
        return this;
    }

    public GraphicalRobot outY(int location) {
        int sideRelTarget = GraphicalRobot.normalizeOut(location, this.targetBounds.height);
        int mouseRelTarget = this.sideToMouseY(sideRelTarget);
        this.mouseY = this.targetToAbsoluteY(mouseRelTarget);
        return this;
    }

    public GraphicalRobot in(double x, double y) {
        this.inX(x);
        this.inY(y);
        return this;
    }

    public GraphicalRobot inX(double k) {
        if (k > -1.0 && k < 1.0) {
            int location = (int)((double)this.targetBounds.width * k);
            int sideInTarget = GraphicalRobot.normalizeIn(location, this.targetBounds.width);
            int mouseInTarget = this.sideToMouseX(sideInTarget);
            this.mouseX = this.targetToAbsoluteX(mouseInTarget);
        } else {
            this.inX((int)k);
        }
        return this;
    }

    public GraphicalRobot inY(double k) {
        if (k > -1.0 && k < 1.0) {
            int location = (int)((double)this.targetBounds.height * k);
            int sideInTarget = GraphicalRobot.normalizeIn(location, this.targetBounds.height);
            int mouseInTarget = this.sideToMouseY(sideInTarget);
            this.mouseY = this.targetToAbsoluteY(mouseInTarget);
        } else {
            this.inY((int)k);
        }
        return this;
    }

    private static int normalizeIn(int location, int targetSize) {
        if (location < 0) {
            location += targetSize;
        }
        return location;
    }

    private static int normalizeOut(int location, int targetSize) {
        if (location > 0) {
            location += targetSize;
        }
        return location;
    }

    private int sideToMouseX(int side) {
        if (!this.sourceSideMode) {
            return side;
        }
        if (this.leftSide) {
            return side + this.mouseInSourceX;
        }
        return side - (this.sourceWidth - this.mouseInSourceX);
    }

    private int sideToMouseY(int side) {
        if (!this.sourceSideMode) {
            return side;
        }
        if (this.topSide) {
            return side + this.mouseInSourceY;
        }
        return side - (this.sourceHeight - this.mouseInSourceY);
    }

    private int targetToAbsoluteX(int x) {
        return this.targetBounds.x + x;
    }

    private int targetToAbsoluteY(int y) {
        return this.targetBounds.y + y;
    }

    public GraphicalRobot moveTo(int _mouseX, int _mouseY) {
        this.mouseX = _mouseX;
        this.mouseY = _mouseY;
        return this.move();
    }

    public GraphicalRobot moveTo(Object object, int _mouseX, int _mouseY) {
        this.target(object);
        this.in(_mouseX, _mouseY);
        return this.move();
    }

    public GraphicalRobot moveTo(Object object, double _mouseX, double _mouseY) {
        this.target(object);
        this.inX(_mouseX);
        this.inY(_mouseY);
        return this.move();
    }

    public GraphicalRobot moveTo(Object object) {
        return this.moveTo(object, 0, 0);
    }

    public GraphicalRobot moveOn(int deltaX, int deltaY) {
        this.mouseX += deltaX;
        this.mouseY += deltaY;
        return this.move();
    }

    public GraphicalRobot move() {
        this.m_sender.moveTo(this.mouseX, this.mouseY);
        return this;
    }

    public GraphicalRobot beginDrag(int button) {
        this.m_sender.startDrag(this.mouseX, this.mouseY, button);
        this.mouseOldX = this.mouseX;
        this.mouseOldY = this.mouseY;
        return this;
    }

    public GraphicalRobot beginDrag() {
        return this.beginDrag(1);
    }

    public GraphicalRobot beginDrag(int _mouseX, int _mouseY, int button) {
        this.moveTo(_mouseX, _mouseY);
        return this.beginDrag(button);
    }

    public GraphicalRobot beginDrag(Object object, int _mouseX, int _mouseY) {
        Point location = this.getLocation(object, _mouseX, _mouseY);
        return this.beginDrag(location.x, location.y, 1);
    }

    public GraphicalRobot beginDrag(Object object) {
        return this.beginDrag(object, 0, 0);
    }

    public GraphicalRobot dragOn(int deltaX, int deltaY) {
        this.mouseX += deltaX;
        this.mouseY += deltaY;
        return this.drag();
    }

    public GraphicalRobot dragTo(int _mouseX, int _mouseY) {
        this.mouseX = _mouseX;
        this.mouseY = _mouseY;
        return this.drag();
    }

    public GraphicalRobot dragTo(Object object, int _mouseX, int _mouseY) {
        this.target(object);
        this.in(_mouseX, _mouseY);
        return this.drag();
    }

    public GraphicalRobot dragTo(Object object, double _mouseX, double _mouseY) {
        this.target(object);
        this.in(_mouseX, _mouseY);
        return this.drag();
    }

    public GraphicalRobot dragTo(Object object) {
        return this.dragTo(object, 0, 0);
    }

    public GraphicalRobot drag() {
        int deltaX = this.mouseX - this.mouseOldX;
        int deltaY = this.mouseY - this.mouseOldY;
        int deltaX1 = deltaX / 2;
        int deltaX2 = deltaX - deltaX1;
        int deltaY1 = deltaY / 2;
        int deltaY2 = deltaY - deltaY1;
        this.mouseOldX += deltaX1;
        this.mouseOldY += deltaY1;
        this.m_sender.dragTo(this.mouseOldX, this.mouseOldY);
        this.mouseOldX += deltaX2;
        this.mouseOldY += deltaY2;
        this.m_sender.dragTo(this.mouseOldX, this.mouseOldY);
        return this;
    }

    public void endDrag() {
        this.m_sender.endDrag();
    }

    public GraphicalRobot click(int button) {
        this.m_sender.click(button);
        return this;
    }

    public GraphicalRobot click() {
        this.click(1);
        return this;
    }

    public GraphicalRobot click(int x, int y, int button) {
        this.m_sender.click(x, y, button);
        return this;
    }

    public GraphicalRobot click(Object object, int deltaX, int deltaY) {
        Point location = this.getLocation(object, deltaX, deltaY);
        this.click(location.x, location.y, 1);
        return this;
    }

    public GraphicalRobot click(Object object) {
        this.click(object, 0, 0);
        return this;
    }

    public void doubleClick() {
        this.m_sender.doubleClick(this.mouseX, this.mouseY, 1);
    }

    public void doubleClick(Object object) {
        this.doubleClick(object, 1);
    }

    public void doubleClick(Object object, int button) {
        GraphicalEditPart editPart = this.getEditPart(object);
        Rectangle bounds = GraphicalRobot.getAbsoluteBounds(editPart);
        Point location = GraphicalRobot.getLocation(editPart, bounds.width / 2, bounds.height / 2);
        this.m_sender.doubleClick(location.x, location.y, button);
    }

    public void performDirectEdit(Object object, String text) {
        this.select(object);
        this.performDirectEdit(text);
    }

    public void performDirectEdit(String text) {
        this.beginDirectEdit();
        this.animateDirectEdit(text);
    }

    public void animateDirectEdit(String text) {
        SWTBotText textWidget = new SWTBot((Widget)this.m_viewer.getControl()).text();
        textWidget.setText(text);
        this.endDirectEdit((Text)textWidget.widget);
    }

    public void beginDirectEdit() {
        this.keyDown(32, ' ');
    }

    public void endDirectEdit(Text textWidget) {
        new EventSender((Control)textWidget).keyDown(13);
    }

    public GraphicalEditPart getEditPart(final Object object) {
        GraphicalEditPart editPart = this.getEditPartNull(object);
        ((ObjectAssert)Assertions.assertThat((Object)editPart).as(new Description(){

            public String value() {
                return "No EditPart for " + String.valueOf(object);
            }
        })).isNotNull();
        return editPart;
    }

    public GraphicalEditPart getEditPartNull(Object object) {
        GraphicalEditPart editPart = object instanceof GraphicalEditPart ? (GraphicalEditPart)object : (GraphicalEditPart)this.m_viewer.getEditPartRegistry().get(object);
        return editPart;
    }

    public GraphicalEditPart[] getEditParts(Object[] objects) {
        GraphicalEditPart[] editParts = new GraphicalEditPart[objects.length];
        int i = 0;
        while (i < objects.length) {
            editParts[i] = this.getEditPart(objects[i]);
            ++i;
        }
        return editParts;
    }

    public static Rectangle getAbsoluteBounds(GraphicalEditPart editPart) {
        Figure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        FigureUtils.translateFigureToAbsolute((IFigure)figure, (Translatable)bounds);
        return bounds;
    }

    public Rectangle getAbsoluteBounds(Object object) {
        return GraphicalRobot.getAbsoluteBounds(this.getEditPart(object));
    }

    public static Point getLocation(GraphicalEditPart editPart, int deltaX, int deltaY) {
        Rectangle bounds = GraphicalRobot.getAbsoluteBounds(editPart);
        Point location = new Point(0, 0);
        location.x = deltaX >= 0 ? bounds.x + deltaX : bounds.right() + deltaX;
        location.y = deltaY >= 0 ? bounds.y + deltaY : bounds.bottom() + deltaY;
        return location;
    }

    public Point getLocation(Object object, int deltaX, int deltaY) {
        return GraphicalRobot.getLocation(this.getEditPart(object), deltaX, deltaY);
    }

    public Point getLocation(Object object) {
        return this.getLocation(object, 0, 0);
    }

    public static Dimension getSize(GraphicalEditPart editPart) {
        return editPart.getFigure().getSize();
    }

    public Dimension getSize(Object object) {
        return GraphicalRobot.getSize(this.getEditPart(object));
    }

    public List<? extends IFigure> getFeedbackFigures() {
        return this.m_viewer.getLayer("Feedback Layer").getChildren();
    }

    public Command getCommand() throws Exception {
        Tool dragTracker;
        Tool tool = this.m_viewer.getEditDomain().getActiveTool();
        if (tool instanceof SelectionTool && (dragTracker = (Tool)ReflectionUtils.getFieldObject((Object)tool, (String)"m_dragTracker")) != null) {
            tool = dragTracker;
        }
        return (Command)ReflectionUtils.getFieldObject((Object)tool, (String)"m_command");
    }

    public void assertNullEditPart(Object object) {
        Assert.assertNull((Object)this.getEditPartNull(object));
    }

    public void assertNotNullEditPart(Object object) {
        Assert.assertNotNull((Object)this.getEditPartNull(object));
    }

    public GraphicalRobot assertSelectedEmpty() {
        List selectedEditParts = this.m_viewer.getSelectedEditParts();
        Assertions.assertThat((List)selectedEditParts).isEmpty();
        return this;
    }

    public void assertPrimarySelected(Object object) {
        GraphicalEditPart editPart = this.getEditPart(object);
        Assert.assertEquals((long)editPart.getSelected(), (long)2L);
    }

    public void assertSelection(Object ... objects) {
        List selectedEditParts = this.m_viewer.getSelectedEditParts();
        Object[] editParts = this.getEditParts(objects);
        Assertions.assertThat((List)selectedEditParts).containsExactly(editParts);
    }

    public void assertChildrenCount(Object object, int count) {
        GraphicalEditPart editPart = this.getEditPart(object);
        Assertions.assertThat((List)editPart.getChildren()).hasSize(count);
    }

    public void assertFigures(String layerName, Predicate<IFigure> predicate) {
        this.assertFigures(layerName, new Predicate[]{predicate});
    }

    public void assertFigures(String layerName, Predicate<IFigure> ... predicates) {
        Layer feedbackLayer = this.m_viewer.getLayer(layerName);
        List feedbacks = feedbackLayer.getChildren();
        Assert.assertEquals((String)"Wrong count of feedbacks.", (long)feedbacks.size(), (long)predicates.length);
        int i = 0;
        while (i < predicates.length) {
            Predicate<IFigure> predicate = predicates[i];
            IFigure feedback = (IFigure)feedbacks.get(i);
            Assert.assertTrue((String)("Predicate [" + i + "] failed."), (boolean)predicate.test(feedback));
            ++i;
        }
    }

    public void assertNoFeedbacks() {
        this.assertFigures("Feedback Layer", new Predicate[0]);
    }

    public void assertEmptyFlowContainerFeedback(Object host, boolean horizontal) {
        Predicate<IFigure> predicate = this.getEmptyFlowContainerPredicate(host, horizontal);
        this.assertFeedbacks(predicate);
    }

    public void assertFeedbacks(Predicate<IFigure> predicate_1) {
        this.assertFeedbacks0(predicate_1);
    }

    private void assertFeedbacks0(Predicate<IFigure> ... predicates) {
        this.assertFigures("Feedback Layer", predicates);
    }

    public void assertFeedbackFigures(FigureDescription ... descriptions) {
        HashSet<? extends IFigure> feedbackFigures = new HashSet<IFigure>(this.getFeedbackFigures());
        int i = 0;
        while (i < descriptions.length) {
            FigureDescription figureDescription = descriptions[i];
            boolean figureFound = false;
            Iterator<? extends IFigure> I = feedbackFigures.iterator();
            while (I.hasNext()) {
                IFigure figure = I.next();
                if (!figureDescription.match(figure)) continue;
                I.remove();
                figureFound = true;
                break;
            }
            Assert.assertTrue((String)("No figure found for " + String.valueOf(figureDescription)), (boolean)figureFound);
            ++i;
        }
        if (!feedbackFigures.isEmpty()) {
            Object message = "Following figures are not matched:";
            for (IFigure iFigure : feedbackFigures) {
                message = (String)message + "\n\t" + iFigure.getClass().getName() + " " + String.valueOf(iFigure.getBounds()) + " " + iFigure.toString();
            }
            Assert.fail((String)message);
        }
    }

    public void assertNoFeedbackFigures() {
        Assert.assertTrue((String)"Feedback layer should be empty.", (boolean)this.getFeedbackFigures().isEmpty());
    }

    public void assertFeedbackFigures(int count) {
        Assertions.assertThat(this.getFeedbackFigures()).hasSize(count);
    }

    public GraphicalRobot assertCommandNull() throws Exception {
        final Command command = this.getCommand();
        ((ObjectAssert)Assertions.assertThat((Object)command).describedAs(new Description(){

            public String value() {
                return "Unexpected command " + String.valueOf(command);
            }
        })).isNull();
        return this;
    }

    public GraphicalRobot assertCommandNotNull() throws Exception {
        Command command = this.getCommand();
        Assert.assertNotNull((String)"No command.", (Object)command);
        return this;
    }

    public final Predicate<IFigure> getEmptyFlowContainerPredicate(Object hostModel, boolean horizontal) {
        Point p2;
        Point p1;
        GraphicalEditPart host = this.getEditPart(hostModel);
        Rectangle bounds = host.getFigure().getBounds().getCopy();
        FigureUtils.translateFigureToAbsolute((IFigure)host.getFigure(), (Translatable)bounds);
        if (horizontal) {
            p1 = new Point(bounds.x, bounds.y);
            p2 = new Point(bounds.x, bounds.bottom());
        } else {
            p1 = new Point(bounds.x, bounds.y);
            p2 = new Point(bounds.right(), bounds.y);
        }
        if (horizontal) {
            if (bounds.width > 20) {
                p1.x += 5;
                p2.x += 5;
            }
            if (bounds.height > 20) {
                p1.y += 5;
                p2.y -= 5;
            }
        } else {
            if (bounds.width > 20) {
                p1.x += 5;
                p2.x -= 5;
            }
            if (bounds.height > 20) {
                p1.y += 5;
                p2.y += 5;
            }
        }
        return feedback -> {
            if (!(feedback instanceof Polyline)) {
                return false;
            }
            Polyline polyline = (Polyline)feedback;
            PointList points = polyline.getPoints();
            if (points.size() != 2) {
                return false;
            }
            Point p1_ = points.getPoint(0);
            Point p2_ = points.getPoint(1);
            return p1_.equals((Object)p1) && p2_.equals((Object)p2);
        };
    }

    public static final Predicate<IFigure> getLinePredicate(GraphicalEditPart part, int location) {
        Rectangle partBounds = part.getFigure().getBounds().getCopy();
        FigureUtils.translateFigureToAbsolute((IFigure)part.getFigure(), (Translatable)partBounds);
        return feedback -> {
            if (!(feedback instanceof Polyline)) {
                return false;
            }
            Polyline polyline = (Polyline)feedback;
            PointList points = polyline.getPoints();
            if (points.size() != 2) {
                return false;
            }
            Point p1 = points.getPoint(0);
            Point p2 = points.getPoint(1);
            int delta = 5;
            boolean result = true;
            if (location == 8) {
                result &= p1.y == p2.y;
                result &= Math.abs(p1.y - rectangle.y) < delta;
                result &= Math.abs(p1.x - rectangle.x) < delta;
                result &= Math.abs(p2.x - partBounds.right()) < delta;
            } else if (location == 32) {
                result &= p1.y == p2.y;
                result &= Math.abs(p1.y - partBounds.bottom()) < delta;
                result &= Math.abs(p1.x - rectangle.x) < delta;
                result &= Math.abs(p2.x - partBounds.right()) < delta;
            } else if (location == 1) {
                result &= p1.x == p2.x;
                result &= Math.abs(p1.x - rectangle.x) < delta;
                result &= Math.abs(p1.y - rectangle.y) < delta;
                result &= Math.abs(p2.y - partBounds.bottom()) < delta;
            } else if (location == 4) {
                result &= p1.x == p2.x;
                result &= Math.abs(p1.x - partBounds.right()) < delta;
                result &= Math.abs(p1.y - rectangle.y) < delta;
                result &= Math.abs(p2.y - partBounds.bottom()) < delta;
            } else {
                Assert.fail((String)("Unsupported location: " + location));
            }
            return result;
        };
    }

    public final Predicate<IFigure> getLinePredicate(Object object, int location) {
        return GraphicalRobot.getLinePredicate(this.getEditPart(object), location);
    }

    public static final Predicate<IFigure> getTargetPredicate(GraphicalEditPart part) {
        Rectangle partBounds = part.getFigure().getBounds().getCopy();
        FigureUtils.translateFigureToAbsolute((IFigure)part.getFigure(), (Translatable)partBounds);
        partBounds.expand(3, 3);
        return feedback -> partBounds.equals((Object)feedback.getBounds());
    }

    public final Predicate<IFigure> getTargetPredicate(Object object) {
        return GraphicalRobot.getTargetPredicate(this.getEditPart(object));
    }

    public static final class FigureDescription {
        private final Class<?> m_class;
        private final Rectangle m_absoluteBounds;

        public FigureDescription(Class<?> clazz, Rectangle absoluteBounds) {
            this.m_class = clazz;
            this.m_absoluteBounds = absoluteBounds;
        }

        public String toString() {
            return "(" + this.m_class.getName() + ", " + String.valueOf(this.m_absoluteBounds) + ")";
        }

        public boolean match(IFigure figure) {
            boolean match = true;
            match &= this.m_class.isAssignableFrom(figure.getClass());
            if (this.m_absoluteBounds != null) {
                match &= this.m_absoluteBounds.equals((Object)figure.getBounds());
            }
            return match;
        }
    }
}

