/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.utils;

import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class StringUtilitiesTest
extends DesignerTestCase {
    @Test
    public void test_normalizeWhitespaces() throws Exception {
        StringUtilitiesTest.assertEquals((Object)"", (Object)StringUtilities.normalizeWhitespaces((String)""));
        StringUtilitiesTest.assertEquals((Object)"a", (Object)StringUtilities.normalizeWhitespaces((String)"a"));
        StringUtilitiesTest.assertEquals((Object)"a b", (Object)StringUtilities.normalizeWhitespaces((String)"a  b"));
        StringUtilitiesTest.assertEquals((Object)"a b", (Object)StringUtilities.normalizeWhitespaces((String)"a\t\r\nb"));
        StringUtilitiesTest.assertEquals((Object)" a ", (Object)StringUtilities.normalizeWhitespaces((String)" a "));
        StringUtilitiesTest.assertEquals((Object)"a ", (Object)StringUtilities.normalizeWhitespaces((String)"a \t\r\n"));
    }

    @Test
    public void test_getLinePrefix() throws Exception {
        String s = StringUtilitiesTest.getSource("// filler filler filler", "// filler filler filler", "// filler filler filler", "// filler filler filler", "\t\t<script>");
        int index = s.indexOf("<script>");
        String prefix = StringUtilities.getLinePrefix((String)s, (int)index);
        StringUtilitiesTest.assertEquals((Object)"\t\t", (Object)prefix);
        s = "  <script>";
        index = s.indexOf("<script>");
        prefix = StringUtilities.getLinePrefix((String)s, (int)index);
        StringUtilitiesTest.assertEquals((Object)"  ", (Object)prefix);
        s = "<b> <script>";
        index = s.indexOf("<script>");
        prefix = StringUtilities.getLinePrefix((String)s, (int)index);
        StringUtilitiesTest.assertEquals((Object)" ", (Object)prefix);
        s = "<b><script>";
        index = s.indexOf("<script>");
        prefix = StringUtilities.getLinePrefix((String)s, (int)index);
        StringUtilitiesTest.assertEquals((Object)"", (Object)prefix);
    }

    @Test
    public void test_removeFirstWord() throws Exception {
        StringUtilitiesTest.assertEquals((Object)"bbb", (Object)StringUtilities.removeFirstWord((String)"aaa bbb"));
        StringUtilitiesTest.assertEquals((Object)"bbb", (Object)StringUtilities.removeFirstWord((String)"   aaa   bbb  "));
        StringUtilitiesTest.assertEquals((Object)"", (Object)StringUtilities.removeFirstWord((String)""));
        StringUtilitiesTest.assertEquals((Object)"", (Object)StringUtilities.removeFirstWord((String)" \t\r\n"));
    }

    @Test
    public void test_extractCamelCaps() throws Exception {
        StringUtilitiesTest.assertEquals(null, (Object)StringUtilities.extractCamelCaps(null));
        StringUtilitiesTest.assertEquals((Object)"NPE", (Object)StringUtilities.extractCamelCaps((String)"NullPoinerException"));
    }

    @Test
    public void test_extractCamelWords() throws Exception {
        Object[] words = StringUtilities.extractCamelWords(null);
        StringUtilitiesTest.assertArrayEquals((Object[])words, (Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        words = StringUtilities.extractCamelWords((String)"NullPointerException");
        StringUtilitiesTest.assertArrayEquals((Object[])words, (Object[])new String[]{"Null", "Pointer", "Exception"});
    }

    @Test
    public void test_indexOfFirstLowerCase() throws Exception {
        StringUtilitiesTest.assertEquals((long)-1L, (long)StringUtilities.indexOfFirstLowerCase(null));
        StringUtilitiesTest.assertEquals((long)-1L, (long)StringUtilities.indexOfFirstLowerCase((String)""));
        StringUtilitiesTest.assertEquals((long)0L, (long)StringUtilities.indexOfFirstLowerCase((String)"button"));
        StringUtilitiesTest.assertEquals((long)2L, (long)StringUtilities.indexOfFirstLowerCase((String)"JButton"));
        StringUtilitiesTest.assertEquals((long)-1L, (long)StringUtilities.indexOfFirstLowerCase((String)"ABC"));
    }

    @Test
    public void test_stripLeadingUppercaseChars() throws Exception {
        StringUtilitiesTest.assertEquals(null, (Object)StringUtilities.stripLeadingUppercaseChars(null, (int)-1));
        StringUtilitiesTest.assertEquals((Object)"", (Object)StringUtilities.stripLeadingUppercaseChars((String)"", (int)-1));
        StringUtilitiesTest.assertEquals((Object)"button", (Object)StringUtilities.stripLeadingUppercaseChars((String)"button", (int)1));
        StringUtilitiesTest.assertEquals((Object)"utton", (Object)StringUtilities.stripLeadingUppercaseChars((String)"Button", (int)0));
        StringUtilitiesTest.assertEquals((Object)"Button", (Object)StringUtilities.stripLeadingUppercaseChars((String)"Button", (int)1));
        StringUtilitiesTest.assertEquals((Object)"Button", (Object)StringUtilities.stripLeadingUppercaseChars((String)"Button", (int)2));
        StringUtilitiesTest.assertEquals((Object)"Button", (Object)StringUtilities.stripLeadingUppercaseChars((String)"JButton", (int)1));
        StringUtilitiesTest.assertEquals((Object)"Button", (Object)StringUtilities.stripLeadingUppercaseChars((String)"ABCButton", (int)1));
        StringUtilitiesTest.assertEquals((Object)"CButton", (Object)StringUtilities.stripLeadingUppercaseChars((String)"ABCButton", (int)2));
        StringUtilitiesTest.assertEquals((Object)"AbcButton", (Object)StringUtilities.stripLeadingUppercaseChars((String)"AbcButton", (int)2));
    }

    @Test
    public void test_stripHtml() throws Exception {
        StringUtilitiesTest.assertEquals(null, (Object)StringUtilities.stripHtml(null));
        StringUtilitiesTest.assertEquals((Object)"", (Object)StringUtilities.stripHtml((String)""));
        StringUtilitiesTest.assertEquals((Object)"abc", (Object)StringUtilities.stripHtml((String)"abc"));
        StringUtilitiesTest.assertEquals((Object)"acd", (Object)StringUtilities.stripHtml((String)"a<b>c</b>d"));
        StringUtilitiesTest.assertEquals((Object)"ac", (Object)StringUtilities.stripHtml((String)"a<b attr=\"123\">c"));
    }

    @Test
    public void test_deleteDuplicateCharacters() throws Exception {
        StringUtilitiesTest.assertEquals(null, (Object)StringUtilities.removeDuplicateCharacters(null));
        StringUtilitiesTest.assertEquals((Object)"", (Object)StringUtilities.removeDuplicateCharacters((String)""));
        StringUtilitiesTest.assertEquals((Object)"ab", (Object)StringUtilities.removeDuplicateCharacters((String)"aab"));
        StringUtilitiesTest.assertEquals((Object)"abc", (Object)StringUtilities.removeDuplicateCharacters((String)"abbcc"));
    }

    @Test
    public void test_getDifferenceIntervals_same() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 4;
        nArray[2] = 4;
        StringUtilitiesTest.assertIntervals(nArray, StringUtilities.getDifferenceIntervals((String)"0123", (String)"0123"));
    }

    @Test
    public void test_getDifferenceIntervals_inner() throws Exception {
        StringUtilitiesTest.assertIntervals(new int[]{1, 2, 1, 2}, StringUtilities.getDifferenceIntervals((String)"0123", (String)"0ab3"));
    }

    @Test
    public void test_getDifferenceIntervals_inner2() throws Exception {
        StringUtilitiesTest.assertIntervals(new int[]{2, 2, 2, 3}, StringUtilities.getDifferenceIntervals((String)"0123456", (String)"01abc456"));
    }

    @Test
    public void test_getDifferenceIntervals_insert() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[2] = 3;
        nArray[3] = 3;
        StringUtilitiesTest.assertIntervals(nArray, StringUtilities.getDifferenceIntervals((String)"0123", (String)"012abc3"));
    }

    @Test
    public void test_getDifferenceIntervals_end1() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 1;
        nArray[2] = 3;
        StringUtilitiesTest.assertIntervals(nArray, StringUtilities.getDifferenceIntervals((String)"0123", (String)"012"));
    }

    @Test
    public void test_getDifferenceIntervals_end2() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[2] = 3;
        nArray[3] = 1;
        StringUtilitiesTest.assertIntervals(nArray, StringUtilities.getDifferenceIntervals((String)"012", (String)"0123"));
    }

    @Test
    public void test_getDifferenceIntervals_begin1() throws Exception {
        int[] nArray = new int[4];
        nArray[1] = 1;
        StringUtilitiesTest.assertIntervals(nArray, StringUtilities.getDifferenceIntervals((String)"0123", (String)"123"));
    }

    @Test
    public void test_getDifferenceIntervals_begin2() throws Exception {
        int[] nArray = new int[4];
        nArray[3] = 1;
        StringUtilitiesTest.assertIntervals(nArray, StringUtilities.getDifferenceIntervals((String)"123", (String)"0123"));
    }

    private static void assertIntervals(int[] expected, int[] actual) {
        StringUtilitiesTest.assertTrue((String)(ArrayUtils.toString((Object)expected) + " != " + ArrayUtils.toString((Object)actual)), (boolean)ArrayUtils.isEquals((Object)expected, (Object)actual));
    }

    @Test
    public void test_escapeJava() throws Exception {
        StringUtilitiesTest.assertEquals((Object)"a", (Object)StringUtilities.escapeJava((String)"a"));
        StringUtilitiesTest.assertEquals((Object)"\\t", (Object)StringUtilities.escapeJava((String)"\t"));
        StringUtilitiesTest.assertEquals((Object)"\\\\", (Object)StringUtilities.escapeJava((String)"\\"));
        StringUtilitiesTest.assertEquals((Object)"/", (Object)StringUtilities.escapeJava((String)"/"));
    }

    @Test
    public void test_escapeForJavaSource() throws Exception {
        StringUtilitiesTest.assertEquals(null, (Object)StringUtilities.escapeForJavaSource(null));
        StringUtilitiesTest.assertEquals((Object)"abc", (Object)StringUtilities.escapeForJavaSource((String)"abc"));
        StringUtilitiesTest.assertEquals((Object)"/", (Object)StringUtilities.escapeForJavaSource((String)"/"));
        StringUtilitiesTest.assertEquals((Object)"\\\\", (Object)StringUtilities.escapeForJavaSource((String)"\\"));
        StringUtilitiesTest.assertEquals((Object)"\\\"", (Object)StringUtilities.escapeForJavaSource((String)"\""));
        StringUtilitiesTest.assertEquals((Object)"\\b", (Object)StringUtilities.escapeForJavaSource((String)"\b"));
        StringUtilitiesTest.assertEquals((Object)"\\n", (Object)StringUtilities.escapeForJavaSource((String)"\n"));
        StringUtilitiesTest.assertEquals((Object)"\\t", (Object)StringUtilities.escapeForJavaSource((String)"\t"));
        StringUtilitiesTest.assertEquals((Object)"\\f", (Object)StringUtilities.escapeForJavaSource((String)"\f"));
        StringUtilitiesTest.assertEquals((Object)"\\r", (Object)StringUtilities.escapeForJavaSource((String)"\r"));
        StringUtilitiesTest.assertEquals((Object)"\\u0002", (Object)StringUtilities.escapeForJavaSource((String)"\u0002"));
        StringUtilitiesTest.assertEquals((Object)"\\u000F", (Object)StringUtilities.escapeForJavaSource((String)"\u000f"));
        StringUtilitiesTest.assertEquals((Object)"\\u0015", (Object)StringUtilities.escapeForJavaSource((String)"\u0015"));
        StringUtilitiesTest.assertEquals((Object)"\u0410", (Object)StringUtilities.escapeForJavaSource((String)"\u0410"));
    }

    @Test
    public void test_replace() throws Exception {
        Object[] source = new String[]{"my text", "some text"};
        Object[] target = StringUtilities.replace((String[])source, (String)"text", (String)"word");
        StringUtilitiesTest.assertArrayEquals((Object[])target, (Object[])new String[]{"my word", "some word"});
        StringUtilitiesTest.assertArrayEquals((Object[])source, (Object[])new String[]{"my text", "some text"});
    }

    @Test
    public void test_isLatinCharacter() throws Exception {
        StringUtilitiesTest.assertTrue((boolean)StringUtilities.isLatinCharacter((char)'A'));
        StringUtilitiesTest.assertTrue((boolean)StringUtilities.isLatinCharacter((char)'P'));
        StringUtilitiesTest.assertTrue((boolean)StringUtilities.isLatinCharacter((char)'Z'));
        StringUtilitiesTest.assertTrue((boolean)StringUtilities.isLatinCharacter((char)'a'));
        StringUtilitiesTest.assertTrue((boolean)StringUtilities.isLatinCharacter((char)'p'));
        StringUtilitiesTest.assertTrue((boolean)StringUtilities.isLatinCharacter((char)'z'));
        StringUtilitiesTest.assertFalse((boolean)StringUtilities.isLatinCharacter((char)'0'));
        StringUtilitiesTest.assertFalse((boolean)StringUtilities.isLatinCharacter((char)'.'));
        StringUtilitiesTest.assertFalse((boolean)StringUtilities.isLatinCharacter((char)'\u0400'));
    }

    @Test
    public void test_removeNonLatinCharacters() throws Exception {
        StringUtilitiesTest.assertEquals((Object)"abc", (Object)StringUtilities.removeNonLatinCharacters((String)"abc"));
        StringUtilitiesTest.assertEquals((Object)"ab", (Object)StringUtilities.removeNonLatinCharacters((String)"a\u0410b"));
        StringUtilitiesTest.assertEquals((Object)"abc", (Object)StringUtilities.removeNonLatinCharacters((String)"a@b.c"));
    }
}

