/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.internal.win7.Win7ColumnGroupHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.win7.Win7EmptyColumnHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.win7.Win7GridColumnHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.win7.Win7PaletteProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class Win7RendererSupport {
    private Win7PaletteProvider palette;
    private Win7GridColumnHeaderRenderer headerRenderer;
    private Win7EmptyColumnHeaderRenderer emptyHeaderRenderer;
    private Win7ColumnGroupHeaderRenderer groupHeaderRenderer;
    private Grid grid;

    private Win7RendererSupport(Grid agrid) {
        this.grid = agrid;
        this.palette = new Win7PaletteProvider();
        this.grid.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Win7RendererSupport.this.grid.removeDisposeListener(this);
                if (Win7RendererSupport.this.palette != null) {
                    Win7RendererSupport.this.palette.dispose();
                }
                Win7RendererSupport.this.headerRenderer = null;
                Win7RendererSupport.this.emptyHeaderRenderer = null;
                Win7RendererSupport.this.groupHeaderRenderer = null;
            }
        });
    }

    public static Win7RendererSupport create(Grid grid) {
        return new Win7RendererSupport(grid);
    }

    public Win7RendererSupport decorateColumnHeader(GridColumn col) {
        if (this.headerRenderer == null) {
            this.headerRenderer = new Win7GridColumnHeaderRenderer(this.palette);
        }
        col.setHeaderRenderer(this.headerRenderer);
        return this;
    }

    public Win7RendererSupport decorateColumnHeaders(GridColumn[] cols) {
        int i = 0;
        while (i < cols.length) {
            this.decorateColumnHeader(cols[i]);
            ++i;
        }
        return this;
    }

    public Win7RendererSupport decorateColumnGroupHeader(GridColumnGroup group) {
        if (this.groupHeaderRenderer == null) {
            this.groupHeaderRenderer = new Win7ColumnGroupHeaderRenderer(this.palette);
        }
        group.setHeaderRenderer(this.groupHeaderRenderer);
        this.decorateColumnHeaders(group.getColumns());
        return this;
    }

    public Win7RendererSupport decorateColumnGroupHeaders(GridColumnGroup[] groups) {
        int i = 0;
        while (i < groups.length) {
            this.decorateColumnGroupHeader(groups[i]);
            ++i;
        }
        return this;
    }

    public Win7RendererSupport decorateEmptyColumnHeader() {
        if (this.emptyHeaderRenderer == null) {
            this.emptyHeaderRenderer = new Win7EmptyColumnHeaderRenderer(this.palette);
        }
        this.grid.setEmptyColumnHeaderRenderer(this.emptyHeaderRenderer);
        return this;
    }

    public Win7RendererSupport decorate() {
        this.decorateEmptyColumnHeader();
        this.decorateColumnGroupHeaders(this.grid.getColumnGroups());
        this.decorateColumnHeaders(this.grid.getColumns());
        return this;
    }
}

