/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.spi.HeaderFilterStrategy;

public class DefaultHeaderFilterStrategy
implements HeaderFilterStrategy {
    private Set<String> inFilter;
    private Pattern inFilterPattern;
    private Set<String> outFilter;
    private Pattern outFilterPattern;
    private boolean lowerCase;
    private boolean allowNullValues;
    private boolean caseInsensitive;

    @Override
    public boolean applyFilterToCamelHeaders(String headerName, Object headerValue, Exchange exchange) {
        return this.doFiltering(HeaderFilterStrategy.Direction.OUT, headerName, headerValue, exchange);
    }

    @Override
    public boolean applyFilterToExternalHeaders(String headerName, Object headerValue, Exchange exchange) {
        return this.doFiltering(HeaderFilterStrategy.Direction.IN, headerName, headerValue, exchange);
    }

    public Set<String> getOutFilter() {
        if (this.outFilter == null) {
            this.outFilter = new HashSet<String>();
        }
        return this.outFilter;
    }

    public void setOutFilter(Set<String> value) {
        this.outFilter = value;
    }

    public String getOutFilterPattern() {
        return this.outFilterPattern == null ? null : this.outFilterPattern.pattern();
    }

    public void setOutFilterPattern(String value) {
        this.outFilterPattern = value == null ? null : Pattern.compile(value);
    }

    public Set<String> getInFilter() {
        if (this.inFilter == null) {
            this.inFilter = new HashSet<String>();
        }
        return this.inFilter;
    }

    public void setInFilter(Set<String> value) {
        this.inFilter = value;
    }

    public String getInFilterPattern() {
        return this.inFilterPattern == null ? null : this.inFilterPattern.pattern();
    }

    public void setInFilterPattern(String value) {
        this.inFilterPattern = value == null ? null : Pattern.compile(value);
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean value) {
        this.lowerCase = value;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public void setAllowNullValues(boolean value) {
        this.allowNullValues = value;
    }

    protected boolean extendedFilter(HeaderFilterStrategy.Direction direction, String key, Object value, Exchange exchange) {
        return false;
    }

    private boolean doFiltering(HeaderFilterStrategy.Direction direction, String headerName, Object headerValue, Exchange exchange) {
        if (headerName == null) {
            return true;
        }
        if (headerValue == null && !this.allowNullValues) {
            return true;
        }
        Pattern pattern = null;
        Set<String> filter = null;
        if (HeaderFilterStrategy.Direction.OUT == direction) {
            pattern = this.outFilterPattern;
            filter = this.outFilter;
        } else if (HeaderFilterStrategy.Direction.IN == direction) {
            pattern = this.inFilterPattern;
            filter = this.inFilter;
        }
        if (pattern != null && pattern.matcher(headerName).matches()) {
            return true;
        }
        if (filter != null) {
            if (this.isCaseInsensitive()) {
                for (String filterString : filter) {
                    if (!filterString.equalsIgnoreCase(headerName)) continue;
                    return true;
                }
            } else if (this.isLowerCase() ? filter.contains(headerName.toLowerCase(Locale.ENGLISH)) : filter.contains(headerName)) {
                return true;
            }
        }
        return this.extendedFilter(direction, headerName, headerValue, exchange);
    }
}

