/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.CamelContext;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.support.task.Task;
import org.apache.camel.support.task.TaskManagerRegistry;

public class DefaultTaskManagerRegistry
extends ServiceSupport
implements TaskManagerRegistry {
    private final CamelContext camelContext;
    private final Set<Task> tasks = new CopyOnWriteArraySet<Task>();

    public DefaultTaskManagerRegistry(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.tasks.clear();
    }

    @Override
    public void addTask(Task task) {
        this.tasks.add(task);
    }

    @Override
    public void removeTask(Task task) {
        this.tasks.remove(task);
    }

    @Override
    public int getSize() {
        return this.tasks.size();
    }

    @Override
    public Set<Task> getTasks() {
        return Collections.unmodifiableSet(this.tasks);
    }
}

