/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl;

import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import java.io.IOException;
import org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.apache.bookkeeper.stream.storage.api.StorageContainerStore;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainer;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerManager;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerManagerFactory;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerRegistry;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerRoutingService;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerServiceFactory;
import org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.apache.bookkeeper.stream.storage.impl.routing.RangeRoutingTable;
import org.apache.bookkeeper.stream.storage.impl.routing.RangeRoutingTableImpl;
import org.apache.bookkeeper.stream.storage.impl.routing.StorageContainerProxyChannelManager;
import org.apache.bookkeeper.stream.storage.impl.routing.StorageContainerProxyChannelManagerImpl;
import org.apache.bookkeeper.stream.storage.impl.sc.DefaultStorageContainerFactory;
import org.apache.bookkeeper.stream.storage.impl.sc.StorageContainerRegistryImpl;

public class StorageContainerStoreImpl
extends AbstractLifecycleComponent<StorageConfiguration>
implements StorageContainerStore {
    private final StorageContainerManagerFactory scmFactory;
    private final StorageContainerRegistryImpl scRegistry;
    private final StorageContainerManager scManager;
    private final StorageContainerServiceFactory serviceFactory;
    private final StorageServerClientManager ssClientManager;
    private final RangeRoutingTable routingTable;
    private final StorageContainerProxyChannelManager proxyChannelManager;

    public StorageContainerStoreImpl(StorageConfiguration conf, StorageContainerManagerFactory managerFactory, StorageContainerServiceFactory serviceFactory, StorageServerClientManager ssClientManager, StatsLogger statsLogger) {
        super("range-service", (ComponentConfiguration)conf, statsLogger);
        this.scmFactory = managerFactory;
        this.scRegistry = new StorageContainerRegistryImpl(new DefaultStorageContainerFactory(serviceFactory));
        this.scManager = this.scmFactory.create(conf, (StorageContainerRegistry)this.scRegistry);
        this.serviceFactory = serviceFactory;
        this.ssClientManager = ssClientManager;
        if (ssClientManager == null) {
            this.proxyChannelManager = null;
            this.routingTable = null;
        } else {
            this.proxyChannelManager = new StorageContainerProxyChannelManagerImpl(ssClientManager);
            this.routingTable = new RangeRoutingTableImpl(ssClientManager);
        }
    }

    public StorageContainerRegistryImpl getRegistry() {
        return this.scRegistry;
    }

    public StorageContainerRoutingService getRoutingService() {
        return this.scManager;
    }

    protected void doStart() {
        this.scManager.start();
    }

    protected void doStop() {
        if (null != this.ssClientManager) {
            this.ssClientManager.closeAsync();
        }
        this.scManager.stop();
        this.scRegistry.close();
    }

    protected void doClose() throws IOException {
        this.scManager.close();
        this.serviceFactory.close();
    }

    StorageContainer getStorageContainer(long scId) {
        return this.scRegistry.getStorageContainer(scId);
    }

    StorageContainer getStorageContainer(long scId, StorageContainer defaultContainer) {
        return this.scRegistry.getStorageContainer(scId, defaultContainer);
    }

    public Channel findChannel(ServerCall<?, ?> serverCall, Metadata headers) {
        RangeProperties rangeProps;
        Long scId = (Long)headers.get(ProtocolConstants.SCID_METADATA_KEY);
        if (null != scId) {
            StorageContainer container = this.getStorageContainer(scId, null);
            if (null != container) {
                return container.getChannel();
            }
            if (scId == 0L && null != this.proxyChannelManager) {
                Channel channel = this.proxyChannelManager.getStorageContainerChannel(0L);
                if (null != channel) {
                    return channel;
                }
                return this.getStorageContainer(-1L).getChannel();
            }
            return this.getStorageContainer(-1L).getChannel();
        }
        byte[] routingKey = (byte[])headers.get(ProtocolConstants.RK_METADATA_KEY);
        Long streamId = (Long)headers.get(ProtocolConstants.SID_METADATA_KEY);
        if (null != routingKey && null != streamId && null != this.routingTable && null != this.proxyChannelManager && null != (rangeProps = this.routingTable.getRange(streamId, routingKey))) {
            long containerId = rangeProps.getStorageContainerId();
            long rangeId = rangeProps.getRangeId();
            headers.put(ProtocolConstants.SCID_METADATA_KEY, (Object)containerId);
            headers.put(ProtocolConstants.RID_METADATA_KEY, (Object)rangeId);
            StorageContainer container = this.getStorageContainer(containerId, null);
            if (null == container) {
                Channel channel = this.proxyChannelManager.getStorageContainerChannel(containerId);
                if (null != channel) {
                    return channel;
                }
            } else {
                return container.getChannel();
            }
        }
        return this.getStorageContainer(-1L).getChannel();
    }
}

