/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.bk;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.commons.configuration2.Configuration;
import org.apache.distributedlog.BookKeeperClient;
import org.apache.distributedlog.BookKeeperClientBuilder;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.bk.LedgerAllocatorPool;
import org.apache.distributedlog.bk.SimpleLedgerAllocator;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.util.Utils;
import org.apache.distributedlog.zk.ZKTransaction;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLedgerAllocatorPool
extends TestDistributedLogBase {
    private static final Logger logger = LoggerFactory.getLogger(TestLedgerAllocatorPool.class);
    private static final String ledgersPath = "/ledgers";
    private static final Transaction.OpListener<LedgerHandle> NULL_LISTENER = new Transaction.OpListener<LedgerHandle>(){

        public void onCommit(LedgerHandle r) {
        }

        public void onAbort(Throwable t) {
        }
    };
    @Rule
    public TestName runtime = new TestName();
    private ZooKeeperClient zkc;
    private BookKeeperClient bkc;
    private DistributedLogConfiguration dlConf = new DistributedLogConfiguration();
    private ScheduledExecutorService allocationExecutor;

    private URI createURI(String path) {
        return URI.create("distributedlog://" + zkServers + path);
    }

    @Override
    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createURI("/")).build();
        this.bkc = BookKeeperClientBuilder.newBuilder().name("bkc").dlConfig(this.dlConf).ledgersPath(ledgersPath).zkc(this.zkc).build();
        this.allocationExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    @After
    public void teardown() throws Exception {
        this.bkc.close();
        this.zkc.close();
        this.allocationExecutor.shutdown();
    }

    private ZKTransaction newTxn() {
        return new ZKTransaction(this.zkc);
    }

    private void validatePoolSize(LedgerAllocatorPool pool, int pendingSize, int allocatingSize, int obtainingSize, int rescueSize) {
        Assert.assertEquals((long)pendingSize, (long)pool.pendingListSize());
        Assert.assertEquals((long)allocatingSize, (long)pool.allocatingListSize());
        Assert.assertEquals((long)obtainingSize, (long)pool.obtainMapSize());
        Assert.assertEquals((long)rescueSize, (long)pool.rescueSize());
    }

    @Test(timeout=60000L)
    public void testNonAvailableAllocator() throws Exception {
        int i;
        String allocationPath = "/nonAvailableAllocator";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)this.dlConf);
        confLocal.setEnsembleSize(2 * numBookies);
        confLocal.setWriteQuorumSize(2 * numBookies);
        int numAllocators = 3;
        LedgerAllocatorPool pool = new LedgerAllocatorPool(allocationPath, numAllocators, confLocal, this.zkc, this.bkc, this.allocationExecutor);
        for (i = 0; i < numAllocators; ++i) {
            try {
                pool.allocate();
                Utils.ioResult((CompletableFuture)pool.tryObtain((Transaction)this.newTxn(), NULL_LISTENER));
                Assert.fail((String)"Should fail to allocate ledger if there are enought bookies");
                continue;
            }
            catch (SimpleLedgerAllocator.AllocationException ae) {
                Assert.assertEquals((Object)SimpleLedgerAllocator.Phase.ERROR, (Object)ae.getPhase());
            }
        }
        for (i = 0; i < numAllocators; ++i) {
            try {
                pool.allocate();
                Utils.ioResult((CompletableFuture)pool.tryObtain((Transaction)this.newTxn(), NULL_LISTENER));
                Assert.fail((String)"Should fail to allocate ledger if there aren't available allocators");
                continue;
            }
            catch (SimpleLedgerAllocator.AllocationException ae) {
                Assert.assertEquals((Object)SimpleLedgerAllocator.Phase.ERROR, (Object)ae.getPhase());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Utils.close((AsyncCloseable)pool);
    }

    @Test(timeout=60000L)
    public void testRescueAllocators() throws Exception {
        ZKTransaction txn;
        int i;
        String allocationPath = "/rescueAllocators";
        int numAllocators = 3;
        LedgerAllocatorPool pool = new LedgerAllocatorPool(allocationPath, numAllocators, this.dlConf, this.zkc, this.bkc, this.allocationExecutor);
        ArrayList pendingTxns = Lists.newArrayListWithExpectedSize((int)numAllocators);
        ArrayList allocatePaths = Lists.newArrayListWithExpectedSize((int)numAllocators);
        for (i = 0; i < numAllocators; ++i) {
            txn = this.newTxn();
            pool.allocate();
            LedgerHandle lh = (LedgerHandle)Utils.ioResult((CompletableFuture)pool.tryObtain((Transaction)txn, NULL_LISTENER));
            SimpleLedgerAllocator sla = pool.getLedgerAllocator(lh);
            String slaPath = sla.allocatePath;
            logger.info("Allocated ledger {} from path {}", (Object)lh.getId(), (Object)slaPath);
            pendingTxns.add(txn);
            allocatePaths.add(slaPath);
        }
        for (i = 0; i < numAllocators; ++i) {
            txn = (ZKTransaction)pendingTxns.get(i);
            String slaPath = (String)allocatePaths.get(i);
            Utils.ioResult((CompletableFuture)txn.execute());
            byte[] data = this.zkc.get().getData(slaPath, false, new Stat());
            this.zkc.get().setData(slaPath, data, -1);
        }
        int numSuccess = 0;
        HashSet<String> allocatedPathSet = new HashSet<String>();
        while (numSuccess < 2 * numAllocators) {
            try {
                pool.allocate();
                ZKTransaction txn2 = this.newTxn();
                LedgerHandle lh = (LedgerHandle)Utils.ioResult((CompletableFuture)pool.tryObtain((Transaction)txn2, NULL_LISTENER));
                SimpleLedgerAllocator sla = pool.getLedgerAllocator(lh);
                String slaPath = sla.allocatePath;
                logger.info("Allocated ledger {} from path {}", (Object)lh.getId(), (Object)slaPath);
                allocatedPathSet.add(slaPath);
                Utils.ioResult((CompletableFuture)txn2.execute());
                ++numSuccess;
            }
            catch (IOException iOException) {}
        }
        Assert.assertEquals((long)(2 * numAllocators), (long)numSuccess);
        Assert.assertEquals((long)numAllocators, (long)allocatedPathSet.size());
        Utils.close((AsyncCloseable)pool);
    }

    @Test(timeout=60000L)
    public void testAllocateWhenNoAllocator() throws Exception {
        String allocationPath = "/allocateWhenNoAllocator";
        LedgerAllocatorPool pool = new LedgerAllocatorPool(allocationPath, 0, this.dlConf, this.zkc, this.bkc, this.allocationExecutor);
        try {
            pool.allocate();
            Assert.fail((String)"Should fail to allocate ledger if there isn't allocator.");
        }
        catch (SimpleLedgerAllocator.AllocationException ae) {
            Assert.fail((String)"Should fail to allocate ledger if there isn't allocator.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Utils.close((AsyncCloseable)pool);
    }

    @Test(timeout=60000L)
    public void testObtainWhenNoAllocator() throws Exception {
        String allocationPath = "/obtainWhenNoAllocator";
        LedgerAllocatorPool pool = new LedgerAllocatorPool(allocationPath, 0, this.dlConf, this.zkc, this.bkc, this.allocationExecutor);
        ZKTransaction txn = this.newTxn();
        try {
            Utils.ioResult((CompletableFuture)pool.tryObtain((Transaction)txn, NULL_LISTENER));
            Assert.fail((String)"Should fail obtain ledger handle if there is no allocator.");
        }
        catch (SimpleLedgerAllocator.AllocationException ae) {
            Assert.fail((String)"Should fail obtain ledger handle if there is no allocator.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Utils.close((AsyncCloseable)pool);
    }

    @Test(timeout=60000L)
    public void testAllocateMultipleLedgers() throws Exception {
        String allocationPath = "/" + this.runtime.getMethodName();
        int numAllocators = 5;
        LedgerAllocatorPool pool = new LedgerAllocatorPool(allocationPath, numAllocators, this.dlConf, this.zkc, this.bkc, this.allocationExecutor);
        int numLedgers = 20;
        HashSet<LedgerHandle> allocatedLedgers = new HashSet<LedgerHandle>();
        for (int i = 0; i < numLedgers; ++i) {
            pool.allocate();
            ZKTransaction txn = this.newTxn();
            LedgerHandle lh = (LedgerHandle)Utils.ioResult((CompletableFuture)pool.tryObtain((Transaction)txn, NULL_LISTENER));
            Utils.ioResult((CompletableFuture)txn.execute());
            allocatedLedgers.add(lh);
        }
        Assert.assertEquals((long)numLedgers, (long)allocatedLedgers.size());
    }

    @Test(timeout=60000L)
    public void testConcurrentAllocation() throws Exception {
        int numAllocators = 5;
        String allocationPath = "/concurrentAllocation";
        final LedgerAllocatorPool pool = new LedgerAllocatorPool(allocationPath, 5, this.dlConf, this.zkc, this.bkc, this.allocationExecutor);
        final ConcurrentHashMap allocatedLedgers = new ConcurrentHashMap();
        final AtomicInteger numFailures = new AtomicInteger(0);
        Thread[] allocationThreads = new Thread[5];
        for (int i = 0; i < 5; ++i) {
            final int tid = i;
            allocationThreads[i] = new Thread(){
                int numLedgers = 50;

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < this.numLedgers; ++i) {
                            pool.allocate();
                            ZKTransaction txn = TestLedgerAllocatorPool.this.newTxn();
                            LedgerHandle lh = (LedgerHandle)Utils.ioResult((CompletableFuture)pool.tryObtain((Transaction)txn, NULL_LISTENER));
                            Utils.ioResult((CompletableFuture)txn.execute());
                            lh.close();
                            allocatedLedgers.putIfAbsent(lh.getId(), lh);
                            logger.info("[thread {}] allocate {}th ledger {}", new Object[]{tid, i, lh.getId()});
                        }
                    }
                    catch (Exception ioe) {
                        numFailures.incrementAndGet();
                    }
                }
            };
        }
        for (Thread t : allocationThreads) {
            t.start();
        }
        for (Thread t : allocationThreads) {
            t.join();
        }
        Assert.assertEquals((long)0L, (long)numFailures.get());
        Assert.assertEquals((long)250L, (long)allocatedLedgers.size());
        Utils.close((AsyncCloseable)pool);
    }
}

