/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mockit.Mock;
import mockit.MockUp;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestThrottler;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottledOpHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(ThrottledOpHelper.class);

    public static void applyMockUps() {
        new RequestThrottleMock();
    }

    public void testThrottledOp(ZooKeeper zk, ZooKeeperServer zs) throws IOException, InterruptedException, KeeperException {
        Stat stat;
        String nodeName;
        int i;
        int N = 5;
        int COUNT = 100;
        RequestThrottleMock.throttleEveryNthOp(5);
        LOG.info("Before create /ivailo nodes");
        int opCount = 0;
        for (i = 0; i < 100; ++i) {
            nodeName = "/ivailo" + i;
            if (opCount % 5 == 4) {
                try {
                    zk.create(nodeName, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, i % 2 == 0 ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL);
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                catch (KeeperException.ThrottledOpException e) {
                    stat = zk.exists(nodeName, null);
                    Assertions.assertNull((Object)stat);
                    zk.create(nodeName, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, i % 2 == 0 ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL);
                }
                catch (KeeperException e) {
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                opCount += 3;
            } else {
                zk.create(nodeName, "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, i % 2 == 0 ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL);
                ++opCount;
            }
            if (opCount % 5 == 4) {
                try {
                    zk.setData(nodeName, nodeName.getBytes(), -1);
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                catch (KeeperException.ThrottledOpException e) {
                    zk.setData(nodeName, nodeName.getBytes(), -1);
                }
                catch (KeeperException e) {
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                opCount += 2;
                continue;
            }
            zk.setData(nodeName, nodeName.getBytes(), -1);
            ++opCount;
        }
        LOG.info("Before delete /ivailo nodes");
        for (i = 0; i < 100; ++i) {
            Stat stat2;
            nodeName = "/ivailo" + i;
            if (opCount % 5 == 4) {
                try {
                    zk.exists(nodeName, null);
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                catch (KeeperException.ThrottledOpException e) {
                    stat = zk.exists(nodeName, null);
                    Assertions.assertNotNull((Object)stat);
                    opCount += 2;
                }
                catch (KeeperException e) {
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
            } else {
                stat2 = zk.exists(nodeName, null);
                Assertions.assertNotNull((Object)stat2);
                ++opCount;
            }
            if (opCount % 5 == 4) {
                try {
                    zk.getData(nodeName, null, null);
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                catch (KeeperException.ThrottledOpException e) {
                    byte[] data = zk.getData(nodeName, null, null);
                    Assertions.assertEquals((Object)nodeName, (Object)new String(data));
                    opCount += 2;
                }
                catch (KeeperException e) {
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
            } else {
                byte[] data = zk.getData(nodeName, null, null);
                Assertions.assertEquals((Object)nodeName, (Object)new String(data));
                ++opCount;
            }
            if (opCount % 5 == 4) {
                try {
                    zk.delete(nodeName, 0);
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                catch (KeeperException.ThrottledOpException e) {
                    zk.delete(nodeName, -1);
                }
                catch (KeeperException e) {
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                opCount += 2;
            } else {
                zk.delete(nodeName, -1);
                ++opCount;
            }
            if (opCount % 5 == 4) {
                try {
                    zk.exists(nodeName, null);
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                catch (KeeperException.ThrottledOpException e) {
                    stat = zk.exists(nodeName, null);
                    Assertions.assertNull((Object)stat);
                    opCount += 2;
                }
                catch (KeeperException e) {
                    Assertions.fail((String)"Should have gotten ThrottledOp exception");
                }
                continue;
            }
            stat2 = zk.exists(nodeName, null);
            Assertions.assertNull((Object)stat2);
            ++opCount;
        }
        LOG.info("After delete /ivailo");
        zk.close();
    }

    public void testThrottledAcl(ZooKeeper zk, ZooKeeperServer zs) throws Exception {
        RequestThrottleMock.throttleEveryNthOp(0);
        ArrayList<ACL> ACL_PERMS = new ArrayList<ACL>(){
            {
                this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                this.add(new ACL(2, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
            }
        };
        String path = "/path1";
        zk.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.addAuthInfo("digest", "pat:test".getBytes());
        List defaultAcls = zk.getACL(path, null);
        Assertions.assertEquals((int)1, (int)defaultAcls.size());
        RequestThrottleMock.throttleEveryNthOp(2);
        path = "/path2";
        zk.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            zk.setACL(path, (List)ACL_PERMS, -1);
            Assertions.fail((String)"Should have gotten ThrottledOp exception");
        }
        catch (KeeperException.ThrottledOpException throttledOpException) {
        }
        catch (KeeperException e) {
            Assertions.fail((String)"Should have gotten ThrottledOp exception");
        }
        List acls = zk.getACL(path, null);
        Assertions.assertEquals((int)1, (int)acls.size());
        RequestThrottleMock.throttleEveryNthOp(0);
        path = "/path3";
        zk.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.setACL(path, (List)ACL_PERMS, -1);
        acls = zk.getACL(path, null);
        Assertions.assertEquals((int)3, (int)acls.size());
    }

    public static final class RequestThrottleMock
    extends MockUp<RequestThrottler> {
        private static int everyNthOp = 0;
        private static int opCounter = 0;

        public static void throttleEveryNthOp(int n) {
            everyNthOp = n;
            opCounter = 0;
        }

        @Mock
        private boolean shouldThrottleOp(Request request, long elapsedTime) {
            if (everyNthOp > 0 && request.isThrottlable() && ++opCounter % everyNthOp == 0) {
                opCounter %= everyNthOp;
                return true;
            }
            return false;
        }
    }
}

