/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchEventWhenAutoResetTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(WatchEventWhenAutoResetTest.class);
    private static final int TIMEOUT = 30000;
    private QuorumUtil qu;
    private EventsWatcher watcher;
    private ZooKeeper zk1;
    private ZooKeeper zk2;

    private ZooKeeper createClient(QuorumUtil qu, int id, EventsWatcher watcher) throws IOException {
        String hostPort = "127.0.0.1:" + qu.getPeer((int)id).clientPort;
        ZooKeeper zk = new ZooKeeper(hostPort, 30000, (Watcher)watcher);
        try {
            watcher.waitForConnected(30000L);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TimeoutException e) {
            Assertions.fail((String)("can not connect to " + hostPort));
        }
        return zk;
    }

    private ZooKeeper createClient(QuorumUtil qu, int id) throws IOException {
        return this.createClient(qu, id, new EventsWatcher());
    }

    @BeforeEach
    public void setUp() throws IOException {
        System.setProperty("zookeeper.admin.enableServer", "false");
        this.qu = new QuorumUtil(1);
        this.qu.startAll();
        this.watcher = new EventsWatcher();
        this.zk1 = this.createClient(this.qu, 1, this.watcher);
        this.zk2 = this.createClient(this.qu, 2);
    }

    @AfterEach
    public void tearDown() throws InterruptedException {
        if (this.zk1 != null) {
            this.zk1.close();
            this.zk1 = null;
        }
        if (this.zk2 != null) {
            this.zk2.close();
            this.zk2 = null;
        }
        if (this.watcher != null) {
            this.watcher = null;
        }
        if (this.qu != null) {
            this.qu.shutdownAll();
            this.qu = null;
        }
    }

    @Test
    public void testNodeDataChanged() throws Exception {
        String path = "/test-changed";
        this.zk1.create(path, new byte[1], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat1 = this.zk1.exists(path, (Watcher)this.watcher);
        this.qu.shutdown(1);
        this.zk2.setData(path, new byte[2], stat1.getVersion());
        this.qu.start(1);
        this.watcher.waitForConnected(30000L);
        this.watcher.assertEvent(30000L, Watcher.Event.EventType.NodeDataChanged);
    }

    @Test
    public void testNodeCreated() throws Exception {
        String path = "/test1-created";
        this.zk1.exists(path, (Watcher)this.watcher);
        this.qu.shutdown(1);
        this.zk2.create(path, new byte[2], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.qu.start(1);
        this.watcher.waitForConnected(30000000L);
        this.watcher.assertEvent(30000L, Watcher.Event.EventType.NodeCreated);
    }

    @Test
    public void testNodeDeleted() throws Exception {
        String path = "/test-deleted";
        this.zk1.create(path, new byte[1], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk1.getData(path, (Watcher)this.watcher, null);
        this.qu.shutdown(1);
        this.zk2.delete(path, -1);
        this.qu.start(1);
        this.watcher.waitForConnected(30000000L);
        this.watcher.assertEvent(30000L, Watcher.Event.EventType.NodeDeleted);
        this.zk1.create(path, new byte[1], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk1.exists(path, (Watcher)this.watcher);
        this.qu.shutdown(1);
        this.zk2.delete(path, -1);
        this.qu.start(1);
        this.watcher.waitForConnected(30000000L);
        this.watcher.assertEvent(30000L, Watcher.Event.EventType.NodeDeleted);
        this.zk1.create(path, new byte[1], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk1.getChildren(path, (Watcher)this.watcher);
        this.qu.shutdown(1);
        this.zk2.delete(path, -1);
        this.qu.start(1);
        this.watcher.waitForConnected(30000000L);
        this.watcher.assertEvent(30000L, Watcher.Event.EventType.NodeDeleted);
    }

    @Test
    public void testNodeChildrenChanged() throws Exception {
        String path = "/test-children-changed";
        this.zk1.create(path, new byte[1], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk1.getChildren(path, (Watcher)this.watcher);
        this.qu.shutdown(1);
        this.zk2.create(path + "/children-1", new byte[2], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.qu.start(1);
        this.watcher.waitForConnected(30000000L);
        this.watcher.assertEvent(30000L, Watcher.Event.EventType.NodeChildrenChanged);
    }

    public static class EventsWatcher
    extends ClientBase.CountdownWatcher {
        private LinkedBlockingQueue<WatchedEvent> dataEvents = new LinkedBlockingQueue();

        @Override
        public void process(WatchedEvent event) {
            super.process(event);
            try {
                if (event.getType() != Watcher.Event.EventType.None) {
                    this.dataEvents.put(event);
                }
            }
            catch (InterruptedException e) {
                LOG.warn("ignoring interrupt during EventsWatcher process");
            }
        }

        public void assertEvent(long timeout, Watcher.Event.EventType eventType) {
            try {
                WatchedEvent event = this.dataEvents.poll(timeout, TimeUnit.MILLISECONDS);
                Assertions.assertNotNull((Object)event, (String)("do not receive a " + eventType));
                Assertions.assertEquals((Object)eventType, (Object)event.getType());
            }
            catch (InterruptedException e) {
                LOG.warn("ignoring interrupt during EventsWatcher assertEvent");
            }
        }
    }
}

