/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.bcel.util;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.Iterator;

import org.apache.bcel.AbstractTest;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.junit.jupiter.api.Test;

class InstructionFinderTest extends AbstractTest {

    @Test
    void testSearch() {
        final InstructionList il = new InstructionList();
        il.append(new ILOAD(1));
        il.append(new ILOAD(2));
        il.append(new IADD());
        il.append(new ISTORE(3));
        final InstructionFinder finder = new InstructionFinder(il);

        final Iterator<?> it = finder.search("ILOAD IADD", il.getInstructionHandles()[0], null);
        final InstructionHandle[] ihs = (InstructionHandle[]) it.next();
        assertEquals(2, ihs.length);
        assertEquals(ihs[0].getInstruction(), new ILOAD(2));
        assertEquals(ihs[1].getInstruction(), new IADD());
    }
}
