/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale;

import org.apache.commons.beanutils2.TestBean;
import org.apache.commons.beanutils2.locale.LocaleBeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocaleBeanUtilsTest {
    private static final Log LOG = LogFactory.getLog(LocaleBeanUtilsTest.class);

    @Test
    public void testSetNestedPropertyIndexed() throws Exception {
        TestBean bean = new TestBean();
        bean.getNested().setIntIndexed(1, 51);
        Assertions.assertEquals((int)51, (int)bean.getNested().getIntIndexed(1), (String)"Initial value[1] 51");
        LocaleBeanUtils.setProperty((Object)bean, (String)"nested.intIndexed[1]", (Object)"123", null);
        Assertions.assertEquals((int)123, (int)bean.getNested().getIntIndexed(1), (String)"Check Set Value");
    }

    @Test
    public void testSetNestedPropertySimple() throws Exception {
        TestBean bean = new TestBean();
        bean.getNested().setIntProperty(5);
        Assertions.assertEquals((int)5, (int)bean.getNested().getIntProperty(), (String)"Initial value 5");
        LocaleBeanUtils.setProperty((Object)bean, (String)"nested.intProperty", (Object)"123", null);
        Assertions.assertEquals((int)123, (int)bean.getNested().getIntProperty(), (String)"Check Set Value");
    }
}

