/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.documentation.options;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.WordUtils;
import org.apache.rat.OptionCollection;
import org.apache.rat.commandline.Arg;
import org.apache.rat.documentation.options.AbstractOption;
import org.apache.rat.utils.CasedString;

public class AntOption
extends AbstractOption {
    private static final Predicate<Option> ANT_FILTER;
    private static final List<Option> UNSUPPORTED_LIST;
    private static final Map<Option, Option> ANT_CONVERSION_MAP;
    private static final Map<OptionCollection.ArgumentType, BuildType> BUILD_TYPE_MAP;
    private static final List<Class<?>> ATTRIBUTE_TYPES;
    private static final Map<String, String> RENAME_MAP;
    private static final Map<String, Map<String, String>> REQUIRED_ATTRIBUTES;

    private static void updateConversionMap(Arg arg, Arg actualArg) {
        Option mapTo = actualArg.option();
        for (Option option : arg.group().getOptions()) {
            if (option.equals(mapTo) || option.isDeprecated()) continue;
            ANT_CONVERSION_MAP.put(option, mapTo);
        }
    }

    public static List<AntOption> getAntOptions() {
        return Arg.getOptions().getOptions().stream().filter(ANT_FILTER).map(AntOption::new).collect(Collectors.toList());
    }

    public static List<Option> getUnsupportedOptions() {
        return Collections.unmodifiableList(UNSUPPORTED_LIST);
    }

    public static Set<Option> getFilteredOptions() {
        HashSet<Option> filteredOptions = new HashSet<Option>(UNSUPPORTED_LIST);
        filteredOptions.addAll(ANT_CONVERSION_MAP.keySet());
        return filteredOptions;
    }

    public static Map<String, String> getRenameMap() {
        return Collections.unmodifiableMap(RENAME_MAP);
    }

    public AntOption(Option option) {
        super(option, AntOption.createName(option));
    }

    public static String createName(Option option) {
        String name = option.getLongOpt();
        name = StringUtils.defaultIfEmpty(RENAME_MAP.get(name), name).toLowerCase(Locale.ROOT);
        return new CasedString(CasedString.StringCase.KEBAB, name).toCase(CasedString.StringCase.CAMEL);
    }

    public boolean isAttribute() {
        return (!this.option.hasArg() || this.option.getArgs() == 1) && this.convertedFrom().isEmpty() && ATTRIBUTE_TYPES.contains(this.option.getType());
    }

    public boolean isElement() {
        return !this.isAttribute();
    }

    public AntOption getActualAntOption() {
        Option opt = ANT_CONVERSION_MAP.get(this.option);
        return opt == null ? this : new AntOption(opt);
    }

    public Set<Option> convertedFrom() {
        return ANT_CONVERSION_MAP.entrySet().stream().filter(e -> ((Option)e.getValue()).equals(this.option)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public String getText() {
        return this.cleanupName(this.option);
    }

    @Override
    protected String cleanupName(Option option) {
        AntOption antOption = new AntOption(option);
        String fmt = antOption.isAttribute() ? "%s attribute" : "<%s>";
        return String.format(fmt, AntOption.createName(option));
    }

    public String getComment(boolean addParam) {
        StringBuilder sb = new StringBuilder();
        String desc = this.getDescription();
        if (desc == null) {
            throw new IllegalStateException(String.format("Description for %s may not be null", this.getName()));
        }
        if (!desc.contains(".")) {
            throw new IllegalStateException(String.format("First sentence of description for %s must end with a '.'", this.getName()));
        }
        if (addParam) {
            String arg;
            if (this.option.hasArg()) {
                arg = desc.substring(desc.indexOf(" ") + 1, desc.indexOf(".") + 1);
                arg = WordUtils.capitalize(arg.substring(0, 1)) + arg.substring(1);
            } else {
                arg = "The state";
            }
            if (this.option.getArgName() != null) {
                Supplier<String> sup = OptionCollection.getArgumentTypes().get(this.option.getArgName());
                if (sup == null) {
                    throw new IllegalStateException(String.format("Argument type %s must be in OptionCollection.ARGUMENT_TYPES", this.option.getArgName()));
                }
                desc = String.format("%s Argument%s should be %s%s. (See Argument Types for clarification)", desc, this.option.hasArgs() ? "s" : "", this.option.hasArgs() ? "" : "a ", this.option.getArgName());
            }
            sb.append(String.format("    /**%n     * %s%n     * @param %s %s%n", StringEscapeUtils.escapeHtml4(desc), this.getName(), StringEscapeUtils.escapeHtml4(arg)));
        } else {
            sb.append(String.format("    /**%n     * %s%n", StringEscapeUtils.escapeHtml4(desc)));
        }
        if (this.option.isDeprecated()) {
            sb.append(String.format("     * @deprecated %s%n", StringEscapeUtils.escapeHtml4(this.getDeprecated())));
        }
        return sb.append(String.format("     */%n", new Object[0])).toString();
    }

    public String getAttributeFunctionName() {
        return "set" + WordUtils.capitalize(this.name) + (this.option.hasArg() ? "(String " : "(boolean ") + this.name + ")";
    }

    @Override
    public String getExample() {
        return new ExampleGenerator().getExample();
    }

    static {
        UNSUPPORTED_LIST = new ArrayList<Option>();
        ANT_CONVERSION_MAP = new HashMap<Option, Option>();
        BUILD_TYPE_MAP = new HashMap<OptionCollection.ArgumentType, BuildType>();
        ATTRIBUTE_TYPES = new ArrayList();
        RENAME_MAP = new HashMap<String, String>();
        REQUIRED_ATTRIBUTES = new HashMap<String, Map<String, String>>();
        RENAME_MAP.put("addLicense", "add-license");
        ATTRIBUTE_TYPES.add(String.class);
        ATTRIBUTE_TYPES.add(String[].class);
        ATTRIBUTE_TYPES.add(Integer.class);
        ATTRIBUTE_TYPES.add(Long.class);
        ATTRIBUTE_TYPES.add(File.class);
        Arg.getOptions().getOptions().stream().filter(o -> Objects.isNull(o.getLongOpt())).forEach(UNSUPPORTED_LIST::add);
        UNSUPPORTED_LIST.addAll(Arg.LOG_LEVEL.group().getOptions());
        UNSUPPORTED_LIST.addAll(Arg.DIR.group().getOptions());
        UNSUPPORTED_LIST.add(OptionCollection.HELP);
        UNSUPPORTED_LIST.addAll(Arg.SOURCE.group().getOptions());
        AntOption.updateConversionMap(Arg.LICENSES_APPROVED_FILE, Arg.LICENSES_APPROVED);
        AntOption.updateConversionMap(Arg.LICENSES_DENIED_FILE, Arg.LICENSES_DENIED);
        AntOption.updateConversionMap(Arg.FAMILIES_APPROVED_FILE, Arg.FAMILIES_APPROVED);
        AntOption.updateConversionMap(Arg.FAMILIES_DENIED_FILE, Arg.FAMILIES_DENIED);
        AntOption.updateConversionMap(Arg.INCLUDE_FILE, Arg.INCLUDE);
        AntOption.updateConversionMap(Arg.INCLUDE_STD, Arg.INCLUDE);
        AntOption.updateConversionMap(Arg.EXCLUDE_FILE, Arg.EXCLUDE);
        AntOption.updateConversionMap(Arg.EXCLUDE_STD, Arg.EXCLUDE);
        block8: for (OptionCollection.ArgumentType type : OptionCollection.ArgumentType.values()) {
            switch (type) {
                case FILE: 
                case DIRORARCHIVE: {
                    BuildType buildType = new BuildType(type, "filename"){

                        @Override
                        protected String getMultipleFormat(AntOption antOption) {
                            return "  <fileset file='%s' />\n";
                        }
                    };
                    BUILD_TYPE_MAP.put(type, buildType);
                    continue block8;
                }
                case NONE: {
                    BuildType buildType = new BuildType(type, "");
                    BUILD_TYPE_MAP.put(type, buildType);
                    continue block8;
                }
                case COUNTERPATTERN: {
                    BuildType buildType = new BuildType(type, "cntr");
                    BUILD_TYPE_MAP.put(type, buildType);
                    continue block8;
                }
                case EXPRESSION: {
                    BuildType buildType = new BuildType(type, "expr");
                    BUILD_TYPE_MAP.put(type, buildType);
                    continue block8;
                }
                case STANDARDCOLLECTION: {
                    BuildType buildType = new BuildType(type, "std");
                    BUILD_TYPE_MAP.put(type, buildType);
                    continue block8;
                }
                case LICENSEID: 
                case FAMILYID: {
                    BuildType buildType = new BuildType(type, "lst");
                    BUILD_TYPE_MAP.put(type, buildType);
                    continue block8;
                }
                default: {
                    BuildType buildType = new BuildType(type, type.getDisplayName()){

                        @Override
                        protected String getMethodFormat(AntOption antOption) {
                            return String.format("<%1$s>%%s</%1$s>\n", WordUtils.uncapitalize(antOption.getArgName()));
                        }
                    };
                    BUILD_TYPE_MAP.put(type, buildType);
                }
            }
        }
        Set<Option> filteredOptions = AntOption.getFilteredOptions();
        ANT_FILTER = option -> !filteredOptions.contains(option) && option.getLongOpt() != null;
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("editLicense", "true");
        REQUIRED_ATTRIBUTES.put("copyright", attributes);
        REQUIRED_ATTRIBUTES.put("editCopyright", attributes);
        REQUIRED_ATTRIBUTES.put("force", attributes);
        REQUIRED_ATTRIBUTES.put("editOverwrite", attributes);
    }

    public class ExampleGenerator {
        String getExample() {
            return this.getExample("data", (Map)REQUIRED_ATTRIBUTES.get(AntOption.this.getName()), null);
        }

        public String getExample(String data, Map<String, String> attributes, List<String> childElements) {
            if (UNSUPPORTED_LIST.contains(AntOption.this.option)) {
                return "-- not supported --";
            }
            return "<rat:report" + this.getExampleAttributes(data, attributes) + "> \n" + this.getChildElements(data, childElements) + "</rat:report>\n";
        }

        public String getExampleAttributes(String data, Map<String, String> attributes) {
            AntOption actualOption = AntOption.this.getActualAntOption();
            StringBuilder result = new StringBuilder();
            if (attributes != null) {
                attributes.forEach((k, v) -> result.append(String.format(" %s=\"%s\"", k, v)));
            }
            if (actualOption.isAttribute()) {
                result.append(String.format(" %s=\"%s\"", actualOption.getName(), actualOption.hasArg() ? data : "true"));
            }
            return result.toString();
        }

        public String getChildElements(String data, List<String> childElements) {
            AntOption baseOption = AntOption.this;
            AntOption actualOption = AntOption.this.getActualAntOption();
            StringBuilder result = new StringBuilder();
            if (!actualOption.isAttribute()) {
                String inner = ((BuildType)BUILD_TYPE_MAP.get((Object)AntOption.this.getArgType())).getPattern(actualOption, baseOption, data);
                result.append(inner);
            }
            if (childElements != null) {
                childElements.forEach(x -> result.append((String)x).append("\n"));
            }
            return result.toString();
        }
    }

    private static class BuildType {
        private final OptionCollection.ArgumentType type;
        private final String tag;

        BuildType(OptionCollection.ArgumentType type, String tag) {
            this.type = type;
            this.tag = tag;
        }

        protected String getMultipleFormat(AntOption antOption) {
            return String.format("<%1$s>%%s</%1$s>\n", this.tag);
        }

        protected String getMethodFormat(AntOption antOption) {
            return antOption.hasArgs() ? this.getMultipleFormat(antOption) : String.format("<%1$s>%%s</%1$s>\n", this.tag);
        }

        public String getPattern(AntOption delegateOption, AntOption antOption, String data) {
            String fmt = this.getMethodFormat(antOption);
            String value = data == null ? WordUtils.uncapitalize(antOption.getArgName()) : data;
            String inner = String.format(fmt, value);
            return String.format("<%1$s>%2$s</%1$s>%n", delegateOption.getName(), inner);
        }
    }
}

