/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.provider;

import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.ehcache.config.Configuration;
import org.ehcache.config.FluentConfigurationBuilder;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CoreServiceCreationConfigurationParser;

class SimpleCoreServiceCreationConfigurationParser<CONFIG, OUT, U extends ServiceCreationConfiguration<?, ?>>
implements CoreServiceCreationConfigurationParser<CONFIG> {
    private final Class<U> configType;
    private final Function<CONFIG, OUT> getter;
    private final BiConsumer<CONFIG, OUT> setter;
    private final Parser<OUT, U> parser;
    private final Function<U, OUT> unparser;
    private final BinaryOperator<OUT> merger;

    SimpleCoreServiceCreationConfigurationParser(Class<U> configType, Function<CONFIG, OUT> getter, BiConsumer<CONFIG, OUT> setter, Function<OUT, U> parser, Function<U, OUT> unparser) {
        this(configType, getter, setter, (config, loader) -> (ServiceCreationConfiguration)parser.apply(config), unparser, (a, b) -> {
            throw new IllegalStateException();
        });
    }

    SimpleCoreServiceCreationConfigurationParser(Class<U> configType, Function<CONFIG, OUT> getter, BiConsumer<CONFIG, OUT> setter, Parser<OUT, U> parser, Function<U, OUT> unparser) {
        this(configType, getter, setter, parser, unparser, (a, b) -> {
            throw new IllegalStateException();
        });
    }

    SimpleCoreServiceCreationConfigurationParser(Class<U> configType, Function<CONFIG, OUT> getter, BiConsumer<CONFIG, OUT> setter, Parser<OUT, U> parser, Function<U, OUT> unparser, BinaryOperator<OUT> merger) {
        this.configType = configType;
        this.getter = getter;
        this.setter = setter;
        this.parser = parser;
        this.unparser = unparser;
        this.merger = merger;
    }

    @Override
    public final FluentConfigurationBuilder<?> parseServiceCreationConfiguration(CONFIG root, ClassLoader classLoader, FluentConfigurationBuilder<?> builder) throws ClassNotFoundException {
        OUT config = this.getter.apply(root);
        if (config == null) {
            return builder;
        }
        return builder.withService((ServiceCreationConfiguration<?, ?>)this.parser.parse(config, classLoader));
    }

    @Override
    public CONFIG unparseServiceCreationConfiguration(Configuration configuration, CONFIG configType) {
        ServiceCreationConfiguration config = (ServiceCreationConfiguration)ServiceUtils.findSingletonAmongst(this.configType, configuration.getServiceCreationConfigurations());
        if (config == null) {
            return configType;
        }
        OUT foo = this.getter.apply(configType);
        if (foo == null) {
            this.setter.accept(configType, this.unparser.apply(config));
        } else {
            this.setter.accept(configType, this.merger.apply(foo, this.unparser.apply(config)));
        }
        return configType;
    }

    @FunctionalInterface
    static interface Parser<T, U extends ServiceCreationConfiguration<?, ?>> {
        public U parse(T var1, ClassLoader var2) throws ClassNotFoundException;
    }
}

