/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import io.netty.buffer.ByteBuf;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacketI;

public class ReplicationPageWriteMessage
extends PacketImpl
implements MessagePacketI {
    protected long pageNumber;
    protected PagedMessage pagedMessage;
    protected SimpleString address;
    final boolean useLong;
    final CoreMessageObjectPools coreMessageObjectPools;

    public ReplicationPageWriteMessage(boolean useLong, CoreMessageObjectPools coreMessageObjectPools) {
        super((byte)97);
        this.useLong = useLong;
        this.coreMessageObjectPools = coreMessageObjectPools;
    }

    public ReplicationPageWriteMessage(PagedMessage pagedMessage, long pageNumber, boolean useLong, SimpleString address) {
        this(useLong, null);
        this.pageNumber = pageNumber;
        this.pagedMessage = pagedMessage;
        this.address = address;
    }

    public int expectedEncodeSize() {
        if (this.useLong) {
            return 21 + this.pagedMessage.getEncodeSize() + SimpleString.sizeofString((SimpleString)this.address);
        }
        return 17 + this.pagedMessage.getEncodeSize();
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        if (this.useLong) {
            buffer.writeLong(this.pageNumber);
        } else {
            if (this.pageNumber > Integer.MAX_VALUE) {
                throw new IllegalStateException("pageNumber=" + this.pageNumber + " is too large to be used with older broker version on replication");
            }
            buffer.writeInt((int)this.pageNumber);
        }
        this.pagedMessage.encode(buffer);
        if (this.useLong) {
            buffer.writeNullableSimpleString(this.address);
        }
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.pageNumber = this.useLong ? buffer.readLong() : (long)buffer.readInt();
        this.pagedMessage = new PagedMessageImpl(0, null);
        this.pagedMessage.decode(buffer);
        if (buffer.readableBytes() > 0) {
            this.address = SimpleString.readNullableSimpleString((ByteBuf)buffer.byteBuf(), (SimpleString.ByteBufSimpleStringPool)this.coreMessageObjectPools.getAddressDecoderPool());
        }
    }

    public SimpleString getAddress() {
        if (this.address != null) {
            return this.address;
        }
        return this.pagedMessage.getMessage().getAddressSimpleString();
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public PagedMessage getPagedMessage() {
        return this.pagedMessage;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)this.pageNumber;
        result = 31 * result + (this.pagedMessage == null ? 0 : this.pagedMessage.hashCode());
        return result;
    }

    public Message getMessage() {
        return this.pagedMessage.getMessage();
    }

    public ReplicationPageWriteMessage replaceMessage(Message message) {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReplicationPageWriteMessage other = (ReplicationPageWriteMessage)((Object)obj);
        if (this.pageNumber != other.pageNumber) {
            return false;
        }
        return !(this.pagedMessage == null ? other.pagedMessage != null : !this.pagedMessage.equals(other.pagedMessage));
    }
}

