// Code generated by forygen. DO NOT EDIT.
// source: structs.go
// generated at: 2026-01-26T23:14:39+08:00

package fory

import (
	"github.com/apache/fory/go/fory"
	"reflect"
)

func init() {
	fory.RegisterSerializerFactory((*DynamicSliceDemo)(nil), NewSerializerFor_DynamicSliceDemo)
	fory.RegisterSerializerFactory((*MapDemo)(nil), NewSerializerFor_MapDemo)
	fory.RegisterSerializerFactory((*SliceDemo)(nil), NewSerializerFor_SliceDemo)
	fory.RegisterSerializerFactory((*ValidationDemo)(nil), NewSerializerFor_ValidationDemo)
}

type DynamicSliceDemo_ForyGenSerializer struct {
	structHash int32
}

func NewSerializerFor_DynamicSliceDemo() fory.Serializer {
	return &DynamicSliceDemo_ForyGenSerializer{}
}

func (g *DynamicSliceDemo_ForyGenSerializer) initHash(resolver *fory.TypeResolver) {
	if g.structHash == 0 {
		g.structHash = fory.GetStructHash(reflect.TypeOf(DynamicSliceDemo{}), resolver)
	}
}

// Write is the entry point for serialization with ref/type handling
func (g *DynamicSliceDemo_ForyGenSerializer) Write(ctx *fory.WriteContext, refMode fory.RefMode, writeType bool, hasGenerics bool, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	_ = hasGenerics // not used for struct serializers
	switch refMode {
	case fory.RefModeTracking:
		if !value.IsValid() || (value.Kind() == reflect.Ptr && value.IsNil()) {
			ctx.Buffer().WriteInt8(-3) // NullFlag
			return
		}
		refWritten, err := ctx.RefResolver().WriteRefOrNull(ctx.Buffer(), value)
		if err != nil {
			ctx.SetError(fory.FromError(err))
			return
		}
		if refWritten {
			return
		}
	case fory.RefModeNullOnly:
		if !value.IsValid() || (value.Kind() == reflect.Ptr && value.IsNil()) {
			ctx.Buffer().WriteInt8(-3) // NullFlag
			return
		}
		ctx.Buffer().WriteInt8(-1) // NotNullValueFlag
	}
	if writeType {
		ctx.Buffer().WriteVarUint32(uint32(fory.NAMED_STRUCT))
	}
	g.WriteData(ctx, value)
}

// WriteTyped provides strongly-typed serialization with no reflection overhead
func (g *DynamicSliceDemo_ForyGenSerializer) WriteTyped(ctx *fory.WriteContext, v *DynamicSliceDemo) error {
	buf := ctx.Buffer()
	// WriteData struct hash for compatibility checking
	buf.WriteInt32(g.structHash)

	// WriteData fields in sorted order
	// Field: DynamicSlice ([]any)
	// Dynamic slice []any handling - manual serialization
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, write directly without null flag
			sliceLen := 0
			if v.DynamicSlice != nil {
				sliceLen = len(v.DynamicSlice)
			}
			buf.WriteVarUint32(uint32(sliceLen))
			if sliceLen > 0 {
				// WriteData collection flags for dynamic slice []any
				// Only CollectionTrackingRef is set (no declared type, may have different types)
				buf.WriteInt8(1) // CollectionTrackingRef only
				// WriteData each element using WriteValue
				for _, elem := range v.DynamicSlice {
					ctx.WriteValue(reflect.ValueOf(elem), fory.RefModeTracking, true)
				}
			}
		} else {
			// Native Go mode: slices are nullable, write null flag
			if v.DynamicSlice == nil {
				buf.WriteInt8(-3) // NullFlag
			} else {
				buf.WriteInt8(-1) // NotNullValueFlag
				sliceLen := len(v.DynamicSlice)
				buf.WriteVarUint32(uint32(sliceLen))
				if sliceLen > 0 {
					// WriteData collection flags for dynamic slice []any
					// Only CollectionTrackingRef is set (no declared type, may have different types)
					buf.WriteInt8(1) // CollectionTrackingRef only
					// WriteData each element using WriteValue
					for _, elem := range v.DynamicSlice {
						ctx.WriteValue(reflect.ValueOf(elem), fory.RefModeTracking, true)
					}
				}
			}
		}
	}
	return nil
}

// WriteData provides reflect.Value interface compatibility (implements fory.Serializer)
func (g *DynamicSliceDemo_ForyGenSerializer) WriteData(ctx *fory.WriteContext, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	// Convert reflect.Value to concrete type and delegate to typed method
	var v *DynamicSliceDemo
	if value.Kind() == reflect.Ptr {
		v = value.Interface().(*DynamicSliceDemo)
	} else {
		// Create a copy to get a pointer
		temp := value.Interface().(DynamicSliceDemo)
		v = &temp
	}
	// Delegate to strongly-typed method for maximum performance
	if err := g.WriteTyped(ctx, v); err != nil {
		ctx.SetError(fory.FromError(err))
	}
}

// Read is the entry point for deserialization with ref/type handling
func (g *DynamicSliceDemo_ForyGenSerializer) Read(ctx *fory.ReadContext, refMode fory.RefMode, readType bool, hasGenerics bool, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	_ = hasGenerics  // not used for struct serializers
	err := ctx.Err() // Get error pointer for deferred error checking
	switch refMode {
	case fory.RefModeTracking:
		refID, refErr := ctx.RefResolver().TryPreserveRefId(ctx.Buffer())
		if refErr != nil {
			ctx.SetError(fory.FromError(refErr))
			return
		}
		if int8(refID) < -1 { // NotNullValueFlag
			obj := ctx.RefResolver().GetReadObject(refID)
			if obj.IsValid() {
				value.Set(obj)
			}
			return
		}
	case fory.RefModeNullOnly:
		flag := ctx.Buffer().ReadInt8(err)
		if flag == -3 { // NullFlag
			return
		}
	}
	if readType {
		ctx.TypeResolver().ReadTypeInfo(ctx.Buffer(), err)
	}
	g.ReadData(ctx, value)
}

// ReadTyped provides strongly-typed deserialization with no reflection overhead
func (g *DynamicSliceDemo_ForyGenSerializer) ReadTyped(ctx *fory.ReadContext, v *DynamicSliceDemo) error {
	buf := ctx.Buffer()
	err := ctx.Err() // Get error pointer for deferred error checking

	// ReadData and verify struct hash
	if got := buf.ReadInt32(err); got != g.structHash {
		if ctx.HasError() {
			return ctx.TakeError()
		}
		return fory.HashMismatchError(got, g.structHash, "DynamicSliceDemo")
	}

	// ReadData fields in same order as write
	// Field: DynamicSlice ([]any)
	// Dynamic slice []any handling - manual deserialization
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, read directly without null flag
			sliceLen := int(buf.ReadVarUint32(err))
			if sliceLen == 0 {
				v.DynamicSlice = make([]any, 0)
			} else {
				// ReadData collection flags (ignore for now)
				_ = buf.ReadInt8(err)
				// Create slice with proper capacity
				v.DynamicSlice = make([]any, sliceLen)
				// ReadData each element using ReadValue
				for i := range v.DynamicSlice {
					ctx.ReadValue(reflect.ValueOf(&v.DynamicSlice[i]).Elem(), fory.RefModeTracking, true)
				}
			}
		} else {
			// Native Go mode: slices are nullable, read null flag
			nullFlag := buf.ReadInt8(err)
			if nullFlag == -3 {
				v.DynamicSlice = nil
			} else {
				sliceLen := int(buf.ReadVarUint32(err))
				if sliceLen == 0 {
					v.DynamicSlice = make([]any, 0)
				} else {
					// ReadData collection flags (ignore for now)
					_ = buf.ReadInt8(err)
					// Create slice with proper capacity
					v.DynamicSlice = make([]any, sliceLen)
					// ReadData each element using ReadValue
					for i := range v.DynamicSlice {
						ctx.ReadValue(reflect.ValueOf(&v.DynamicSlice[i]).Elem(), fory.RefModeTracking, true)
					}
				}
			}
		}
	}

	// Final deferred error check
	if ctx.HasError() {
		return ctx.TakeError()
	}
	return nil
}

// ReadData provides reflect.Value interface compatibility (implements fory.Serializer)
func (g *DynamicSliceDemo_ForyGenSerializer) ReadData(ctx *fory.ReadContext, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	// Convert reflect.Value to concrete type and delegate to typed method
	var v *DynamicSliceDemo
	if value.Kind() == reflect.Ptr {
		if value.IsNil() {
			// For pointer types, allocate using value.Type().Elem()
			value.Set(reflect.New(value.Type().Elem()))
		}
		v = value.Interface().(*DynamicSliceDemo)
	} else {
		// value must be addressable for read
		v = value.Addr().Interface().(*DynamicSliceDemo)
	}
	// Delegate to strongly-typed method for maximum performance
	if err := g.ReadTyped(ctx, v); err != nil {
		ctx.SetError(fory.FromError(err))
	}
}

// ReadWithTypeInfo deserializes with pre-read type information
func (g *DynamicSliceDemo_ForyGenSerializer) ReadWithTypeInfo(ctx *fory.ReadContext, refMode fory.RefMode, typeInfo *fory.TypeInfo, value reflect.Value) {
	g.Read(ctx, refMode, false, false, value)
}

type MapDemo_ForyGenSerializer struct {
	structHash int32
}

func NewSerializerFor_MapDemo() fory.Serializer {
	return &MapDemo_ForyGenSerializer{}
}

func (g *MapDemo_ForyGenSerializer) initHash(resolver *fory.TypeResolver) {
	if g.structHash == 0 {
		g.structHash = fory.GetStructHash(reflect.TypeOf(MapDemo{}), resolver)
	}
}

// Write is the entry point for serialization with ref/type handling
func (g *MapDemo_ForyGenSerializer) Write(ctx *fory.WriteContext, refMode fory.RefMode, writeType bool, hasGenerics bool, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	_ = hasGenerics // not used for struct serializers
	switch refMode {
	case fory.RefModeTracking:
		if !value.IsValid() || (value.Kind() == reflect.Ptr && value.IsNil()) {
			ctx.Buffer().WriteInt8(-3) // NullFlag
			return
		}
		refWritten, err := ctx.RefResolver().WriteRefOrNull(ctx.Buffer(), value)
		if err != nil {
			ctx.SetError(fory.FromError(err))
			return
		}
		if refWritten {
			return
		}
	case fory.RefModeNullOnly:
		if !value.IsValid() || (value.Kind() == reflect.Ptr && value.IsNil()) {
			ctx.Buffer().WriteInt8(-3) // NullFlag
			return
		}
		ctx.Buffer().WriteInt8(-1) // NotNullValueFlag
	}
	if writeType {
		ctx.Buffer().WriteVarUint32(uint32(fory.NAMED_STRUCT))
	}
	g.WriteData(ctx, value)
}

// WriteTyped provides strongly-typed serialization with no reflection overhead
func (g *MapDemo_ForyGenSerializer) WriteTyped(ctx *fory.WriteContext, v *MapDemo) error {
	buf := ctx.Buffer()
	// WriteData struct hash for compatibility checking
	buf.WriteInt32(g.structHash)

	// WriteData fields in sorted order
	// Field: IntMap (map[int]int)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: maps are not nullable, write directly without null flag
			mapLen := 0
			if v.IntMap != nil {
				mapLen = len(v.IntMap)
			}
			buf.WriteVarUint32(uint32(mapLen))
			if mapLen > 0 {
				// Calculate KV header flags
				kvHeader := uint8(0)
				isRefTracking := ctx.TrackRef()
				_ = isRefTracking // Mark as used to avoid warning
				chunkSize := 0
				_ = buf.WriterIndex()         // chunkHeaderOffset
				buf.WriteInt8(int8(kvHeader)) // KV header
				chunkSizeOffset := buf.WriterIndex()
				buf.WriteInt8(0) // placeholder for chunk size
				for mapKey, mapValue := range v.IntMap {
					buf.WriteInt64(int64(mapKey))
					buf.WriteInt64(int64(mapValue))
					chunkSize++
					if chunkSize >= 255 {
						// WriteData chunk size and start new chunk
						buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
						if len(v.IntMap) > chunkSize {
							chunkSize = 0
							_ = buf.WriterIndex()         // chunkHeaderOffset
							buf.WriteInt8(int8(kvHeader)) // KV header
							chunkSizeOffset = buf.WriterIndex()
							buf.WriteInt8(0) // placeholder for chunk size
						}
					}
				}
				if chunkSize > 0 {
					buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
				}
			}
		} else {
			// Native Go mode: maps are nullable, write null flag
			if v.IntMap == nil {
				buf.WriteInt8(-3) // NullFlag
			} else {
				buf.WriteInt8(-1) // NotNullValueFlag
				mapLen := len(v.IntMap)
				buf.WriteVarUint32(uint32(mapLen))
				if mapLen > 0 {
					// Calculate KV header flags
					kvHeader := uint8(0)
					isRefTracking := ctx.TrackRef()
					_ = isRefTracking // Mark as used to avoid warning
					chunkSize := 0
					_ = buf.WriterIndex()         // chunkHeaderOffset
					buf.WriteInt8(int8(kvHeader)) // KV header
					chunkSizeOffset := buf.WriterIndex()
					buf.WriteInt8(0) // placeholder for chunk size
					for mapKey, mapValue := range v.IntMap {
						buf.WriteInt64(int64(mapKey))
						buf.WriteInt64(int64(mapValue))
						chunkSize++
						if chunkSize >= 255 {
							// WriteData chunk size and start new chunk
							buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
							if len(v.IntMap) > chunkSize {
								chunkSize = 0
								_ = buf.WriterIndex()         // chunkHeaderOffset
								buf.WriteInt8(int8(kvHeader)) // KV header
								chunkSizeOffset = buf.WriterIndex()
								buf.WriteInt8(0) // placeholder for chunk size
							}
						}
					}
					if chunkSize > 0 {
						buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
					}
				}
			}
		}
	}
	// Field: MixedMap (map[string]int)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: maps are not nullable, write directly without null flag
			mapLen := 0
			if v.MixedMap != nil {
				mapLen = len(v.MixedMap)
			}
			buf.WriteVarUint32(uint32(mapLen))
			if mapLen > 0 {
				// Calculate KV header flags
				kvHeader := uint8(0)
				isRefTracking := ctx.TrackRef()
				_ = isRefTracking // Mark as used to avoid warning
				if isRefTracking {
					kvHeader |= 0x1 // track key ref
				}
				chunkSize := 0
				_ = buf.WriterIndex()         // chunkHeaderOffset
				buf.WriteInt8(int8(kvHeader)) // KV header
				chunkSizeOffset := buf.WriterIndex()
				buf.WriteInt8(0) // placeholder for chunk size
				for mapKey, mapValue := range v.MixedMap {
					ctx.WriteString(mapKey)
					buf.WriteInt64(int64(mapValue))
					chunkSize++
					if chunkSize >= 255 {
						// WriteData chunk size and start new chunk
						buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
						if len(v.MixedMap) > chunkSize {
							chunkSize = 0
							_ = buf.WriterIndex()         // chunkHeaderOffset
							buf.WriteInt8(int8(kvHeader)) // KV header
							chunkSizeOffset = buf.WriterIndex()
							buf.WriteInt8(0) // placeholder for chunk size
						}
					}
				}
				if chunkSize > 0 {
					buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
				}
			}
		} else {
			// Native Go mode: maps are nullable, write null flag
			if v.MixedMap == nil {
				buf.WriteInt8(-3) // NullFlag
			} else {
				buf.WriteInt8(-1) // NotNullValueFlag
				mapLen := len(v.MixedMap)
				buf.WriteVarUint32(uint32(mapLen))
				if mapLen > 0 {
					// Calculate KV header flags
					kvHeader := uint8(0)
					isRefTracking := ctx.TrackRef()
					_ = isRefTracking // Mark as used to avoid warning
					if isRefTracking {
						kvHeader |= 0x1 // track key ref
					}
					chunkSize := 0
					_ = buf.WriterIndex()         // chunkHeaderOffset
					buf.WriteInt8(int8(kvHeader)) // KV header
					chunkSizeOffset := buf.WriterIndex()
					buf.WriteInt8(0) // placeholder for chunk size
					for mapKey, mapValue := range v.MixedMap {
						ctx.WriteString(mapKey)
						buf.WriteInt64(int64(mapValue))
						chunkSize++
						if chunkSize >= 255 {
							// WriteData chunk size and start new chunk
							buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
							if len(v.MixedMap) > chunkSize {
								chunkSize = 0
								_ = buf.WriterIndex()         // chunkHeaderOffset
								buf.WriteInt8(int8(kvHeader)) // KV header
								chunkSizeOffset = buf.WriterIndex()
								buf.WriteInt8(0) // placeholder for chunk size
							}
						}
					}
					if chunkSize > 0 {
						buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
					}
				}
			}
		}
	}
	// Field: StringMap (map[string]string)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: maps are not nullable, write directly without null flag
			mapLen := 0
			if v.StringMap != nil {
				mapLen = len(v.StringMap)
			}
			buf.WriteVarUint32(uint32(mapLen))
			if mapLen > 0 {
				// Calculate KV header flags
				kvHeader := uint8(0)
				isRefTracking := ctx.TrackRef()
				_ = isRefTracking // Mark as used to avoid warning
				if isRefTracking {
					kvHeader |= 0x1 // track key ref
				}
				if isRefTracking {
					kvHeader |= 0x8 // track value ref
				}
				chunkSize := 0
				_ = buf.WriterIndex()         // chunkHeaderOffset
				buf.WriteInt8(int8(kvHeader)) // KV header
				chunkSizeOffset := buf.WriterIndex()
				buf.WriteInt8(0) // placeholder for chunk size
				for mapKey, mapValue := range v.StringMap {
					ctx.WriteString(mapKey)
					ctx.WriteString(mapValue)
					chunkSize++
					if chunkSize >= 255 {
						// WriteData chunk size and start new chunk
						buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
						if len(v.StringMap) > chunkSize {
							chunkSize = 0
							_ = buf.WriterIndex()         // chunkHeaderOffset
							buf.WriteInt8(int8(kvHeader)) // KV header
							chunkSizeOffset = buf.WriterIndex()
							buf.WriteInt8(0) // placeholder for chunk size
						}
					}
				}
				if chunkSize > 0 {
					buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
				}
			}
		} else {
			// Native Go mode: maps are nullable, write null flag
			if v.StringMap == nil {
				buf.WriteInt8(-3) // NullFlag
			} else {
				buf.WriteInt8(-1) // NotNullValueFlag
				mapLen := len(v.StringMap)
				buf.WriteVarUint32(uint32(mapLen))
				if mapLen > 0 {
					// Calculate KV header flags
					kvHeader := uint8(0)
					isRefTracking := ctx.TrackRef()
					_ = isRefTracking // Mark as used to avoid warning
					if isRefTracking {
						kvHeader |= 0x1 // track key ref
					}
					if isRefTracking {
						kvHeader |= 0x8 // track value ref
					}
					chunkSize := 0
					_ = buf.WriterIndex()         // chunkHeaderOffset
					buf.WriteInt8(int8(kvHeader)) // KV header
					chunkSizeOffset := buf.WriterIndex()
					buf.WriteInt8(0) // placeholder for chunk size
					for mapKey, mapValue := range v.StringMap {
						ctx.WriteString(mapKey)
						ctx.WriteString(mapValue)
						chunkSize++
						if chunkSize >= 255 {
							// WriteData chunk size and start new chunk
							buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
							if len(v.StringMap) > chunkSize {
								chunkSize = 0
								_ = buf.WriterIndex()         // chunkHeaderOffset
								buf.WriteInt8(int8(kvHeader)) // KV header
								chunkSizeOffset = buf.WriterIndex()
								buf.WriteInt8(0) // placeholder for chunk size
							}
						}
					}
					if chunkSize > 0 {
						buf.PutUint8(chunkSizeOffset, uint8(chunkSize))
					}
				}
			}
		}
	}
	return nil
}

// WriteData provides reflect.Value interface compatibility (implements fory.Serializer)
func (g *MapDemo_ForyGenSerializer) WriteData(ctx *fory.WriteContext, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	// Convert reflect.Value to concrete type and delegate to typed method
	var v *MapDemo
	if value.Kind() == reflect.Ptr {
		v = value.Interface().(*MapDemo)
	} else {
		// Create a copy to get a pointer
		temp := value.Interface().(MapDemo)
		v = &temp
	}
	// Delegate to strongly-typed method for maximum performance
	if err := g.WriteTyped(ctx, v); err != nil {
		ctx.SetError(fory.FromError(err))
	}
}

// Read is the entry point for deserialization with ref/type handling
func (g *MapDemo_ForyGenSerializer) Read(ctx *fory.ReadContext, refMode fory.RefMode, readType bool, hasGenerics bool, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	_ = hasGenerics  // not used for struct serializers
	err := ctx.Err() // Get error pointer for deferred error checking
	switch refMode {
	case fory.RefModeTracking:
		refID, refErr := ctx.RefResolver().TryPreserveRefId(ctx.Buffer())
		if refErr != nil {
			ctx.SetError(fory.FromError(refErr))
			return
		}
		if int8(refID) < -1 { // NotNullValueFlag
			obj := ctx.RefResolver().GetReadObject(refID)
			if obj.IsValid() {
				value.Set(obj)
			}
			return
		}
	case fory.RefModeNullOnly:
		flag := ctx.Buffer().ReadInt8(err)
		if flag == -3 { // NullFlag
			return
		}
	}
	if readType {
		ctx.TypeResolver().ReadTypeInfo(ctx.Buffer(), err)
	}
	g.ReadData(ctx, value)
}

// ReadTyped provides strongly-typed deserialization with no reflection overhead
func (g *MapDemo_ForyGenSerializer) ReadTyped(ctx *fory.ReadContext, v *MapDemo) error {
	buf := ctx.Buffer()
	err := ctx.Err() // Get error pointer for deferred error checking

	// ReadData and verify struct hash
	if got := buf.ReadInt32(err); got != g.structHash {
		if ctx.HasError() {
			return ctx.TakeError()
		}
		return fory.HashMismatchError(got, g.structHash, "MapDemo")
	}

	// ReadData fields in same order as write
	// Field: IntMap (map[int]int)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: maps are not nullable, read directly without null flag
			mapLen := int(buf.ReadVarUint32(err))
			if mapLen == 0 {
				v.IntMap = make(map[int]int)
			} else {
				v.IntMap = make(map[int]int, mapLen)
				mapSize := mapLen
				for mapSize > 0 {
					// ReadData KV header
					kvHeader := buf.ReadByte(err)
					chunkSize := int(buf.ReadByte(err))
					trackKeyRef := (kvHeader & 0x1) != 0
					keyNotDeclared := (kvHeader & 0x4) != 0
					trackValueRef := (kvHeader & 0x8) != 0
					valueNotDeclared := (kvHeader & 0x20) != 0
					_ = trackKeyRef
					_ = keyNotDeclared
					_ = trackValueRef
					_ = valueNotDeclared
					for i := 0; i < chunkSize; i++ {
						var mapKey int
						mapKey = int(buf.ReadInt64(err))
						var mapValue int
						mapValue = int(buf.ReadInt64(err))
						v.IntMap[mapKey] = mapValue
					}
					mapSize -= chunkSize
				}
			}
		} else {
			// Native Go mode: maps are nullable, read null flag
			nullFlag := buf.ReadInt8(err)
			if nullFlag == -3 {
				v.IntMap = nil
			} else {
				mapLen := int(buf.ReadVarUint32(err))
				if mapLen == 0 {
					v.IntMap = make(map[int]int)
				} else {
					v.IntMap = make(map[int]int, mapLen)
					mapSize := mapLen
					for mapSize > 0 {
						// ReadData KV header
						kvHeader := buf.ReadByte(err)
						chunkSize := int(buf.ReadByte(err))
						trackKeyRef := (kvHeader & 0x1) != 0
						keyNotDeclared := (kvHeader & 0x4) != 0
						trackValueRef := (kvHeader & 0x8) != 0
						valueNotDeclared := (kvHeader & 0x20) != 0
						_ = trackKeyRef
						_ = keyNotDeclared
						_ = trackValueRef
						_ = valueNotDeclared
						for i := 0; i < chunkSize; i++ {
							var mapKey int
							mapKey = int(buf.ReadInt64(err))
							var mapValue int
							mapValue = int(buf.ReadInt64(err))
							v.IntMap[mapKey] = mapValue
						}
						mapSize -= chunkSize
					}
				}
			}
		}
	}
	// Field: MixedMap (map[string]int)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: maps are not nullable, read directly without null flag
			mapLen := int(buf.ReadVarUint32(err))
			if mapLen == 0 {
				v.MixedMap = make(map[string]int)
			} else {
				v.MixedMap = make(map[string]int, mapLen)
				mapSize := mapLen
				for mapSize > 0 {
					// ReadData KV header
					kvHeader := buf.ReadByte(err)
					chunkSize := int(buf.ReadByte(err))
					trackKeyRef := (kvHeader & 0x1) != 0
					keyNotDeclared := (kvHeader & 0x4) != 0
					trackValueRef := (kvHeader & 0x8) != 0
					valueNotDeclared := (kvHeader & 0x20) != 0
					_ = trackKeyRef
					_ = keyNotDeclared
					_ = trackValueRef
					_ = valueNotDeclared
					for i := 0; i < chunkSize; i++ {
						var mapKey string
						mapKey = ctx.ReadString()
						var mapValue int
						mapValue = int(buf.ReadInt64(err))
						v.MixedMap[mapKey] = mapValue
					}
					mapSize -= chunkSize
				}
			}
		} else {
			// Native Go mode: maps are nullable, read null flag
			nullFlag := buf.ReadInt8(err)
			if nullFlag == -3 {
				v.MixedMap = nil
			} else {
				mapLen := int(buf.ReadVarUint32(err))
				if mapLen == 0 {
					v.MixedMap = make(map[string]int)
				} else {
					v.MixedMap = make(map[string]int, mapLen)
					mapSize := mapLen
					for mapSize > 0 {
						// ReadData KV header
						kvHeader := buf.ReadByte(err)
						chunkSize := int(buf.ReadByte(err))
						trackKeyRef := (kvHeader & 0x1) != 0
						keyNotDeclared := (kvHeader & 0x4) != 0
						trackValueRef := (kvHeader & 0x8) != 0
						valueNotDeclared := (kvHeader & 0x20) != 0
						_ = trackKeyRef
						_ = keyNotDeclared
						_ = trackValueRef
						_ = valueNotDeclared
						for i := 0; i < chunkSize; i++ {
							var mapKey string
							mapKey = ctx.ReadString()
							var mapValue int
							mapValue = int(buf.ReadInt64(err))
							v.MixedMap[mapKey] = mapValue
						}
						mapSize -= chunkSize
					}
				}
			}
		}
	}
	// Field: StringMap (map[string]string)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: maps are not nullable, read directly without null flag
			mapLen := int(buf.ReadVarUint32(err))
			if mapLen == 0 {
				v.StringMap = make(map[string]string)
			} else {
				v.StringMap = make(map[string]string, mapLen)
				mapSize := mapLen
				for mapSize > 0 {
					// ReadData KV header
					kvHeader := buf.ReadByte(err)
					chunkSize := int(buf.ReadByte(err))
					trackKeyRef := (kvHeader & 0x1) != 0
					keyNotDeclared := (kvHeader & 0x4) != 0
					trackValueRef := (kvHeader & 0x8) != 0
					valueNotDeclared := (kvHeader & 0x20) != 0
					_ = trackKeyRef
					_ = keyNotDeclared
					_ = trackValueRef
					_ = valueNotDeclared
					for i := 0; i < chunkSize; i++ {
						var mapKey string
						mapKey = ctx.ReadString()
						var mapValue string
						mapValue = ctx.ReadString()
						v.StringMap[mapKey] = mapValue
					}
					mapSize -= chunkSize
				}
			}
		} else {
			// Native Go mode: maps are nullable, read null flag
			nullFlag := buf.ReadInt8(err)
			if nullFlag == -3 {
				v.StringMap = nil
			} else {
				mapLen := int(buf.ReadVarUint32(err))
				if mapLen == 0 {
					v.StringMap = make(map[string]string)
				} else {
					v.StringMap = make(map[string]string, mapLen)
					mapSize := mapLen
					for mapSize > 0 {
						// ReadData KV header
						kvHeader := buf.ReadByte(err)
						chunkSize := int(buf.ReadByte(err))
						trackKeyRef := (kvHeader & 0x1) != 0
						keyNotDeclared := (kvHeader & 0x4) != 0
						trackValueRef := (kvHeader & 0x8) != 0
						valueNotDeclared := (kvHeader & 0x20) != 0
						_ = trackKeyRef
						_ = keyNotDeclared
						_ = trackValueRef
						_ = valueNotDeclared
						for i := 0; i < chunkSize; i++ {
							var mapKey string
							mapKey = ctx.ReadString()
							var mapValue string
							mapValue = ctx.ReadString()
							v.StringMap[mapKey] = mapValue
						}
						mapSize -= chunkSize
					}
				}
			}
		}
	}

	// Final deferred error check
	if ctx.HasError() {
		return ctx.TakeError()
	}
	return nil
}

// ReadData provides reflect.Value interface compatibility (implements fory.Serializer)
func (g *MapDemo_ForyGenSerializer) ReadData(ctx *fory.ReadContext, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	// Convert reflect.Value to concrete type and delegate to typed method
	var v *MapDemo
	if value.Kind() == reflect.Ptr {
		if value.IsNil() {
			// For pointer types, allocate using value.Type().Elem()
			value.Set(reflect.New(value.Type().Elem()))
		}
		v = value.Interface().(*MapDemo)
	} else {
		// value must be addressable for read
		v = value.Addr().Interface().(*MapDemo)
	}
	// Delegate to strongly-typed method for maximum performance
	if err := g.ReadTyped(ctx, v); err != nil {
		ctx.SetError(fory.FromError(err))
	}
}

// ReadWithTypeInfo deserializes with pre-read type information
func (g *MapDemo_ForyGenSerializer) ReadWithTypeInfo(ctx *fory.ReadContext, refMode fory.RefMode, typeInfo *fory.TypeInfo, value reflect.Value) {
	g.Read(ctx, refMode, false, false, value)
}

type SliceDemo_ForyGenSerializer struct {
	structHash int32
}

func NewSerializerFor_SliceDemo() fory.Serializer {
	return &SliceDemo_ForyGenSerializer{}
}

func (g *SliceDemo_ForyGenSerializer) initHash(resolver *fory.TypeResolver) {
	if g.structHash == 0 {
		g.structHash = fory.GetStructHash(reflect.TypeOf(SliceDemo{}), resolver)
	}
}

// Write is the entry point for serialization with ref/type handling
func (g *SliceDemo_ForyGenSerializer) Write(ctx *fory.WriteContext, refMode fory.RefMode, writeType bool, hasGenerics bool, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	_ = hasGenerics // not used for struct serializers
	switch refMode {
	case fory.RefModeTracking:
		if !value.IsValid() || (value.Kind() == reflect.Ptr && value.IsNil()) {
			ctx.Buffer().WriteInt8(-3) // NullFlag
			return
		}
		refWritten, err := ctx.RefResolver().WriteRefOrNull(ctx.Buffer(), value)
		if err != nil {
			ctx.SetError(fory.FromError(err))
			return
		}
		if refWritten {
			return
		}
	case fory.RefModeNullOnly:
		if !value.IsValid() || (value.Kind() == reflect.Ptr && value.IsNil()) {
			ctx.Buffer().WriteInt8(-3) // NullFlag
			return
		}
		ctx.Buffer().WriteInt8(-1) // NotNullValueFlag
	}
	if writeType {
		ctx.Buffer().WriteVarUint32(uint32(fory.NAMED_STRUCT))
	}
	g.WriteData(ctx, value)
}

// WriteTyped provides strongly-typed serialization with no reflection overhead
func (g *SliceDemo_ForyGenSerializer) WriteTyped(ctx *fory.WriteContext, v *SliceDemo) error {
	buf := ctx.Buffer()
	// WriteData struct hash for compatibility checking
	buf.WriteInt32(g.structHash)

	// WriteData fields in sorted order
	// Field: BoolSlice ([]bool)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, write directly without null flag
			fory.WriteBoolSlice(buf, v.BoolSlice)
		} else {
			// Native Go mode: slices are nullable, write null flag
			if v.BoolSlice == nil {
				buf.WriteInt8(-3) // NullFlag
			} else {
				buf.WriteInt8(-1) // NotNullValueFlag
				fory.WriteBoolSlice(buf, v.BoolSlice)
			}
		}
	}
	// Field: IntSlice ([]int32)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, write directly without null flag
			fory.WriteInt32Slice(buf, v.IntSlice)
		} else {
			// Native Go mode: slices are nullable, write null flag
			if v.IntSlice == nil {
				buf.WriteInt8(-3) // NullFlag
			} else {
				buf.WriteInt8(-1) // NotNullValueFlag
				fory.WriteInt32Slice(buf, v.IntSlice)
			}
		}
	}
	// Field: FloatSlice ([]float64)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, write directly without null flag
			fory.WriteFloat64Slice(buf, v.FloatSlice)
		} else {
			// Native Go mode: slices are nullable, write null flag
			if v.FloatSlice == nil {
				buf.WriteInt8(-3) // NullFlag
			} else {
				buf.WriteInt8(-1) // NotNullValueFlag
				fory.WriteFloat64Slice(buf, v.FloatSlice)
			}
		}
	}
	// Field: StringSlice ([]string)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, write directly without null flag
			sliceLen := 0
			if v.StringSlice != nil {
				sliceLen = len(v.StringSlice)
			}
			buf.WriteVarUint32(uint32(sliceLen))
			if sliceLen > 0 {
				collectFlag := 12 // CollectionIsSameType | CollectionIsDeclElementType
				if ctx.TrackRef() {
					collectFlag |= 1 // CollectionTrackingRef for referencable element type
				}
				buf.WriteInt8(int8(collectFlag))
				for _, elem := range v.StringSlice {
					if ctx.TrackRef() {
						buf.WriteInt8(-1) // NotNullValueFlag for element
					}
					ctx.WriteString(elem)
				}
			}
		} else {
			// Native Go mode: slices are nullable, write null flag
			if v.StringSlice == nil {
				buf.WriteInt8(-3) // NullFlag
			} else {
				buf.WriteInt8(-1) // NotNullValueFlag
				sliceLen := len(v.StringSlice)
				buf.WriteVarUint32(uint32(sliceLen))
				if sliceLen > 0 {
					collectFlag := 12 // CollectionIsSameType | CollectionIsDeclElementType
					if ctx.TrackRef() {
						collectFlag |= 1 // CollectionTrackingRef for referencable element type
					}
					buf.WriteInt8(int8(collectFlag))
					for _, elem := range v.StringSlice {
						if ctx.TrackRef() {
							buf.WriteInt8(-1) // NotNullValueFlag for element
						}
						ctx.WriteString(elem)
					}
				}
			}
		}
	}
	return nil
}

// WriteData provides reflect.Value interface compatibility (implements fory.Serializer)
func (g *SliceDemo_ForyGenSerializer) WriteData(ctx *fory.WriteContext, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	// Convert reflect.Value to concrete type and delegate to typed method
	var v *SliceDemo
	if value.Kind() == reflect.Ptr {
		v = value.Interface().(*SliceDemo)
	} else {
		// Create a copy to get a pointer
		temp := value.Interface().(SliceDemo)
		v = &temp
	}
	// Delegate to strongly-typed method for maximum performance
	if err := g.WriteTyped(ctx, v); err != nil {
		ctx.SetError(fory.FromError(err))
	}
}

// Read is the entry point for deserialization with ref/type handling
func (g *SliceDemo_ForyGenSerializer) Read(ctx *fory.ReadContext, refMode fory.RefMode, readType bool, hasGenerics bool, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	_ = hasGenerics  // not used for struct serializers
	err := ctx.Err() // Get error pointer for deferred error checking
	switch refMode {
	case fory.RefModeTracking:
		refID, refErr := ctx.RefResolver().TryPreserveRefId(ctx.Buffer())
		if refErr != nil {
			ctx.SetError(fory.FromError(refErr))
			return
		}
		if int8(refID) < -1 { // NotNullValueFlag
			obj := ctx.RefResolver().GetReadObject(refID)
			if obj.IsValid() {
				value.Set(obj)
			}
			return
		}
	case fory.RefModeNullOnly:
		flag := ctx.Buffer().ReadInt8(err)
		if flag == -3 { // NullFlag
			return
		}
	}
	if readType {
		ctx.TypeResolver().ReadTypeInfo(ctx.Buffer(), err)
	}
	g.ReadData(ctx, value)
}

// ReadTyped provides strongly-typed deserialization with no reflection overhead
func (g *SliceDemo_ForyGenSerializer) ReadTyped(ctx *fory.ReadContext, v *SliceDemo) error {
	buf := ctx.Buffer()
	err := ctx.Err() // Get error pointer for deferred error checking

	// ReadData and verify struct hash
	if got := buf.ReadInt32(err); got != g.structHash {
		if ctx.HasError() {
			return ctx.TakeError()
		}
		return fory.HashMismatchError(got, g.structHash, "SliceDemo")
	}

	// ReadData fields in same order as write
	// Field: BoolSlice ([]bool)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, read directly without null flag
			v.BoolSlice = fory.ReadBoolSlice(buf, err)
		} else {
			// Native Go mode: slices are nullable, read null flag
			nullFlag := buf.ReadInt8(err)
			if nullFlag == -3 {
				v.BoolSlice = nil
			} else {
				v.BoolSlice = fory.ReadBoolSlice(buf, err)
			}
		}
	}
	// Field: IntSlice ([]int32)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, read directly without null flag
			v.IntSlice = fory.ReadInt32Slice(buf, err)
		} else {
			// Native Go mode: slices are nullable, read null flag
			nullFlag := buf.ReadInt8(err)
			if nullFlag == -3 {
				v.IntSlice = nil
			} else {
				v.IntSlice = fory.ReadInt32Slice(buf, err)
			}
		}
	}
	// Field: FloatSlice ([]float64)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, read directly without null flag
			v.FloatSlice = fory.ReadFloat64Slice(buf, err)
		} else {
			// Native Go mode: slices are nullable, read null flag
			nullFlag := buf.ReadInt8(err)
			if nullFlag == -3 {
				v.FloatSlice = nil
			} else {
				v.FloatSlice = fory.ReadFloat64Slice(buf, err)
			}
		}
	}
	// Field: StringSlice ([]string)
	{
		isXlang := ctx.TypeResolver().IsXlang()
		if isXlang {
			// xlang mode: slices are not nullable, read directly without null flag
			sliceLen := int(buf.ReadVarUint32(err))
			if sliceLen == 0 {
				v.StringSlice = make([]string, 0)
			} else {
				collectFlag := buf.ReadInt8(err)
				// Check if CollectionIsDeclElementType is set (bit 2, value 4)
				hasDeclType := (collectFlag & 4) != 0
				// Check if CollectionTrackingRef is set (bit 0, value 1)
				trackRefs := (collectFlag & 1) != 0
				v.StringSlice = make([]string, sliceLen)
				if hasDeclType {
					// Elements are written directly without type IDs
					for i := 0; i < sliceLen; i++ {
						if trackRefs {
							_ = buf.ReadInt8(err) // Read ref flag (NotNullValueFlag)
						}
						v.StringSlice[i] = ctx.ReadString()
					}
				} else {
					// Need to read type ID once if CollectionIsSameType is set
					if (collectFlag & 8) != 0 {
						// ReadData element type ID once for all elements
						_ = buf.ReadVarUint32(err)
					}
					for i := 0; i < sliceLen; i++ {
						if trackRefs {
							_ = buf.ReadInt8(err) // Read ref flag (NotNullValueFlag)
						}
						v.StringSlice[i] = ctx.ReadString()
					}
				}
			}
		} else {
			// Native Go mode: slices are nullable, read null flag
			nullFlag := buf.ReadInt8(err)
			if nullFlag == -3 {
				v.StringSlice = nil
			} else {
				sliceLen := int(buf.ReadVarUint32(err))
				if sliceLen == 0 {
					v.StringSlice = make([]string, 0)
				} else {
					collectFlag := buf.ReadInt8(err)
					// Check if CollectionIsDeclElementType is set (bit 2, value 4)
					hasDeclType := (collectFlag & 4) != 0
					// Check if CollectionTrackingRef is set (bit 0, value 1)
					trackRefs := (collectFlag & 1) != 0
					v.StringSlice = make([]string, sliceLen)
					if hasDeclType {
						// Elements are written directly without type IDs
						for i := 0; i < sliceLen; i++ {
							if trackRefs {
								_ = buf.ReadInt8(err) // Read ref flag (NotNullValueFlag)
							}
							v.StringSlice[i] = ctx.ReadString()
						}
					} else {
						// Need to read type ID once if CollectionIsSameType is set
						if (collectFlag & 8) != 0 {
							// ReadData element type ID once for all elements
							_ = buf.ReadVarUint32(err)
						}
						for i := 0; i < sliceLen; i++ {
							if trackRefs {
								_ = buf.ReadInt8(err) // Read ref flag (NotNullValueFlag)
							}
							v.StringSlice[i] = ctx.ReadString()
						}
					}
				}
			}
		}
	}

	// Final deferred error check
	if ctx.HasError() {
		return ctx.TakeError()
	}
	return nil
}

// ReadData provides reflect.Value interface compatibility (implements fory.Serializer)
func (g *SliceDemo_ForyGenSerializer) ReadData(ctx *fory.ReadContext, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	// Convert reflect.Value to concrete type and delegate to typed method
	var v *SliceDemo
	if value.Kind() == reflect.Ptr {
		if value.IsNil() {
			// For pointer types, allocate using value.Type().Elem()
			value.Set(reflect.New(value.Type().Elem()))
		}
		v = value.Interface().(*SliceDemo)
	} else {
		// value must be addressable for read
		v = value.Addr().Interface().(*SliceDemo)
	}
	// Delegate to strongly-typed method for maximum performance
	if err := g.ReadTyped(ctx, v); err != nil {
		ctx.SetError(fory.FromError(err))
	}
}

// ReadWithTypeInfo deserializes with pre-read type information
func (g *SliceDemo_ForyGenSerializer) ReadWithTypeInfo(ctx *fory.ReadContext, refMode fory.RefMode, typeInfo *fory.TypeInfo, value reflect.Value) {
	g.Read(ctx, refMode, false, false, value)
}

type ValidationDemo_ForyGenSerializer struct {
	structHash int32
}

func NewSerializerFor_ValidationDemo() fory.Serializer {
	return &ValidationDemo_ForyGenSerializer{}
}

func (g *ValidationDemo_ForyGenSerializer) initHash(resolver *fory.TypeResolver) {
	if g.structHash == 0 {
		g.structHash = fory.GetStructHash(reflect.TypeOf(ValidationDemo{}), resolver)
	}
}

// Write is the entry point for serialization with ref/type handling
func (g *ValidationDemo_ForyGenSerializer) Write(ctx *fory.WriteContext, refMode fory.RefMode, writeType bool, hasGenerics bool, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	_ = hasGenerics // not used for struct serializers
	switch refMode {
	case fory.RefModeTracking:
		if !value.IsValid() || (value.Kind() == reflect.Ptr && value.IsNil()) {
			ctx.Buffer().WriteInt8(-3) // NullFlag
			return
		}
		refWritten, err := ctx.RefResolver().WriteRefOrNull(ctx.Buffer(), value)
		if err != nil {
			ctx.SetError(fory.FromError(err))
			return
		}
		if refWritten {
			return
		}
	case fory.RefModeNullOnly:
		if !value.IsValid() || (value.Kind() == reflect.Ptr && value.IsNil()) {
			ctx.Buffer().WriteInt8(-3) // NullFlag
			return
		}
		ctx.Buffer().WriteInt8(-1) // NotNullValueFlag
	}
	if writeType {
		ctx.Buffer().WriteVarUint32(uint32(fory.NAMED_STRUCT))
	}
	g.WriteData(ctx, value)
}

// WriteTyped provides strongly-typed serialization with no reflection overhead
func (g *ValidationDemo_ForyGenSerializer) WriteTyped(ctx *fory.WriteContext, v *ValidationDemo) error {
	buf := ctx.Buffer()
	// WriteData struct hash for compatibility checking
	buf.WriteInt32(g.structHash)

	// WriteData fields in sorted order
	// Field: D (float64)
	buf.WriteFloat64(v.D)
	// Field: E (bool)
	buf.WriteBool(v.E)
	// Field: C (int64)
	buf.WriteVarint64(v.C)
	// Field: A (int32)
	buf.WriteVarint32(v.A)
	// Field: B (string)
	ctx.WriteString(v.B)
	return nil
}

// WriteData provides reflect.Value interface compatibility (implements fory.Serializer)
func (g *ValidationDemo_ForyGenSerializer) WriteData(ctx *fory.WriteContext, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	// Convert reflect.Value to concrete type and delegate to typed method
	var v *ValidationDemo
	if value.Kind() == reflect.Ptr {
		v = value.Interface().(*ValidationDemo)
	} else {
		// Create a copy to get a pointer
		temp := value.Interface().(ValidationDemo)
		v = &temp
	}
	// Delegate to strongly-typed method for maximum performance
	if err := g.WriteTyped(ctx, v); err != nil {
		ctx.SetError(fory.FromError(err))
	}
}

// Read is the entry point for deserialization with ref/type handling
func (g *ValidationDemo_ForyGenSerializer) Read(ctx *fory.ReadContext, refMode fory.RefMode, readType bool, hasGenerics bool, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	_ = hasGenerics  // not used for struct serializers
	err := ctx.Err() // Get error pointer for deferred error checking
	switch refMode {
	case fory.RefModeTracking:
		refID, refErr := ctx.RefResolver().TryPreserveRefId(ctx.Buffer())
		if refErr != nil {
			ctx.SetError(fory.FromError(refErr))
			return
		}
		if int8(refID) < -1 { // NotNullValueFlag
			obj := ctx.RefResolver().GetReadObject(refID)
			if obj.IsValid() {
				value.Set(obj)
			}
			return
		}
	case fory.RefModeNullOnly:
		flag := ctx.Buffer().ReadInt8(err)
		if flag == -3 { // NullFlag
			return
		}
	}
	if readType {
		ctx.TypeResolver().ReadTypeInfo(ctx.Buffer(), err)
	}
	g.ReadData(ctx, value)
}

// ReadTyped provides strongly-typed deserialization with no reflection overhead
func (g *ValidationDemo_ForyGenSerializer) ReadTyped(ctx *fory.ReadContext, v *ValidationDemo) error {
	buf := ctx.Buffer()
	err := ctx.Err() // Get error pointer for deferred error checking

	// ReadData and verify struct hash
	if got := buf.ReadInt32(err); got != g.structHash {
		if ctx.HasError() {
			return ctx.TakeError()
		}
		return fory.HashMismatchError(got, g.structHash, "ValidationDemo")
	}

	// ReadData fields in same order as write
	// Field: D (float64)
	v.D = buf.ReadFloat64(err)
	// Field: E (bool)
	v.E = buf.ReadBool(err)
	// Field: C (int64)
	v.C = buf.ReadVarint64(err)
	// Field: A (int32)
	v.A = buf.ReadVarint32(err)
	// Field: B (string)
	v.B = ctx.ReadString()

	// Final deferred error check
	if ctx.HasError() {
		return ctx.TakeError()
	}
	return nil
}

// ReadData provides reflect.Value interface compatibility (implements fory.Serializer)
func (g *ValidationDemo_ForyGenSerializer) ReadData(ctx *fory.ReadContext, value reflect.Value) {
	g.initHash(ctx.TypeResolver())
	// Convert reflect.Value to concrete type and delegate to typed method
	var v *ValidationDemo
	if value.Kind() == reflect.Ptr {
		if value.IsNil() {
			// For pointer types, allocate using value.Type().Elem()
			value.Set(reflect.New(value.Type().Elem()))
		}
		v = value.Interface().(*ValidationDemo)
	} else {
		// value must be addressable for read
		v = value.Addr().Interface().(*ValidationDemo)
	}
	// Delegate to strongly-typed method for maximum performance
	if err := g.ReadTyped(ctx, v); err != nil {
		ctx.SetError(fory.FromError(err))
	}
}

// ReadWithTypeInfo deserializes with pre-read type information
func (g *ValidationDemo_ForyGenSerializer) ReadWithTypeInfo(ctx *fory.ReadContext, refMode fory.RefMode, typeInfo *fory.TypeInfo, value reflect.Value) {
	g.Read(ctx, refMode, false, false, value)
}

// Compile-time guards: These ensure struct definitions haven't changed
// since code generation. If you modify structs, re-run go generate.

// Snapshot of DynamicSliceDemo's underlying type at generation time.
type _DynamicSliceDemo_expected struct {
	DynamicSlice []any
}

// Compile-time check: this conversion is legal only if DynamicSliceDemo's underlying type
// is identical to _DynamicSliceDemo_expected (names, order, types, tags).
//
// If compilation fails here, it means you've modified the DynamicSliceDemo struct but haven't
// regenerated the code. Please run: go generate
//
// If go generate also fails, delete this file first: rm dynamicslicedemo_fory_gen.go
// Then run: go generate
var _ = func(x DynamicSliceDemo) {
	// ERROR: DynamicSliceDemo struct has changed! Run 'go generate' to fix this.
	_ = _DynamicSliceDemo_expected(x)
}

// Snapshot of MapDemo's underlying type at generation time.
type _MapDemo_expected struct {
	StringMap map[string]string
	IntMap    map[int]int
	MixedMap  map[string]int
}

// Compile-time check: this conversion is legal only if MapDemo's underlying type
// is identical to _MapDemo_expected (names, order, types, tags).
//
// If compilation fails here, it means you've modified the MapDemo struct but haven't
// regenerated the code. Please run: go generate
//
// If go generate also fails, delete this file first: rm mapdemo_fory_gen.go
// Then run: go generate
var _ = func(x MapDemo) {
	// ERROR: MapDemo struct has changed! Run 'go generate' to fix this.
	_ = _MapDemo_expected(x)
}

// Snapshot of SliceDemo's underlying type at generation time.
type _SliceDemo_expected struct {
	IntSlice    []int32
	StringSlice []string
	FloatSlice  []float64
	BoolSlice   []bool
}

// Compile-time check: this conversion is legal only if SliceDemo's underlying type
// is identical to _SliceDemo_expected (names, order, types, tags).
//
// If compilation fails here, it means you've modified the SliceDemo struct but haven't
// regenerated the code. Please run: go generate
//
// If go generate also fails, delete this file first: rm slicedemo_fory_gen.go
// Then run: go generate
var _ = func(x SliceDemo) {
	// ERROR: SliceDemo struct has changed! Run 'go generate' to fix this.
	_ = _SliceDemo_expected(x)
}

// Snapshot of ValidationDemo's underlying type at generation time.
type _ValidationDemo_expected struct {
	A int32
	B string
	C int64
	D float64
	E bool
}

// Compile-time check: this conversion is legal only if ValidationDemo's underlying type
// is identical to _ValidationDemo_expected (names, order, types, tags).
//
// If compilation fails here, it means you've modified the ValidationDemo struct but haven't
// regenerated the code. Please run: go generate
//
// If go generate also fails, delete this file first: rm validationdemo_fory_gen.go
// Then run: go generate
var _ = func(x ValidationDemo) {
	// ERROR: ValidationDemo struct has changed! Run 'go generate' to fix this.
	_ = _ValidationDemo_expected(x)
}
