/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.cache.client.internal.UnregisterInterestOp;
import org.apache.geode.cache.query.internal.cq.ClientCQ;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.cache.tier.sockets.UnregisterAllInterest;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.util.internal.UncheckedUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RegisterInterestTracker {
    private static final Logger logger = LogService.getLogger();
    public static final int interestListIndex = 0;
    public static final int durableInterestListIndex = 1;
    private static final int interestListIndexForUpdatesAsInvalidates = 2;
    private static final int durableInterestListIndexForUpdatesAsInvalidates = 3;
    private final FailoverInterestList[] failoverInterestLists = new FailoverInterestList[4];
    private final ConcurrentMap<ClientCQ, Boolean> cqs = new ConcurrentHashMap<ClientCQ, Boolean>();

    public RegisterInterestTracker() {
        this.failoverInterestLists[0] = new FailoverInterestList();
        this.failoverInterestLists[2] = new FailoverInterestList();
        this.failoverInterestLists[1] = new FailoverInterestList();
        this.failoverInterestLists[3] = new FailoverInterestList();
    }

    public static int getInterestLookupIndex(boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        if (isDurable) {
            if (receiveUpdatesAsInvalidates) {
                return 3;
            }
            return 1;
        }
        if (receiveUpdatesAsInvalidates) {
            return 2;
        }
        return 0;
    }

    public <K> List<K> getInterestList(@NotNull String regionName, @NotNull InterestType interestType2) {
        RegionInterestEntry rie1 = this.readRegionInterests(regionName, interestType2, false, false);
        RegionInterestEntry rie2 = this.readRegionInterests(regionName, interestType2, false, true);
        RegionInterestEntry rie3 = this.readRegionInterests(regionName, interestType2, true, false);
        RegionInterestEntry rie4 = this.readRegionInterests(regionName, interestType2, true, true);
        ArrayList result = new ArrayList();
        if (rie1 != null) {
            result.addAll((Collection)UncheckedUtils.uncheckedCast(rie1.getInterests().keySet()));
        }
        if (rie2 != null) {
            result.addAll((Collection)UncheckedUtils.uncheckedCast(rie2.getInterests().keySet()));
        }
        if (rie3 != null) {
            result.addAll((Collection)UncheckedUtils.uncheckedCast(rie3.getInterests().keySet()));
        }
        if (rie4 != null) {
            result.addAll((Collection)UncheckedUtils.uncheckedCast(rie4.getInterests().keySet()));
        }
        return result;
    }

    @VisibleForTesting
    public void addSingleInterest(@NotNull LocalRegion r, @NotNull Object key, @NotNull InterestType interestType2, @NotNull InterestResultPolicy pol, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie = this.getRegionInterests(r, interestType2, false, isDurable, receiveUpdatesAsInvalidates);
        rie.getInterests().put(key, pol);
    }

    boolean removeSingleInterest(@NotNull LocalRegion r, @NotNull Object key, @NotNull InterestType interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        Object interest;
        RegionInterestEntry rie = this.getRegionInterests(r, interestType2, true, isDurable, receiveUpdatesAsInvalidates);
        if (rie == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("removeSingleInterest region={} key={}", (Object)r.getFullPath(), key);
        }
        if ((interest = rie.getInterests().remove(key)) == null) {
            logger.warn("removeSingleInterest: key {} not registered in the client", key);
            return false;
        }
        return true;
    }

    void addInterestList(@NotNull LocalRegion r, @NotNull List<?> keys, @NotNull InterestResultPolicy pol, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie = this.getRegionInterests(r, InterestType.KEY, false, isDurable, receiveUpdatesAsInvalidates);
        for (Object key : keys) {
            rie.getInterests().put(key, pol);
        }
    }

    public void addCq(ClientCQ cqi, boolean isDurable) {
        this.cqs.put(cqi, isDurable);
    }

    public void removeCq(ClientCQ cqi) {
        this.cqs.remove(cqi);
    }

    Map<ClientCQ, Boolean> getCqsMap() {
        return this.cqs;
    }

    void unregisterRegion(ServerRegionProxy srp, boolean keepalive) {
        this.removeAllInterests(srp, InterestType.KEY, false, keepalive, false);
        this.removeAllInterests(srp, InterestType.FILTER_CLASS, false, keepalive, false);
        this.removeAllInterests(srp, InterestType.OQL_QUERY, false, keepalive, false);
        this.removeAllInterests(srp, InterestType.REGULAR_EXPRESSION, false, keepalive, false);
        this.removeAllInterests(srp, InterestType.KEY, false, keepalive, true);
        this.removeAllInterests(srp, InterestType.FILTER_CLASS, false, keepalive, true);
        this.removeAllInterests(srp, InterestType.OQL_QUERY, false, keepalive, true);
        this.removeAllInterests(srp, InterestType.REGULAR_EXPRESSION, false, keepalive, true);
        if (srp.getPool().isDurableClient()) {
            this.removeAllInterests(srp, InterestType.KEY, true, keepalive, true);
            this.removeAllInterests(srp, InterestType.FILTER_CLASS, true, keepalive, true);
            this.removeAllInterests(srp, InterestType.OQL_QUERY, true, keepalive, true);
            this.removeAllInterests(srp, InterestType.REGULAR_EXPRESSION, true, keepalive, true);
            this.removeAllInterests(srp, InterestType.KEY, true, keepalive, false);
            this.removeAllInterests(srp, InterestType.FILTER_CLASS, true, keepalive, false);
            this.removeAllInterests(srp, InterestType.OQL_QUERY, true, keepalive, false);
            this.removeAllInterests(srp, InterestType.REGULAR_EXPRESSION, true, keepalive, false);
        }
    }

    private void removeAllInterests(ServerRegionProxy srp, @NotNull InterestType interestType2, boolean durable, boolean keepAlive, boolean receiveUpdatesAsInvalidates) {
        block4: {
            String regName = srp.getRegionName();
            ConcurrentMap<String, RegionInterestEntry> allInterests = this.getRegionToInterestsMap(interestType2, durable, receiveUpdatesAsInvalidates);
            if (allInterests.remove(regName) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("removeAllInterests region={} type={}", (Object)regName, (Object)InterestType.getString(interestType2));
                }
                try {
                    UnregisterAllInterest key = UnregisterAllInterest.singleton();
                    UnregisterInterestOp.execute(srp.getPool(), regName, key, interestType2, true, keepAlive);
                }
                catch (Exception e) {
                    if (srp.getPool().getCancelCriterion().isCancelInProgress()) break block4;
                    logger.warn("Problem removing all interest on region={} interestType={} :{}", new Object[]{regName, InterestType.getString(interestType2), e.getLocalizedMessage()});
                }
            }
        }
    }

    boolean removeInterestList(@NotNull LocalRegion r, @NotNull List<?> keys, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie = this.getRegionInterests(r, InterestType.KEY, true, isDurable, receiveUpdatesAsInvalidates);
        if (rie == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("removeInterestList region={} keys={}", (Object)r.getFullPath(), keys);
        }
        int removeCount = 0;
        for (Object key : keys) {
            Object interest = rie.getInterests().remove(key);
            if (interest != null) {
                ++removeCount;
                continue;
            }
            logger.warn("removeInterestList: key {} not registered in the client", key);
        }
        return removeCount != 0;
    }

    ConcurrentMap<String, RegionInterestEntry> getRegionToInterestsMap(InterestType interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        FailoverInterestList fil = this.failoverInterestLists[RegisterInterestTracker.getInterestLookupIndex(isDurable, receiveUpdatesAsInvalidates)];
        switch (interestType2) {
            case KEY: {
                return fil.keysOfInterest;
            }
            case REGULAR_EXPRESSION: {
                return fil.regexOfInterest;
            }
            case FILTER_CLASS: {
                return fil.filtersOfInterest;
            }
            case CQ: {
                return fil.cqsOfInterest;
            }
            case OQL_QUERY: {
                return fil.queriesOfInterest;
            }
        }
        throw new InternalGemFireError("Unknown interestType");
    }

    private RegionInterestEntry getRegionInterests(LocalRegion r, InterestType interestType2, boolean forRemoval, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie;
        String regionName = r.getFullPath();
        ConcurrentMap<String, RegionInterestEntry> mapOfInterest = this.getRegionToInterestsMap(interestType2, isDurable, receiveUpdatesAsInvalidates);
        RegionInterestEntry result = (RegionInterestEntry)mapOfInterest.get(regionName);
        if (result == null && !forRemoval && (result = mapOfInterest.putIfAbsent(regionName, rie = new RegionInterestEntry(r))) == null) {
            result = rie;
        }
        return result;
    }

    private RegionInterestEntry readRegionInterests(String regionName, @NotNull InterestType interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        ConcurrentMap<String, RegionInterestEntry> mapOfInterest = this.getRegionToInterestsMap(interestType2, isDurable, receiveUpdatesAsInvalidates);
        return (RegionInterestEntry)mapOfInterest.get(regionName);
    }

    public boolean hasInterestsWithResultPolicy(@NotNull String regionName, boolean isDurable, @NotNull InterestResultPolicy interestResultPolicy) {
        return Stream.of(InterestType.values()).anyMatch(interestType2 -> this.hasInterestsWithResultPolicy(regionName, isDurable, interestResultPolicy, (InterestType)((Object)interestType2)));
    }

    public boolean hasInterestsWithResultPolicy(@NotNull String regionName, boolean isDurable, @NotNull InterestResultPolicy interestResultPolicy, @NotNull InterestType interestType2) {
        return Stream.of(true, false).anyMatch(receiveUpdatesAsInvalidates -> this.hasInterestsWithResultPolicy(regionName, isDurable, interestResultPolicy, interestType2, (boolean)receiveUpdatesAsInvalidates));
    }

    private boolean hasInterestsWithResultPolicy(@NotNull String regionName, boolean isDurable, @NotNull InterestResultPolicy interestResultPolicy, @NotNull InterestType interestType2, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry regionInterestEntry = this.readRegionInterests(regionName, interestType2, isDurable, receiveUpdatesAsInvalidates);
        return regionInterestEntry != null && regionInterestEntry.getInterests().values().stream().anyMatch(actualInterestResultPolicy -> actualInterestResultPolicy.getOrdinal() == interestResultPolicy.getOrdinal());
    }

    public static class RegionInterestEntry {
        private final LocalRegion region;
        private final ConcurrentMap<Object, InterestResultPolicy> interests;

        RegionInterestEntry(LocalRegion r) {
            this.region = r;
            this.interests = new ConcurrentHashMap<Object, InterestResultPolicy>();
        }

        public LocalRegion getRegion() {
            return this.region;
        }

        public ConcurrentMap<Object, InterestResultPolicy> getInterests() {
            return this.interests;
        }
    }

    protected static class FailoverInterestList {
        final ConcurrentMap<String, RegionInterestEntry> keysOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();
        final ConcurrentMap<String, RegionInterestEntry> regexOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();
        final ConcurrentMap<String, RegionInterestEntry> filtersOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();
        final ConcurrentMap<String, RegionInterestEntry> queriesOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();
        final ConcurrentMap<String, RegionInterestEntry> cqsOfInterest = new ConcurrentHashMap<String, RegionInterestEntry>();

        protected FailoverInterestList() {
        }
    }
}

