/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryHeapUUIDKey;

public abstract class VersionedStatsRegionEntryHeap
extends VersionedStatsRegionEntry {
    @Immutable
    private static final VersionedStatsRegionEntryHeapFactory factory = new VersionedStatsRegionEntryHeapFactory();

    public VersionedStatsRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedStatsRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VersionedStatsRegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedStatsRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedStatsRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedStatsRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedStatsRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedStatsRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedStatsRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedStatsRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

