/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamMonitor;
import com.healthmarketscience.rmiio.RemoteOutputStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteOutputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.beans.FileUploaderMBean;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class FileUploader
implements FileUploaderMBean {
    public static final String STAGED_DIR_PREFIX = "uploaded-";
    private static final Logger logger = LogService.getLogger();
    private final RemoteStreamExporter exporter;

    public FileUploader(RemoteStreamExporter exporter) {
        this.exporter = exporter;
    }

    @Override
    public RemoteFile uploadFile(String filename) throws IOException {
        Path tempDir = FileUploader.createSecuredTempDirectory(STAGED_DIR_PREFIX);
        File stagedFile = new File(tempDir.toString(), filename);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(stagedFile));
        RemoteOutputStreamMonitor monitor = new RemoteOutputStreamMonitor(){

            @Override
            public void closed(RemoteOutputStreamServer stream, boolean clean) {
                try {
                    stream.close(true);
                }
                catch (IOException e) {
                    logger.error("error closing RemoteOutputStreamServer", (Throwable)e);
                }
            }
        };
        SimpleRemoteOutputStream server = new SimpleRemoteOutputStream(bos, monitor);
        RemoteOutputStream remoteStream = (RemoteOutputStream)this.exporter.export(server);
        RemoteFile remoteFile = new RemoteFile(stagedFile.getAbsolutePath(), remoteStream);
        return remoteFile;
    }

    @Override
    public void deleteFiles(List<String> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        for (String filename : files) {
            File file = new File(filename);
            File parent = file.getParentFile();
            if (!parent.getName().startsWith(STAGED_DIR_PREFIX)) {
                throw new GemFireSecurityException(String.format("Cannot delete %s, not in the uploaded directory.", filename));
            }
            FileUtils.deleteQuietly((File)file);
            FileUtils.deleteQuietly((File)parent);
        }
    }

    public static Path createSecuredTempDirectory(String prefix) throws IOException {
        Path tempDir = Files.createTempDirectory(prefix, new FileAttribute[0]);
        tempDir.toFile().setExecutable(true, true);
        tempDir.toFile().setWritable(true, true);
        tempDir.toFile().setReadable(true, true);
        return tempDir;
    }

    public static class RemoteFile
    implements Serializable {
        private final String filename;
        private final RemoteOutputStream outputStream;

        public RemoteFile(String filename, RemoteOutputStream outputStream) {
            this.filename = filename;
            this.outputStream = outputStream;
        }

        public String getFilename() {
            return this.filename;
        }

        public RemoteOutputStream getOutputStream() {
            return this.outputStream;
        }
    }
}

