/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.partitioned.ColocatedRegionDetails;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.PersistentMemberDetails;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.functions.ShowMissingDiskStoresFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class ShowMissingDiskStoreCommand
extends GfshCommand {
    public static final String MISSING_DISK_STORES_SECTION = "missing-disk-stores";
    public static final String MISSING_COLOCATED_REGIONS_SECTION = "missing-colocated-regions";

    @CliCommand(value={"show missing-disk-stores"}, help="Display a summary of the disk stores that are currently missing from a distributed system.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel showMissingDiskStore() {
        Set<DistributedMember> dataMembers = DiskStoreCommandsUtils.getNormalMembers((InternalCache)this.getCache());
        List<ColocatedRegionDetails> missingRegions = null;
        if (!dataMembers.isEmpty()) {
            missingRegions = this.getMissingColocatedRegionList(dataMembers);
        }
        DistributedSystemMXBean dsMXBean = ManagementService.getManagementService((Cache)this.getCache()).getDistributedSystemMXBean();
        PersistentMemberDetails[] missingDiskStores = dsMXBean.listMissingDiskStores();
        return this.toMissingDiskStoresTabularResult(missingDiskStores, missingRegions);
    }

    private List<ColocatedRegionDetails> getMissingColocatedRegionList(Set<DistributedMember> members) {
        Execution membersFunctionExecutor = this.getMembersFunctionExecutor(members);
        if (membersFunctionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)membersFunctionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultCollector = membersFunctionExecutor.execute((Function)new ShowMissingDiskStoresFunction());
        List results = (List)resultCollector.getResult();
        return results.stream().filter(Set.class::isInstance).map(Set.class::cast).flatMap(Collection::stream).filter(ColocatedRegionDetails.class::isInstance).map(ColocatedRegionDetails.class::cast).collect(Collectors.toList());
    }

    private ResultModel toMissingDiskStoresTabularResult(PersistentMemberDetails[] missingDiskStores, List<ColocatedRegionDetails> missingColocatedRegions) {
        ResultModel result = new ResultModel();
        TabularResultModel missingDiskStoreSection = result.addTable(MISSING_DISK_STORES_SECTION);
        if (missingDiskStores.length != 0) {
            missingDiskStoreSection.setHeader("Missing Disk Stores");
            for (PersistentMemberDetails persistentMemberDetails : missingDiskStores) {
                missingDiskStoreSection.accumulate("Disk Store ID", persistentMemberDetails.getDiskStoreId());
                missingDiskStoreSection.accumulate("Host", persistentMemberDetails.getHost());
                missingDiskStoreSection.accumulate("Directory", persistentMemberDetails.getDirectory());
            }
        } else {
            missingDiskStoreSection.setHeader("No missing disk store found");
        }
        TabularResultModel missingRegionsSection = result.addTable(MISSING_COLOCATED_REGIONS_SECTION);
        if (missingColocatedRegions == null) {
            missingRegionsSection.setHeader("No caching members found.");
        } else if (!missingColocatedRegions.isEmpty()) {
            missingRegionsSection.setHeader("Missing Colocated Regions");
            for (ColocatedRegionDetails colocatedRegionDetails : missingColocatedRegions) {
                missingRegionsSection.accumulate("Host", colocatedRegionDetails.getHost());
                missingRegionsSection.accumulate("Distributed Member", colocatedRegionDetails.getMember());
                missingRegionsSection.accumulate("Parent Region", colocatedRegionDetails.getParent());
                missingRegionsSection.accumulate("Missing Colocated Region", colocatedRegionDetails.getChild());
            }
        } else {
            missingRegionsSection.setHeader("No missing colocated region found");
        }
        return result;
    }
}

