/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import org.springframework.util.Assert;

public class CommentSkipHelper {
    private boolean inBlockComment;

    public String skipComments(String line) {
        if (!this.inBlockComment && line.contains("/*") && line.contains("*/")) {
            this.blockCommentBegin();
            String lhs = line.substring(0, line.lastIndexOf("/*"));
            if (line.contains("*/")) {
                line = lhs + line.substring(line.lastIndexOf("*/") + 2);
                this.blockCommentFinish();
            } else {
                line = lhs;
            }
        } else if (!this.inBlockComment && line.contains("/*")) {
            this.blockCommentBegin();
        }
        if (this.inBlockComment) {
            if (!line.contains("*/")) {
                return null;
            }
            this.blockCommentFinish();
            line = line.substring(line.lastIndexOf("*/") + 2);
        }
        if (!this.inBlockComment && (line.trim().startsWith("//") || line.trim().startsWith("#"))) {
            line = "";
        }
        line = line.replace('\t', ' ');
        return line;
    }

    private void blockCommentBegin() {
        Assert.isTrue(!this.inBlockComment, "Cannot open a new block comment when one already active");
        this.inBlockComment = true;
    }

    private void blockCommentFinish() {
        Assert.isTrue(this.inBlockComment, "Cannot close a block comment when it has not been opened");
        this.inBlockComment = false;
    }

    private void reset() {
        this.inBlockComment = false;
    }
}

