/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.WeightedPath;
import org.apache.hugegraph.util.E;

public class WeightedShortestPathAPI
extends TraversersAPI {
    public WeightedShortestPathAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "weightedshortestpath";
    }

    public WeightedPath get(Object sourceId, Object targetId, Direction direction, String label, String weight, long degree, long skipDegree, long capacity, boolean withVertex) {
        this.client.checkApiVersion("0.51", "weighted shortest path");
        String source = GraphAPI.formatVertexId(sourceId, false);
        String target = GraphAPI.formatVertexId(targetId, false);
        E.checkNotNull((Object)weight, (String)"weight");
        WeightedShortestPathAPI.checkDegree(degree);
        WeightedShortestPathAPI.checkCapacity(capacity);
        WeightedShortestPathAPI.checkSkipDegree(skipDegree, degree, capacity);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("target", target);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("weight", weight);
        params.put("max_degree", degree);
        params.put("skip_degree", skipDegree);
        params.put("capacity", capacity);
        params.put("with_vertex", withVertex);
        RestResult result = this.client.get(this.path(), params);
        return (WeightedPath)result.readObject(WeightedPath.class);
    }
}

