/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.builder;

import com.alipay.common.tracer.core.utils.StringUtils;
import java.util.Map;

public class XStringBuilder {
    public static final int DEFAULT_BUFFER_SIZE = 256;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final String DEFAULT_SEPARATOR_ESCAPE = "%2C";
    public static final String AND_SEPARATOR = "&";
    public static final String AND_SEPARATOR_ESCAPE = "%26";
    public static final String EQUAL_SEPARATOR = "=";
    public static final String EQUAL_SEPARATOR_ESCAPE = "%3D";
    public static final String PERCENT = "%";
    public static final String PERCENT_ESCAPE = "%25";
    private static char separator = (char)44;
    private static String separatorStr = separator + "";
    private static String spearatorEscape = "%2C";
    private StringBuilder sb;

    public XStringBuilder() {
        this(256, ',');
    }

    public XStringBuilder(int size) {
        this(size, ',');
    }

    public XStringBuilder(int size, char separator) {
        XStringBuilder.separator = separator;
        this.sb = new StringBuilder(size);
    }

    public XStringBuilder append(String str) {
        this.sb.append(str == null ? "" : str).append(separator);
        return this;
    }

    public XStringBuilder append(long str) {
        this.sb.append(str).append(separator);
        return this;
    }

    public XStringBuilder append(long str, String separator) {
        this.sb.append(str).append(separator);
        return this;
    }

    public XStringBuilder append(long str, char separator) {
        this.sb.append(str).append(separator);
        return this;
    }

    public XStringBuilder append(String str, String separator) {
        this.sb.append(str == null ? "" : str).append(separator);
        return this;
    }

    public XStringBuilder append(int str) {
        this.sb.append(str).append(separator);
        return this;
    }

    public XStringBuilder append(char str) {
        this.sb.append(str).append(separator);
        return this;
    }

    public XStringBuilder append(Map<String, String> map) {
        this.appendEscape(StringUtils.mapToString(map));
        return this;
    }

    public XStringBuilder appendEnd(int str) {
        this.sb.append(str).append("\r\n");
        return this;
    }

    public XStringBuilder appendEnd(String str) {
        this.sb.append(str == null ? "" : str).append("\r\n");
        return this;
    }

    public XStringBuilder appendEnd(long str) {
        this.sb.append(str).append("\r\n");
        return this;
    }

    public XStringBuilder appendEnd(char c) {
        this.sb.append(String.valueOf(c)).append("\r\n");
        return this;
    }

    public XStringBuilder appendEnd(Map<String, String> map) {
        this.appendEscapeEnd(StringUtils.mapToString(map));
        return this;
    }

    public XStringBuilder appendRaw(String str) {
        this.sb.append(str == null ? "" : str);
        return this;
    }

    public XStringBuilder appendEscape(String str) {
        str = str == null ? "" : str;
        str = str.replace(separatorStr, spearatorEscape);
        return this.append(str);
    }

    public XStringBuilder appendEscapeRaw(String str) {
        str = str == null ? "" : str;
        str = str.replace(separatorStr, spearatorEscape);
        return this.appendRaw(str);
    }

    public XStringBuilder appendEscapeEnd(String str) {
        str = str == null ? "" : str;
        str = str.replace(separatorStr, spearatorEscape);
        return this.appendEnd(str);
    }

    public XStringBuilder reset() {
        this.sb.delete(0, this.sb.length());
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }
}

