/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.apache.hugegraph.backend;

import org.apache.hugegraph.HugeException;

public class BackendException extends HugeException {

    private static final long serialVersionUID = -1947589125372576298L;

    public BackendException(String message) {
        super(message);
    }

    public BackendException(String message, Throwable cause) {
        super(message, cause);
    }

    public BackendException(String message, Object... args) {
        super(message, args);
    }

    public BackendException(String message, Throwable cause, Object... args) {
        super(message, cause, args);
    }

    public BackendException(Throwable cause) {
        this("Exception in backend", cause);
    }

    public static final void check(boolean expression, String message, Object... args)
                                   throws BackendException {
        if (!expression) {
            throw new BackendException(message, args);
        }
    }
}
