## 2. 创建功能设计文档

### 上下文与触发条件 (Context & Trigger)

此流程在用户已批准功能需求文档 (`requirements.md`) 后启动。必须确保相关的需求文档已经存在并获得认可。

### 核心目标 (Core Objective)

基于已批准的需求，创建一份全面、可执行的技术设计文档。这份文档将保存在 `.workflow/{feature_name}/design.md` 文件中，并作为后续任务规划的基础。

### 核心工作流程 (Core Workflow)

必须严格遵循以下步骤顺序执行：

1.  **强制调研与信息请求 (Mandatory Research & Information Request)**:

    - **第一步是调研**。在产出任何设计细节前，必须先进行技术调研。
    - **主动请求信息**：为了使调研更有效，必须首先向用户请求上下文信息。使用如下话术：“**为了更好地进行调研和设计，您可以把您认为最相关的代码片段、配置文件或文档附上一部分吗？这将极大地帮助我理解现有架构。**”
    - **总结与引用**:
      - 基于用户提供的信息和对通用最佳实践的理解，总结关键的调研发现。
      - **必须将调研发现直接融入设计文档的相应部分**，而不是创建独立的调研文件。
      - 如果在调研中参考了外部资料（如技术文章、库文档等），**必须在对话中引用来源并提供相关链接**。

2.  **创建设计文档初稿 (`design.md`)**:

    - 如果 `.workflow/{feature_name}/design.md` 文件不存在，则创建它。
    - 依据下文的 **“`design.md` 文档规格”**，编写一份包含所有必需部分的设计文档初稿。在适当时，应包含图表或可视化内容（使用 Mermaid 绘制）。
    - **突出设计决策**：必须在文档中清晰地突出关键的设计决策及其背后的理由。
    - **征求意见**：在设计过程中，可就特定的技术决策向用户征求意见。例如：“关于数据存储，我们可以在现有表中增加字段，也可以创建新表。我倾向于创建新表以实现关注点分离，您觉得呢？”
    - **覆盖所有需求**：必须确保最终的设计能够覆盖澄清过程中确定的所有功能需求。
    - 在设计过程中，如果发现需求存在歧义或缺口，必须暂停并向用户提问以澄清，或直接建议返回需求阶段。

3.  **口头演练 (Verbal Dry-Run)**:

    - 在呈现设计文档初稿之后，但在请求正式批准之前，**必须进行一次口头的实现路径演练**。
    - 使用如下话术：“**在您详细审查文档前，让我快速口头描述一下设想的实现路径，以帮助我们提前发现潜在风险：[此处用几句话简要、清晰地描述从用户操作到系统响应的端到端数据流和关键组件交互]。这个流程听起来有什么问题吗？**”

4.  **互动与批准循环 (Interaction & Approval Loop)**:
    - 在完成口头演练并根据初步反馈调整后，**必须暂停并正式请求用户批准**。使用如下确切问句：“**这份设计文档怎么样？如果还不错，将进入计划实施阶段。**”
    - 如果用户未提供明确批准（如“是”、“批准了”等），则必须根据其反馈修改设计文档。
    - **每一轮修订后，都必须再次征求用户的明确批准**，并重复此步骤。
    - **严禁**在未获得用户明确批准前，进入或提及“实施计划”阶段。

### `design.md` 文档规格与内容要求

产出的设计文档必须严格遵循以下结构，并突出设计决策及其背后的理由。

- **文件结构**: 一份包含以下所有部分的 Markdown 文件。
- **图表示例**: 在适当的情况下，使用 Mermaid.js 语法嵌入图表。

#### 示例格式应用

````markdown
# 设计文档: “记住我”功能

## 1. 概述 (Overview)

### 1.1. 目标 (Goals)

为用户提供“记住我”选项，允许其在关闭浏览器后的一段时间内（例如 30 天）保持登录状态，以提升回访用户的体验。

### 1.2. 范围 (Scope)

- **In-Scope**:
  - 在登录页面提供“记住我”复选框。
  - 用户勾选后，生成长效持久化令牌。
  - 用户下次访问时，通过令牌自动完成登录。
- **Out-of-Scope**:
  - 管理已登录设备或吊销特定令牌的功能。
  - 跨设备同步“记住我”状态。

### 1.3. 关联需求 (Related Requirements)

- (关联需求: F-Auth-05, NF-SEC-02)

## 2. 整体架构 (System Architecture)

### 2.1. 架构图 (Diagram)

[此处应嵌入一个高层级的架构图，用于清晰地展示新功能将如何融入现有系统，以及关键组件间的交互关系。**推荐使用序列图 (Sequence Diagram) 来描述交互流程，或使用组件图 (Component Diagram) / C4 模型来展示系统结构。**]

### 2.2. 设计决策与权衡 (Design Decisions & Trade-offs)

- **决策**: 采用独立的持久化令牌，而非延长会话(session)有效期。
  - **理由**: 增强安全性。长效会话更容易被劫持，而持久化令牌可以设计为一次性使用或与特定设备/IP 绑定，且不直接暴露会话 ID。
  - **权衡**: 实现逻辑比简单延长会话略复杂，需要额外的数据表和验证逻辑。

## 3. 数据模型 (Data Model)

**决策**: 新建`persistent_tokens`表来存储令牌信息，以实现关注点分离。

[如果需要修改数据库，应在此处描述表结构变更。**推荐使用实体关系图 (ER Diagram) 来清晰地展示数据模型。**]

## 4. API 接口设计 (API Design)

[对于每个新增或修改的 API 端点，都应提供详细的定义。]

### `[HTTP 方法] /api/path/to/endpoint`

- **描述**: [清晰地描述此端点的功能和用途。]
- **请求体 (Request Body)**:
  ```json
  {
    "key": "value_type",
    "another_key": "another_value_type"
  }
  ```
````

- **成功响应 (Success Response)**:
  - **状态码**: `200 OK`
  - **响应头 (Headers)**: [可选。列出关键的响应头，如 `Set-Cookie`。]
  - **响应体 (Body)**:
    ```json
    {
      "status": "success",
      "data": {}
    }
    ```
- **失败响应 (Error Response)**:
  - **状态码**: `4xx/5xx`
  - **响应体 (Body)**:
    ```json
    {
      "error": "A descriptive error message."
    }
    ```

## 5. 核心逻辑实现 (Core Logic)

- **令牌验证中间件 `verify_persistent_token`**:
  1. 在常规会话验证失败后触发。
  2. 从请求的`Cookie`中提取`remember_token`。
  3. 如果令牌不存在，则流程结束。
  4. 使用`SHA-256`对令牌进行哈希计算。
  5. 在`persistent_tokens`表中查找该哈希值。
  6. 若找到且`expires_at`未过期，则为该`user_id`创建一个新的会话(session)，并删除当前使用的持久化令牌（增强安全性，每次都换新令牌）。
  7. 若未找到或已过期，则清除客户端的无效`remember_token` Cookie。

## 6. 非功能性需求 (Non-Functional Requirements)

- **安全性 (Security)**:
  - 令牌在数据库中必须使用强哈希算法（如 SHA-256）存储，绝不能明文存储。
  - `remember_token` Cookie 必须设置为`HttpOnly`以防止 XSS 攻击，设置为`Secure`以确保只在 HTTPS 下传输。
- **性能 (Performance)**:
  - 令牌验证的数据库查询（基于主键）必须在`50ms`内完成。

## 7. 测试策略 (Testing Strategy)

- **单元测试**:
  - `generate_secure_token()`函数的随机性和唯一性。
  - `hash_token()`函数的正确性。
- **集成测试**:
  - `POST /api/auth/login`接口在`rememberMe`为 true/false 时，响应头的`Set-Cookie`是否正确。
  - `verify_persistent_token`中间件能否在有/无/无效/过期令牌的情况下正确处理。
- **端到端测试**:
  - 模拟用户勾选“记住我”并登录，关闭浏览器，30 分钟后再打开，应能自动登录。
  - 模拟令牌过期后，用户需要重新手动登录。

## 8. 风险与缓解措施 (Risks & Mitigation)

- **风险**: 用户的物理设备被盗，导致账户被非授权访问。

  - **缓解措施**: 在用户修改密码或手动“登出所有设备”时，必须清空该用户在`persistent_tokens`表中的所有记录。

- ⚠️ 若在设计过程中发现需求存在缺口，模型应主动建议返回功能需求澄清阶段
