/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.compute.JobExecutorType;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.proto.StreamerReceiverSerializer;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.network.ClusterNodeImpl;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.table.partition.HashPartition;
import org.apache.ignite3.table.IgniteTables;
import org.apache.ignite3.table.ReceiverExecutionOptions;

public class ClientStreamerWithReceiverBatchSendRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteTables tables, boolean enableExecutionOptions, HybridTimestampTracker tsTracker) {
        int tableId = in.unpackInt();
        int partition = in.unpackInt();
        List<DeploymentUnit> deploymentUnits = in.unpackDeploymentUnits();
        boolean returnResults = in.unpackBoolean();
        int payloadElementCount = in.unpackInt();
        int payloadSize = in.unpackBinaryHeader();
        byte[] payloadArr = new byte[payloadSize + 4];
        ByteBuffer payloadBuf = ByteBuffer.wrap(payloadArr).order(ByteOrder.LITTLE_ENDIAN);
        payloadBuf.putInt(payloadElementCount);
        in.readPayload(payloadBuf);
        ReceiverExecutionOptions options = enableExecutionOptions ? ReceiverExecutionOptions.builder().priority(in.unpackInt()).maxRetries(in.unpackInt()).executorType(JobExecutorType.fromOrdinal(in.unpackInt())).build() : ReceiverExecutionOptions.DEFAULT;
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> ((CompletableFuture)((CompletableFuture)table.partitionManager().primaryReplicaAsync(new HashPartition(partition)).thenApply(ClusterNodeImpl::fromPublicClusterNode)).thenCompose(node -> table.internalTable().streamerReceiverRunner().runReceiverAsync(payloadArr, (InternalClusterNode)node, deploymentUnits, options))).thenApply(res -> {
            byte[] resBytes = (byte[])res.get1();
            Long observableTs = (Long)res.get2();
            assert (observableTs != null) : "Observable timestamp should not be null";
            assert (observableTs != 0L) : "Observable timestamp should not be NULL_HYBRID_TIMESTAMP";
            tsTracker.update(observableTs);
            return out -> StreamerReceiverSerializer.serializeReceiverResultsForClient(out, (byte[])(returnResults ? resBytes : null));
        }));
    }
}

