/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.mappers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.function.FailableBiFunction;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.migrationtools.persistence.mappers.CustomTupleImpl;
import org.apache.ignite.migrationtools.persistence.mappers.RecordAndTableSchemaMismatchException;
import org.apache.ignite.migrationtools.persistence.mappers.SchemaColumnProcessorStats;
import org.apache.ignite.migrationtools.persistence.mappers.SchemaColumnsProcessor;
import org.apache.ignite.migrationtools.persistence.utils.pubsub.BasicProcessor;
import org.apache.ignite.migrationtools.types.converters.TypeConverterFactory;
import org.apache.ignite3.internal.client.table.ClientColumn;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.sql.ColumnType;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaColumnsProcessor
extends BasicProcessor<Map.Entry<Object, Object>, DataStreamerItem<Map.Entry<Tuple, Tuple>>>
implements SchemaColumnsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSchemaColumnsProcessor.class);
    private final ObjectMapper jsonMapper;
    private final Map<String, String> fieldNameForColumn;
    private final TypeConverterFactory typeConverterFactory;
    private final List<ColumnMapping> keyColumnMappings;
    private final List<ColumnMapping> valColumnMappings;
    private final Map<Integer, TypeProcessingResult> keyProcessedTypes;
    private final Map<Map.Entry<Integer, Integer>, TypeProcessingResult> valProcessedTypes;
    private final FailableFunction<Object, Tuple, Throwable> keyMapperFunction;
    private final FailableBiFunction<Object, BinaryType, Tuple, Throwable> valMapperFunction;
    private long processedElems = 0L;
    private boolean receivedError = false;

    public AbstractSchemaColumnsProcessor(ClientSchema schema, Map<String, String> fieldNameForColumn, TypeConverterFactory typeConverterFactory, boolean packExtraFields) {
        this.fieldNameForColumn = fieldNameForColumn;
        this.typeConverterFactory = typeConverterFactory;
        this.jsonMapper = AbstractSchemaColumnsProcessor.createMapper();
        this.keyProcessedTypes = new HashMap<Integer, TypeProcessingResult>();
        this.valProcessedTypes = new HashMap<Map.Entry<Integer, Integer>, TypeProcessingResult>();
        ClientColumn[] columns = schema.columns();
        int extraFieldsColumnIdx = -1;
        this.keyColumnMappings = new ArrayList<ColumnMapping>(columns.length);
        this.valColumnMappings = new ArrayList<ColumnMapping>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            ClientColumn col = columns[i];
            String columnNameOrAlias = this.fieldNameForColumn.getOrDefault(col.name(), col.name());
            if (col.key()) {
                this.keyColumnMappings.add(new ColumnMapping(col, columnNameOrAlias));
                continue;
            }
            if (!AbstractSchemaColumnsProcessor.isExtraFieldsColumn(col)) {
                this.valColumnMappings.add(new ColumnMapping(col, columnNameOrAlias));
                continue;
            }
            extraFieldsColumnIdx = i;
        }
        boolean shouldPackExtraFields = packExtraFields && extraFieldsColumnIdx >= 0;
        this.keyMapperFunction = this.keyColumnMappings.size() == 1 && this.keyColumnMappings.get((int)0).column.type() == ColumnType.BYTE_ARRAY ? keyObject -> this.packIntoBinary(keyObject, this.keyColumnMappings.get((int)0).column.name()) : keyObject -> {
            if (keyObject instanceof BinaryObjectImpl) {
                BinaryObjectImpl boi = (BinaryObjectImpl)keyObject;
                BinaryType keyRawType = boi.rawType();
                TypeProcessingResult keyMappingInfo = this.keyProcessedTypes.computeIfAbsent(keyRawType.typeId(), i -> AbstractSchemaColumnsProcessor.processBinaryType(keyRawType, this.keyColumnMappings, false));
                return this.packIntoMany(boi, keyMappingInfo, false);
            }
            if (this.keyColumnMappings.size() == 1) {
                String columnName = this.keyColumnMappings.get((int)0).column.name();
                return this.packIntoSingle(columnName, keyObject);
            }
            throw RecordMappingException.createUnexpectedRecordTypeError(BinaryObjectImpl.class, keyObject.getClass());
        };
        this.valMapperFunction = this.valColumnMappings.size() == 1 && this.valColumnMappings.get((int)0).column.type() == ColumnType.BYTE_ARRAY ? (valObject, any) -> this.packIntoBinary(valObject, this.valColumnMappings.get((int)0).column.name()) : (valObject, keyBinaryType) -> {
            if (valObject instanceof BinaryObjectImpl) {
                BinaryObjectImpl boi = (BinaryObjectImpl)valObject;
                BinaryType rawType = boi.rawType();
                Integer keyTypeId = keyBinaryType != null ? Integer.valueOf(keyBinaryType.typeId()) : null;
                Pair processedTypesKey = Pair.of((Object)keyTypeId, (Object)rawType.typeId());
                TypeProcessingResult valMappingInfo = this.valProcessedTypes.computeIfAbsent((Map.Entry<Integer, Integer>)processedTypesKey, e -> {
                    TypeProcessingResult res = AbstractSchemaColumnsProcessor.processBinaryType(rawType, this.valColumnMappings, shouldPackExtraFields);
                    if (keyBinaryType != null) {
                        for (String fieldName : keyBinaryType.fieldNames()) {
                            res.additionalFieldsOnType.remove(fieldName);
                        }
                    }
                    return res;
                });
                return this.packIntoMany(boi, valMappingInfo, shouldPackExtraFields);
            }
            if (this.valColumnMappings.size() == 1) {
                String columnName = this.valColumnMappings.get((int)0).column.name();
                return this.packIntoSingle(columnName, valObject);
            }
            throw RecordMappingException.createUnexpectedRecordTypeError(BinaryObjectImpl.class, valObject.getClass());
        };
    }

    private static TypeProcessingResult processBinaryType(BinaryType type, List<ColumnMapping> columnMappings, boolean withExtraFields) {
        Collection fieldNames = type.fieldNames();
        HashMap<String, String> lowerCaseFieldNames = new HashMap<String, String>(fieldNames.size());
        for (String fieldName : fieldNames) {
            lowerCaseFieldNames.put(fieldName.toLowerCase(), fieldName);
        }
        ArrayList<String> missingColumnsOnType = new ArrayList<String>(columnMappings.size());
        ArrayList<ColumnMapping> exitingColumns = new ArrayList<ColumnMapping>(columnMappings.size());
        ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(columnMappings.size());
        for (ColumnMapping colRef : columnMappings) {
            String contains = (String)lowerCaseFieldNames.remove(colRef.objectFieldName.toLowerCase());
            if (contains != null) {
                exitingColumns.add(colRef);
                entries.add(Map.entry(colRef.column.name(), entries.size()));
                continue;
            }
            if (colRef.column.nullable()) continue;
            missingColumnsOnType.add(colRef.column.name());
        }
        ArrayList<String> additionalFieldsOnType = new ArrayList<String>(lowerCaseFieldNames.values());
        if (withExtraFields) {
            entries.add(Map.entry("__EXTRA__", entries.size()));
        }
        Map.Entry[] columnToIdxEntries = entries.toArray(new Map.Entry[0]);
        Map<String, Integer> columnToIdxMap = Map.ofEntries(columnToIdxEntries);
        return new TypeProcessingResult(exitingColumns, missingColumnsOnType, additionalFieldsOnType, columnToIdxMap);
    }

    public static boolean isExtraFieldsColumn(ClientColumn col) {
        return col.type() == ColumnType.BYTE_ARRAY && "__EXTRA__".equals(col.name()) && col.nullable();
    }

    public static ObjectMapper createMapper() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(BinaryObject.class, (JsonSerializer)new BinaryObjectSerializer());
        module.addSerializer(WrapperClass.class, (JsonSerializer)new WrapperClassSerializer());
        return new ObjectMapper().registerModule((Module)module);
    }

    @Override
    public void onNext(Map.Entry<Object, Object> item) {
        Object key = item.getKey();
        Object val = item.getValue();
        BinaryType keyRawType = key instanceof BinaryObjectImpl ? ((BinaryObjectImpl)key).rawType() : null;
        try {
            Tuple keyTuple = (Tuple)this.keyMapperFunction.apply(key);
            Tuple valTuple = (Tuple)this.valMapperFunction.apply(val, (Object)keyRawType);
            this.subscriber.onNext(DataStreamerItem.of(Map.entry(keyTuple, valTuple)));
            ++this.processedElems;
        }
        catch (Throwable e) {
            this.onError(e);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.receivedError = true;
        LOGGER.error("Error while mapping cache objects to tuples", throwable);
        super.onError(throwable);
    }

    public boolean hasReceivedError() {
        return this.receivedError;
    }

    @Override
    public SchemaColumnProcessorStats getStats() {
        return new SchemaColumnProcessorStats(this.processedElems);
    }

    private Tuple packIntoBinary(Object cacheObject, String columnName) throws JsonProcessingException {
        byte[] data = cacheObject instanceof byte[] ? (byte[])cacheObject : this.jsonMapper.writeValueAsBytes(cacheObject);
        return Tuple.create((int)1).set(columnName, (Object)data);
    }

    private Tuple packIntoSingle(String columnName, @Nullable Object val) {
        return Tuple.create((int)1).set(columnName, val);
    }

    protected Tuple packIntoMany(BinaryObjectImpl cacheObject, TypeProcessingResult typeMappingInfo, boolean packExtraFields) throws Exception {
        Collection<String> additionalFieldOnType;
        CustomTupleImpl ret = typeMappingInfo.createTuple();
        List<String> additionalMissingCols = null;
        for (ColumnMapping columnMapping : typeMappingInfo.availableMappings) {
            Object val = cacheObject.field(columnMapping.objectFieldName);
            if (val != null) {
                BinaryObject bo;
                if (val instanceof BinaryObject && (bo = (BinaryObject)val).type().isEnum()) {
                    val = bo.enumName();
                }
                Class<?> columnType = columnMapping.columnType();
                @Nullable TypeConverter converter = this.typeConverterFactory.converterFor(val.getClass(), columnType);
                if (converter != null) {
                    val = converter.toColumnType(val);
                }
            }
            if (val != null || columnMapping.column.nullable()) {
                ret.set(columnMapping.column.name(), val);
                continue;
            }
            if (additionalMissingCols == null) {
                additionalMissingCols = new ArrayList<String>(typeMappingInfo.missingColumnsOnType.size());
                additionalMissingCols.addAll(typeMappingInfo.missingColumnsOnType);
            }
            additionalMissingCols.add(columnMapping.column.name());
        }
        if (packExtraFields) {
            if (!typeMappingInfo.additionalFieldsOnType.isEmpty()) {
                byte[] data = this.jsonMapper.writeValueAsBytes((Object)new WrapperClass(cacheObject, typeMappingInfo.additionalFieldsOnType));
                ret.set("__EXTRA__", data);
            }
            additionalFieldOnType = Collections.emptySet();
        } else {
            additionalFieldOnType = typeMappingInfo.additionalFieldsOnType;
        }
        return this.postProcessMappedTuple(ret, additionalMissingCols == null ? typeMappingInfo.missingColumnsOnType : additionalMissingCols, additionalFieldOnType);
    }

    protected abstract Tuple postProcessMappedTuple(Tuple var1, Collection<String> var2, Collection<String> var3) throws RecordAndTableSchemaMismatchException;

    private static class ColumnMapping {
        final ClientColumn column;
        final String objectFieldName;

        public ColumnMapping(ClientColumn column, String objectFieldName) {
            this.column = column;
            this.objectFieldName = objectFieldName;
        }

        public Class<?> columnType() {
            return this.column.type().javaClass();
        }
    }

    private static class TypeProcessingResult {
        final List<ColumnMapping> availableMappings;
        final Map<String, Integer> nameToIdMap;
        final List<String> missingColumnsOnType;
        final List<String> additionalFieldsOnType;

        public TypeProcessingResult(List<ColumnMapping> availableMappings, List<String> missingColumnsOnType, List<String> additionalFieldsOnType, Map<String, Integer> nameToIdMap) {
            this.availableMappings = availableMappings;
            this.missingColumnsOnType = missingColumnsOnType;
            this.additionalFieldsOnType = additionalFieldsOnType;
            this.nameToIdMap = nameToIdMap;
        }

        CustomTupleImpl createTuple() {
            return new CustomTupleImpl(this.nameToIdMap);
        }
    }

    private static class BinaryObjectSerializer
    extends StdSerializer<BinaryObject> {
        protected BinaryObjectSerializer() {
            super(BinaryObject.class);
        }

        public void serialize(BinaryObject object, JsonGenerator generator, SerializerProvider provider) throws IOException {
            BinaryType type = object.type();
            if (type.isEnum()) {
                generator.writeString(object.enumName());
            } else {
                generator.writeStartObject();
                for (String fieldName : type.fieldNames()) {
                    Object val = object.field(fieldName);
                    generator.writeObjectField(fieldName, val);
                }
                generator.writeEndObject();
            }
        }
    }

    public static class WrapperClass {
        final BinaryObjectImpl cacheObject;
        final List<String> fields;

        public WrapperClass(BinaryObjectImpl cacheObject, List<String> fields) {
            this.cacheObject = cacheObject;
            this.fields = fields;
        }
    }

    private static class WrapperClassSerializer
    extends StdSerializer<WrapperClass> {
        protected WrapperClassSerializer() {
            super(WrapperClass.class);
        }

        public void serialize(WrapperClass object, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            for (String fieldName : object.fields) {
                generator.writeObjectField(fieldName, object.cacheObject.field(fieldName));
            }
            generator.writeEndObject();
        }
    }

    public static class RecordMappingException
    extends Exception {
        public RecordMappingException(String message) {
            super(message);
        }

        public static RecordMappingException createUnexpectedRecordTypeError(Class<?> expected, Class<?> found) {
            return new RecordMappingException("Unexpected record type: Expected '" + expected.getName() + "' found '" + found.getName() + "'");
        }
    }
}

