/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.demo.plugin;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.demo.plugin.WebHookBasedAuthProvider;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTTAction;
import org.apache.bifromq.plugin.authprovider.type.Reject;
import org.apache.bifromq.type.ClientInfo;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DemoAuthProvider
implements IAuthProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DemoAuthProvider.class);
    private static final String PLUGIN_AUTHPROVIDER_URL = "plugin.authprovider.url";
    private final IAuthProvider delegate;

    public DemoAuthProvider() {
        Object delegate1;
        String webhookUrl = System.getProperty(PLUGIN_AUTHPROVIDER_URL);
        if (webhookUrl == null) {
            log.info("No webhook url specified, the fallback behavior will reject all auth/check requests.");
            delegate1 = new FallbackAuthProvider();
        } else {
            try {
                URI webhookURI = URI.create(webhookUrl);
                delegate1 = new WebHookBasedAuthProvider(webhookURI);
                log.info("DemoAuthProvider's webhook URL: {}", (Object)webhookUrl);
            }
            catch (Throwable e) {
                delegate1 = new FallbackAuthProvider();
            }
        }
        this.delegate = delegate1;
    }

    public CompletableFuture<MQTT3AuthResult> auth(MQTT3AuthData authData) {
        return this.delegate.auth(authData);
    }

    public CompletableFuture<Boolean> check(ClientInfo client, MQTTAction action) {
        return this.delegate.check(client, action);
    }

    static class FallbackAuthProvider
    implements IAuthProvider {
        FallbackAuthProvider() {
        }

        public CompletableFuture<MQTT3AuthResult> auth(MQTT3AuthData authData) {
            return CompletableFuture.completedFuture(MQTT3AuthResult.newBuilder().setReject(Reject.newBuilder().setCode(Reject.Code.Error).setReason("No webhook url for auth provider configured").build()).build());
        }

        public CompletableFuture<Boolean> check(ClientInfo client, MQTTAction action) {
            return CompletableFuture.completedFuture(false);
        }
    }
}

