/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.IRaftNode;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.MetricMonitoredStateStore;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.RaftNodeState;
import org.apache.bifromq.basekv.raft.RaftNodeStateFollower;
import org.apache.bifromq.basekv.raft.event.RaftEvent;
import org.apache.bifromq.basekv.raft.event.RaftEventType;
import org.apache.bifromq.basekv.raft.exception.InternalError;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.RaftMessage;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

public final class RaftNode
implements IRaftNode {
    private final String id;
    private final IRaftStateStore stateStorage;
    private final RaftConfig config;
    private final Logger log;
    private final ExecutorService raftExecutor;
    private final AtomicReference<RaftNodeState> stateRef = new AtomicReference();
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.INIT);
    private final AtomicReference<CompletableFuture<Void>> stopFuture = new AtomicReference();
    private final String[] tags;
    private MetricManager metricMgr;

    public RaftNode(RaftConfig config, IRaftStateStore stateStore, ThreadFactory threadFactory, String ... tags) {
        this.verifyTags(tags);
        this.verifyConfig(config);
        this.verifyStateStore(stateStore);
        this.log = MDCLogger.getLogger(RaftNode.class, (String[])tags);
        this.tags = tags;
        this.stateStorage = new MetricMonitoredStateStore(stateStore, Tags.of((String[])tags));
        this.id = this.stateStorage.local();
        this.config = config.toBuilder().build();
        this.raftExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), threadFactory), (String)this.id, (String)"raft", (Iterable)Tags.of((String[])tags));
        stateStore.addStableListener(this::onStabilized);
    }

    @Override
    public boolean isStarted() {
        return this.status.get() == Status.STARTED;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public RaftNodeStatus status() {
        this.checkStarted();
        return this.stateRef.get().getState();
    }

    @Override
    public void tick() {
        this.submit(() -> {
            RaftNodeState state = this.stateRef.get();
            Timer.Sample sample = Timer.start();
            String leader = state.currentLeader();
            RaftNodeState nextState = state.tick();
            sample.stop(this.metricMgr.tickTimer);
            if (nextState != state) {
                this.stateRef.set(nextState);
                nextState.notifyStateChanged();
            }
            if (nextState.currentLeader() != null && !nextState.currentLeader().equals(leader)) {
                nextState.notifyLeaderElected(nextState.currentLeader(), nextState.currentTerm());
            }
        });
    }

    @Override
    public CompletableFuture<Long> propose(ByteString appCommand) {
        return this.submit((CompletableFuture<T> onDone) -> this.stateRef.get().propose(appCommand, this.sampleLatency((CompletableFuture)onDone, this.metricMgr.proposeTimer)));
    }

    private void onStabilized(long stableIndex) {
        this.submit(() -> {
            Timer.Sample sample = Timer.start();
            RaftNodeState state = this.stateRef.get();
            String leader = state.currentLeader();
            RaftNodeState nextState = state.stableTo(stableIndex);
            sample.stop(this.metricMgr.stableToTimer);
            if (nextState != state) {
                this.stateRef.set(nextState);
                nextState.notifyStateChanged();
            }
            if (nextState.currentLeader() != null && !nextState.currentLeader().equals(leader)) {
                nextState.notifyLeaderElected(nextState.currentLeader(), nextState.currentTerm());
            }
        });
    }

    @Override
    public CompletableFuture<Long> readIndex() {
        return this.submit((CompletableFuture<T> onDone) -> this.stateRef.get().readIndex(this.sampleLatency((CompletableFuture)onDone, this.metricMgr.readIndexTimer)));
    }

    @Override
    public void receive(String fromPeer, RaftMessage message) {
        this.submit(() -> {
            RaftNodeState state = this.stateRef.get();
            String leader = state.currentLeader();
            Timer.Sample sample = Timer.start();
            RaftNodeState nextState = state.receive(fromPeer, message);
            sample.stop(this.metricMgr.peerMsgHandlingTimer);
            if (nextState != state) {
                this.stateRef.set(nextState);
                nextState.notifyStateChanged();
            }
            if (nextState.currentLeader() != null && !nextState.currentLeader().equals(leader)) {
                nextState.notifyLeaderElected(nextState.currentLeader(), nextState.currentTerm());
            }
        });
    }

    @Override
    public CompletableFuture<Void> compact(ByteString fsmSnapshot, long compactIndex) {
        return this.submit((CompletableFuture<T> onDone) -> this.stateRef.get().compact(fsmSnapshot, compactIndex, this.sampleLatency((CompletableFuture)onDone, this.metricMgr.compactTimer)));
    }

    @Override
    public CompletableFuture<Void> transferLeadership(String newLeader) {
        return this.submit((CompletableFuture<T> onDone) -> this.stateRef.get().transferLeadership(newLeader, this.sampleLatency((CompletableFuture)onDone, this.metricMgr.transferLeadershipTimer)));
    }

    @Override
    public CompletableFuture<Void> recover() {
        return this.submit((CompletableFuture<T> onDone) -> this.stateRef.get().recover((CompletableFuture<Void>)onDone));
    }

    @Override
    public ClusterConfig latestClusterConfig() {
        return (ClusterConfig)this.unwrap(this.submit((CompletableFuture<T> onDone) -> onDone.complete(this.stateRef.get().latestClusterConfig())));
    }

    @Override
    public Boolean stepDown() {
        return (Boolean)this.unwrap(this.submit((CompletableFuture<T> onDone) -> {
            RaftNodeState state = this.stateRef.get();
            RaftNodeState nextState = state.stepDown();
            if (nextState != state) {
                this.stateRef.set(nextState);
                onDone.complete(true);
            } else {
                onDone.complete(false);
            }
        }));
    }

    @Override
    public ByteString latestSnapshot() {
        return (ByteString)this.unwrap(this.submit((CompletableFuture<T> onDone) -> onDone.complete(this.stateRef.get().latestSnapshot())));
    }

    @Override
    public CompletableFuture<Void> changeClusterConfig(String correlateId, Set<String> nextVoters, Set<String> nextLearners) {
        return this.submit((CompletableFuture<T> onDone) -> this.stateRef.get().changeClusterConfig(correlateId, nextVoters, nextLearners, this.sampleLatency((CompletableFuture)onDone, this.metricMgr.changeClusterConfigTimer)));
    }

    @Override
    public CompletableFuture<ILogEntryIterator> retrieveCommitted(long fromIndex, long maxSize) {
        return this.submit((CompletableFuture<T> onDone) -> this.stateRef.get().retrieveCommitted(fromIndex, maxSize, this.sampleLatency((CompletableFuture)onDone, this.metricMgr.retrieveEntriesTimer)));
    }

    @Override
    public void start(@NonNull IRaftNode.IRaftMessageSender sender, @NonNull IRaftNode.IRaftEventListener listener, @NonNull IRaftNode.ISnapshotInstaller installer) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (installer == null) {
            throw new NullPointerException("installer is marked non-null but is null");
        }
        if (this.status.compareAndSet(Status.INIT, Status.STARTING)) {
            long currentTerm = this.stateStorage.currentTerm();
            this.stateRef.set(new RaftNodeStateFollower(currentTerm, 0L, null, this.config, this.stateStorage, (IRaftNode.IRaftMessageSender)new SampledRaftMessageListener(sender), (IRaftNode.IRaftEventListener)new SampledRaftEventListener(listener), (IRaftNode.ISnapshotInstaller)new SampledSnapshotInstaller(installer), this::onSnapshotRestored, this.tags));
            this.metricMgr = new MetricManager(Tags.of((String[])this.tags));
            this.status.set(Status.STARTED);
            this.log.debug("Raft node[{}] started: term={}", (Object)this.id(), (Object)currentTerm);
        }
    }

    @Override
    public CompletableFuture<Void> stop() {
        return switch (this.status.get()) {
            case Status.INIT, Status.STARTING -> CompletableFuture.failedFuture(new IllegalStateException("Raft node not started"));
            default -> {
                if (this.stopFuture.compareAndSet(null, new CompletableFuture())) {
                    this.log.debug("Stopping raft node[{}]", (Object)this.id());
                    CompletableFuture lastTask = new CompletableFuture();
                    lastTask.whenComplete((v, e) -> {
                        this.raftExecutor.shutdown();
                        this.stopFuture.get().complete(null);
                    });
                    Runnable stop = () -> {
                        assert (this.status.get() == Status.STARTED);
                        this.status.set(Status.STOPPING);
                        this.stateRef.get().stop();
                        this.stateStorage.stop();
                        this.metricMgr.close();
                        this.status.set(Status.STOPPED);
                        this.log.debug("Raft node[{}] stopped", (Object)this.id());
                        lastTask.complete(null);
                    };
                    this.raftExecutor.execute(stop);
                }
                yield this.stopFuture.get();
            }
        };
    }

    CompletableFuture<Void> onSnapshotRestored(ByteString requested, ByteString installed, Throwable ex) {
        return this.submit((CompletableFuture<T> onDone) -> this.stateRef.get().onSnapshotRestored(requested, installed, ex, (CompletableFuture<Void>)onDone));
    }

    private void submit(Runnable task) {
        this.submit((CompletableFuture<T> onDone) -> {
            task.run();
            onDone.complete(null);
        });
    }

    private <T> CompletableFuture<T> submit(Consumer<CompletableFuture<T>> task) {
        CompletableFuture doneFuture = new CompletableFuture();
        try {
            this.raftExecutor.execute(() -> {
                switch (this.status.get()) {
                    case INIT: 
                    case STARTING: {
                        doneFuture.completeExceptionally(new IllegalStateException("Raft node not started"));
                        break;
                    }
                    case STARTED: {
                        try {
                            task.accept(doneFuture);
                        }
                        catch (Throwable e) {
                            doneFuture.completeExceptionally(new InternalError(e));
                        }
                        break;
                    }
                    case STOPPING: 
                    case STOPPED: {
                        doneFuture.completeExceptionally(new IllegalStateException("Raft node has stopped"));
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            doneFuture.completeExceptionally(new IllegalStateException(e));
        }
        return doneFuture;
    }

    private void verifyConfig(RaftConfig config) {
        if (config.getHeartbeatTimeoutTick() > config.getElectionTimeoutTick()) {
            throw new IllegalArgumentException("heartbeat timeout must be less than election timeout, normally 1/10");
        }
    }

    private void verifyStateStore(IRaftStateStore stateStorage) {
        if (stateStorage.local() == null) {
            throw new IllegalArgumentException("local id cannot be null");
        }
        if (stateStorage.lastIndex() < 0L) {
            throw new IllegalArgumentException("last index must be non-negative");
        }
        if (stateStorage.firstIndex() <= 0L) {
            throw new IllegalArgumentException("first index must be positive");
        }
        if (stateStorage.latestClusterConfig() == null) {
            throw new IllegalArgumentException("latest cluster config cannot be null");
        }
        if (stateStorage.latestSnapshot() == null) {
            throw new IllegalArgumentException("latest snapshot cannot be null");
        }
        ClusterConfig clusterConfig = stateStorage.latestSnapshot().getClusterConfig();
        if (clusterConfig.getVotersList().stream().anyMatch(arg_0 -> clusterConfig.getLearnersList().contains(arg_0))) {
            throw new IllegalArgumentException("voters and learners mustn't intersect with each other");
        }
    }

    private void verifyTags(String[] tags) {
        if (tags.length % 2 != 0) {
            throw new IllegalArgumentException("Tags must be even number representing key/value pairs");
        }
    }

    private <T> T unwrap(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Future cannot be unwrapped", e);
        }
    }

    private <T> CompletableFuture<T> sampleLatency(CompletableFuture<T> future, Timer timer) {
        Timer.Sample sample = Timer.start();
        future.whenComplete((v, e) -> sample.stop(timer));
        return future;
    }

    private void checkStarted() {
        if (this.status.get() != Status.STARTED) {
            throw new IllegalStateException("Raft node not started");
        }
    }

    static enum Status {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }

    private class SampledRaftMessageListener
    implements IRaftNode.IRaftMessageSender {
        final IRaftNode.IRaftMessageSender delegate;

        SampledRaftMessageListener(IRaftNode.IRaftMessageSender delegate) {
            this.delegate = delegate;
        }

        @Override
        public void send(Map<String, List<RaftMessage>> messages) {
            Timer.Sample sample = Timer.start();
            this.delegate.send(messages);
            sample.stop(RaftNode.this.metricMgr.messageSenderTimer);
        }
    }

    private class SampledRaftEventListener
    implements IRaftNode.IRaftEventListener {
        final IRaftNode.IRaftEventListener delegate;

        private SampledRaftEventListener(IRaftNode.IRaftEventListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onEvent(RaftEvent event) {
            Timer.Sample sample = Timer.start();
            this.delegate.onEvent(event);
            sample.stop(RaftNode.this.metricMgr.eventTimers.get((Object)event.type));
        }
    }

    private class SampledSnapshotInstaller
    implements IRaftNode.ISnapshotInstaller {
        final IRaftNode.ISnapshotInstaller delegate;

        private SampledSnapshotInstaller(IRaftNode.ISnapshotInstaller delegate) {
            this.delegate = delegate;
        }

        @Override
        public void install(ByteString request, String leader, IRaftNode.IAfterInstalledCallback callback) {
            Timer.Sample start = Timer.start();
            this.delegate.install(request, leader, (snapshot, ex) -> {
                start.stop(RaftNode.this.metricMgr.snapshotInstallTimer);
                return callback.call(snapshot, ex);
            });
        }
    }

    private class MetricManager {
        final Timer tickTimer;
        final Timer proposeTimer;
        final Timer readIndexTimer;
        final Timer peerMsgHandlingTimer;
        final Timer compactTimer;
        final Timer transferLeadershipTimer;
        final Timer changeClusterConfigTimer;
        final Timer retrieveEntriesTimer;
        final Timer entryAtTimer;
        final Timer stableToTimer;
        final Timer messageSenderTimer;
        final Timer snapshotInstallTimer;
        final EnumMap<RaftEventType, Timer> eventTimers;
        final Gauge pendingProposalsGauge;
        final Gauge commitIndexGauge;
        final Gauge firstIndexGauge;
        final Gauge lastIndexGauge;
        final Gauge currentTermGauge;
        final Gauge currentStatusGauge;
        final Gauge currentRoleGauge;
        final Gauge currentVoters;
        final Gauge currentLearners;
        final Gauge currentNextVoters;
        final Gauge currentNextLearners;

        MetricManager(final Tags tags) {
            this.tickTimer = Metrics.timer((String)"raft.cmd.tick", (Iterable)tags);
            this.proposeTimer = Metrics.timer((String)"raft.cmd.propose", (Iterable)tags);
            this.readIndexTimer = Metrics.timer((String)"raft.cmd.readindex", (Iterable)tags);
            this.peerMsgHandlingTimer = Metrics.timer((String)"raft.cmd.recvmsg", (Iterable)tags);
            this.compactTimer = Metrics.timer((String)"raft.cmd.compact", (Iterable)tags);
            this.transferLeadershipTimer = Metrics.timer((String)"raft.cmd.trnsldr", (Iterable)tags);
            this.changeClusterConfigTimer = Metrics.timer((String)"raft.cmd.chgcfg", (Iterable)tags);
            this.retrieveEntriesTimer = Metrics.timer((String)"raft.cmd.getentries", (Iterable)tags);
            this.entryAtTimer = Metrics.timer((String)"raft.cmd.getentry", (Iterable)tags);
            this.stableToTimer = Metrics.timer((String)"raft.cmd.markstable", (Iterable)tags);
            this.messageSenderTimer = Metrics.timer((String)"raft.message.send", (Iterable)tags);
            this.snapshotInstallTimer = Metrics.timer((String)"raft.snapshot.install", (Iterable)tags);
            this.eventTimers = new EnumMap<RaftEventType, Timer>(new HashMap<RaftEventType, Timer>(){
                {
                    this.put(RaftEventType.ELECTION, Metrics.timer((String)"raft.event.listener", (Iterable)tags.and("type", "election")));
                    this.put(RaftEventType.COMMIT, Metrics.timer((String)"raft.event.listener", (Iterable)tags.and("type", "commit")));
                    this.put(RaftEventType.STATUS_CHANGED, Metrics.timer((String)"raft.event.listener", (Iterable)tags.and("type", "status_changed")));
                    this.put(RaftEventType.SNAPSHOT_RESTORED, Metrics.timer((String)"raft.event.listener", (Iterable)tags.and("type", "snapshot_restored")));
                    this.put(RaftEventType.SYNC_STATE_CHANGED, Metrics.timer((String)"raft.event.listener", (Iterable)tags.and("type", "sync_state_changed")));
                }
            });
            this.pendingProposalsGauge = Gauge.builder((String)"raft.cmd.propose.pending", (Object)RaftNode.this, r -> r.stateRef.get().uncommittedProposals.size()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.commitIndexGauge = Gauge.builder((String)"raft.log.commitindex", (Object)RaftNode.this, r -> r.stateRef.get().commitIndex).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.firstIndexGauge = Gauge.builder((String)"raft.log.firstindex", (Object)RaftNode.this, r -> r.stateStorage.firstIndex()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.lastIndexGauge = Gauge.builder((String)"raft.log.lastindex", (Object)RaftNode.this, r -> r.stateStorage.lastIndex()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.currentTermGauge = Gauge.builder((String)"raft.log.term", (Object)RaftNode.this, r -> r.stateRef.get().currentTerm()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.currentStatusGauge = Gauge.builder((String)"raft.status", (Object)RaftNode.this, r -> r.stateRef.get().getState().getNumber()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.currentRoleGauge = Gauge.builder((String)"raft.role", (Object)RaftNode.this, r -> {
                ClusterConfig clusterConfig = r.stateRef.get().latestClusterConfig();
                if (clusterConfig.getVotersList().contains((Object)RaftNode.this.id)) {
                    return 0.0;
                }
                if (clusterConfig.getLearnersList().contains((Object)RaftNode.this.id)) {
                    return 1.0;
                }
                if (clusterConfig.getNextVotersList().contains((Object)RaftNode.this.id)) {
                    return 2.0;
                }
                if (clusterConfig.getNextLearnersList().contains((Object)RaftNode.this.id)) {
                    return 3.0;
                }
                return 4.0;
            }).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.currentVoters = Gauge.builder((String)"raft.voters.current", (Object)RaftNode.this, r -> r.stateRef.get().latestClusterConfig().getVotersCount()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.currentLearners = Gauge.builder((String)"raft.learners.current", (Object)RaftNode.this, r -> r.stateRef.get().latestClusterConfig().getLearnersCount()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.currentNextVoters = Gauge.builder((String)"raft.voters.next", (Object)RaftNode.this, r -> r.stateRef.get().latestClusterConfig().getNextVotersCount()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.currentNextLearners = Gauge.builder((String)"raft.learners.next", (Object)RaftNode.this, r -> r.stateRef.get().latestClusterConfig().getNextLearnersCount()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        }

        void close() {
            Metrics.globalRegistry.removeByPreFilterId(this.tickTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.proposeTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.readIndexTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.peerMsgHandlingTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.compactTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.transferLeadershipTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.changeClusterConfigTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.retrieveEntriesTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.entryAtTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.stableToTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.messageSenderTimer.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.snapshotInstallTimer.getId());
            this.eventTimers.forEach((e, t) -> Metrics.globalRegistry.removeByPreFilterId(t.getId()));
            Metrics.globalRegistry.removeByPreFilterId(this.pendingProposalsGauge.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.commitIndexGauge.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.firstIndexGauge.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.lastIndexGauge.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.currentTermGauge.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.currentStatusGauge.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.currentRoleGauge.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.currentVoters.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.currentLearners.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.currentNextVoters.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.currentNextLearners.getId());
        }
    }
}

