/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.server.scheduler;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.retain.store.schema.KVSchemaUtil;
import org.apache.bifromq.retain.store.schema.LevelHash;
import org.apache.bifromq.util.TopicUtil;

class MatchCallRangeRouter {
    MatchCallRangeRouter() {
    }

    public static Map<KVRangeSetting, Set<String>> rangeLookup(String tenantId, Set<String> topicFilters, NavigableMap<Boundary, KVRangeSetting> effectiveRouter) {
        HashMap<KVRangeSetting, Set<String>> topicFiltersByRange = new HashMap<KVRangeSetting, Set<String>>();
        for (String topicFilter : topicFilters) {
            assert (TopicUtil.isNormalTopicFilter((String)topicFilter));
            if (TopicUtil.isWildcardTopicFilter((String)topicFilter)) {
                Collection<Object> rangeSettingList;
                boolean isFixedLevelMatch = !TopicUtil.isMultiWildcardTopicFilter((String)topicFilter);
                List filterLevels = TopicUtil.parse((String)topicFilter, (boolean)false);
                List filterPrefix = KVSchemaUtil.filterPrefix((List)filterLevels);
                short levels = (short)(isFixedLevelMatch ? filterLevels.size() : filterLevels.size() - 1);
                if (isFixedLevelMatch) {
                    ByteString startKey = KVSchemaUtil.retainKeyPrefix((String)tenantId, (short)levels, (List)filterPrefix);
                    Boundary topicBoundary = BoundaryUtil.toBoundary((ByteString)startKey, (ByteString)BoundaryUtil.upperBound((ByteString)startKey));
                    rangeSettingList = KVRangeRouterUtil.findByBoundary((Boundary)topicBoundary, effectiveRouter);
                } else if (filterPrefix.isEmpty()) {
                    Boundary topicBoundary = Boundary.newBuilder().setStartKey(KVSchemaUtil.retainKeyPrefix((String)tenantId, (short)levels, (List)filterPrefix)).setEndKey(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.tenantBeginKey((String)tenantId))).build();
                    rangeSettingList = KVRangeRouterUtil.findByBoundary((Boundary)topicBoundary, effectiveRouter);
                } else {
                    rangeSettingList = MatchCallRangeRouter.findCandidates(tenantId, levels, filterPrefix, effectiveRouter);
                }
                for (KVRangeSetting rangeSetting : rangeSettingList) {
                    topicFiltersByRange.computeIfAbsent(rangeSetting, k -> new HashSet()).add(topicFilter);
                }
                continue;
            }
            ByteString retainKey = KVSchemaUtil.retainMessageKey((String)tenantId, (String)topicFilter);
            Optional rangeSetting = KVRangeRouterUtil.findByKey((ByteString)retainKey, effectiveRouter);
            assert (rangeSetting.isPresent());
            topicFiltersByRange.computeIfAbsent((KVRangeSetting)rangeSetting.get(), k -> new HashSet()).add(topicFilter);
        }
        return topicFiltersByRange;
    }

    private static List<KVRangeSetting> findCandidates(String tenantId, short levels, List<String> filterPrefix, NavigableMap<Boundary, KVRangeSetting> effectiveRouter) {
        ByteString retainKeyPrefixBegin = KVSchemaUtil.retainKeyPrefix((String)tenantId, (short)levels, filterPrefix);
        ByteString levelHash = LevelHash.hash(filterPrefix);
        ByteString retainKeyPrefixEnd = BoundaryUtil.upperBound((ByteString)KVSchemaUtil.tenantBeginKey((String)tenantId));
        Boundary topicBoundary = Boundary.newBuilder().setStartKey(retainKeyPrefixBegin).setEndKey(retainKeyPrefixEnd).build();
        Collection allCandidates = KVRangeRouterUtil.findByBoundary((Boundary)topicBoundary, effectiveRouter);
        ArrayList<KVRangeSetting> candidates = new ArrayList<KVRangeSetting>(allCandidates.size());
        for (KVRangeSetting rangeSetting : allCandidates) {
            Boundary candidateBoundary = rangeSetting.boundary();
            ByteString candidateStartKey = BoundaryUtil.startKey((Boundary)candidateBoundary);
            ByteString candidateEndKey = BoundaryUtil.endKey((Boundary)candidateBoundary);
            if (BoundaryUtil.compareStartKey((ByteString)candidateStartKey, (ByteString)retainKeyPrefixBegin) > 0 && BoundaryUtil.compare((ByteString)BoundaryUtil.upperBound((ByteString)levelHash), (ByteString)KVSchemaUtil.parseLevelHash((ByteString)candidateStartKey)) <= 0 || BoundaryUtil.compareEndKeys((ByteString)candidateEndKey, (ByteString)retainKeyPrefixEnd) <= 0 && BoundaryUtil.compare((ByteString)KVSchemaUtil.parseLevelHash((ByteString)candidateEndKey), (ByteString)levelHash) <= 0) continue;
            candidates.add(rangeSetting);
        }
        return candidates;
    }
}

