/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.ExecuteRetInfo;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.ConvertUtil;
import java.util.Calendar;

public class DmdbResultSetCache {
    private long m_lastChkTime;
    private long[] m_TbIds = null;
    private long[] m_TbTss = null;
    public ExecuteRetInfo execInfo;

    DmdbResultSetCache(ExecuteRetInfo executeRetInfo) {
        this.execInfo = executeRetInfo;
        this.m_TbIds = (long[])executeRetInfo.tbIds.clone();
        this.m_TbTss = (long[])executeRetInfo.tbTss.clone();
        this.m_lastChkTime = Calendar.getInstance().getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean refreshed(DmdbConnection dmdbConnection) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            int n2;
            if (dmdbConnection.rsRefreshFreq == 0) {
                return false;
            }
            if (this.m_lastChkTime + (long)(dmdbConnection.rsRefreshFreq * 1000) > Calendar.getInstance().getTimeInMillis()) {
                return false;
            }
            long[] lArray = dmdbConnection.dbAccess.a(dmdbConnection, this.m_TbIds);
            this.m_lastChkTime = Calendar.getInstance().getTimeInMillis();
            int n3 = n2 = lArray == null ? 0 : lArray.length;
            if (n2 != this.m_TbTss.length) {
                return true;
            }
            int n4 = 0;
            while (true) {
                if (n4 >= n2) {
                    return false;
                }
                if (this.m_TbTss[n4] != lArray[n4]) {
                    return true;
                }
                ++n4;
            }
        }
    }

    DmdbResultSet getResultSet(DmdbStatement dmdbStatement) {
        int n2;
        Object object = this.execInfo.rsDatas;
        int n3 = n2 = this.execInfo.rsDatas == null ? 0 : this.execInfo.rsDatas.length;
        if (dmdbStatement.maxRows > 0L && dmdbStatement.maxRows < (long)n2) {
            object = new byte[ConvertUtil.toInt(dmdbStatement.maxRows)][][];
            System.arraycopy(this.execInfo.rsDatas, 0, object, 0, ((byte[][][])object).length);
        }
        DmdbResultSet dmdbResultSet = DmdbResultSet.newLocalResultSet(dmdbStatement, dmdbStatement.columns, object);
        dmdbResultSet.id = 1;
        return dmdbResultSet;
    }

    long getLastChkTime() {
        return this.m_lastChkTime;
    }

    long getDataLen() {
        return this.execInfo.rsSizeof;
    }
}

